/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.util.LogTaskListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.TestCliGitAPIImpl;
import org.jenkinsci.plugins.workflow.cps.CpsFlowDefinition;
import org.jenkinsci.plugins.workflow.flow.FlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class PruneStaleTagPipelineTest {
    @Rule
    public TemporaryFolder fileRule = new TemporaryFolder();
    @Rule
    public JenkinsRule j = new JenkinsRule();
    private TaskListener listener;

    @Before
    public void setup() throws Exception {
        this.listener = new LogTaskListener(Logger.getLogger("prune tags"), Level.FINEST);
    }

    @Test
    public void verify_that_local_tag_is_pruned_when_not_exist_on_remote_using_pipeline() throws Exception {
        File remoteRepo = this.fileRule.newFolder("remote");
        GitClient remoteClient = this.initRepository(remoteRepo);
        String tagName = "tag";
        String tagComment = "tag comment";
        remoteClient.tag(tagName, tagComment);
        WorkflowJob job = (WorkflowJob)this.j.jenkins.createProject(WorkflowJob.class, "pruneTags");
        FilePath workspace = this.j.jenkins.getWorkspaceFor((TopLevelItem)job);
        String remoteURL = "file://" + remoteRepo.toURI().getPath();
        job.setDefinition((FlowDefinition)new CpsFlowDefinition("  node {\n    checkout([$class: 'GitSCM',             branches: [[name: '*/master']],             extensions: [pruneTags(true)],             userRemoteConfigs: [[url: '" + remoteURL + "']]    ])  }\n", true));
        WorkflowRun r = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart();
        this.j.assertBuildStatus(Result.SUCCESS, this.j.waitForCompletion((Run)r));
        remoteClient.deleteTag(tagName);
        r = (WorkflowRun)job.scheduleBuild2(0, new Action[0]).waitForStart();
        this.j.assertBuildStatus(Result.SUCCESS, this.j.waitForCompletion((Run)r));
        GitClient localClient = this.newGitClient(new File(workspace.getRemote()));
        Assert.assertFalse((String)"local tag has not been pruned", (boolean)localClient.tagExists(tagName));
    }

    private GitClient newGitClient(File localRepo) {
        String gitExe = Functions.isWindows() ? "git.exe" : "git";
        TestCliGitAPIImpl localClient = new TestCliGitAPIImpl(gitExe, localRepo, this.listener, new EnvVars());
        return localClient;
    }

    private GitClient initRepository(File workspace) throws Exception {
        GitClient remoteClient = this.newGitClient(workspace);
        remoteClient.init();
        FileUtils.touch((File)new File(workspace, "test"));
        remoteClient.add("test");
        remoteClient.commit("initial commit");
        return remoteClient;
    }
}

