/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitLab;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class GitLabTest {
    private static final String GITLAB_URL = "https://SERVER/USER/REPO/";
    private final GitLab gitlab29 = new GitLab("https://SERVER/USER/REPO/", "2.9");
    private final GitLab gitlab42 = new GitLab("https://SERVER/USER/REPO/", "4.2");
    private final GitLab gitlab50 = new GitLab("https://SERVER/USER/REPO/", "5.0");
    private final GitLab gitlab51 = new GitLab("https://SERVER/USER/REPO/", "5.1");
    private final GitLab gitlab711 = new GitLab("https://SERVER/USER/REPO/", "7.11");
    private final GitLab gitlab7114ee = new GitLab("https://SERVER/USER/REPO/", "7.11");
    private final GitLab gitlab80 = new GitLab("https://SERVER/USER/REPO/", "8.0");
    private final GitLab gitlab87 = new GitLab("https://SERVER/USER/REPO/", "8.7");
    private final GitLab gitlabDefault = new GitLab("https://SERVER/USER/REPO/");
    private final GitLab gitlabNaN = new GitLab("https://SERVER/USER/REPO/", "NaN");
    private final GitLab gitlabInfinity = new GitLab("https://SERVER/USER/REPO/", "Infinity");
    private final GitLab gitlabNegative = new GitLab("https://SERVER/USER/REPO/", "-1");
    private final GitLab gitlabGreater = new GitLab("https://SERVER/USER/REPO/", "9999");
    private final String SHA1 = "396fc230a3db05c427737aa5c2eb7856ba72b05d";
    private final String fileName = "src/main/java/hudson/plugins/git/browser/GithubWeb.java";
    private final Random random = new Random();

    @Test
    public void testGetVersion() {
        Assert.assertEquals((Object)"2.9", (Object)this.gitlab29.getVersion());
        Assert.assertEquals((Object)"4.2", (Object)this.gitlab42.getVersion());
        Assert.assertEquals((Object)"5.0", (Object)this.gitlab50.getVersion());
        Assert.assertEquals((Object)"5.1", (Object)this.gitlab51.getVersion());
        Assert.assertEquals((Object)"8.7", (Object)this.gitlab87.getVersion());
        Assert.assertNull((Object)this.gitlabDefault.getVersion());
        Assert.assertNull((Object)this.gitlabNaN.getVersion());
        Assert.assertNull((Object)this.gitlabInfinity.getVersion());
        Assert.assertEquals((Object)"-1.0", (Object)this.gitlabNegative.getVersion());
        Assert.assertEquals((Object)"9999.0", (Object)this.gitlabGreater.getVersion());
    }

    @Test
    public void testGetVersionDouble() {
        Assert.assertEquals((double)2.9, (double)this.gitlab29.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)4.2, (double)this.gitlab42.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)5.0, (double)this.gitlab50.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)5.1, (double)this.gitlab51.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)8.7, (double)this.gitlab87.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.gitlabDefault.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.gitlabNaN.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.gitlabInfinity.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)-1.0, (double)this.gitlabNegative.getVersionDouble(), (double)0.001);
        Assert.assertEquals((double)9999.0, (double)this.gitlabGreater.getVersionDouble(), (double)0.001);
    }

    @Test
    public void testGetChangeSetLinkGitChangeSet() throws Exception {
        GitChangeSet changeSet = this.createChangeSet("rawchangelog");
        String expectedURL = "https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d";
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d".replace("commit/", "commits/"), (Object)this.gitlab29.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlab42.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlab50.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlab51.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlab711.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlab7114ee.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlabDefault.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlabNaN.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlabInfinity.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d".replace("commit/", "commits/"), (Object)this.gitlabNegative.getChangeSetLink(changeSet).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)this.gitlabGreater.getChangeSetLink(changeSet).toString());
    }

    @Test
    public void testGetDiffLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path modified1 = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        String expectedPre30 = "https://SERVER/USER/REPO/commits/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java";
        String expectedPre80 = "https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java";
        String expectedURL = "https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0";
        String expectedDefault = "https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0";
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commits/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlabNegative.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commits/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab29.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab42.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab50.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab51.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab711.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab7114ee.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0", (Object)this.gitlab80.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0", (Object)this.gitlabGreater.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0", (Object)this.gitlabDefault.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0", (Object)this.gitlabNaN.getDiffLink(modified1).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/396fc230a3db05c427737aa5c2eb7856ba72b05d#diff-0", (Object)this.gitlabInfinity.getDiffLink(modified1).toString());
    }

    @Test
    public void testGetFileLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        String expectedURL = "https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java";
        String expectedV29 = "https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java".replace("blob/", "tree/");
        String expectedV50 = "https://SERVER/USER/REPO/396fc230a3db05c427737aa5c2eb7856ba72b05d/tree/src/main/java/hudson/plugins/git/browser/GithubWeb.java";
        Assert.assertEquals((Object)expectedV29, (Object)this.gitlabNegative.getFileLink(path).toString());
        Assert.assertEquals((Object)expectedV29, (Object)this.gitlab29.getFileLink(path).toString());
        Assert.assertEquals((Object)expectedV29, (Object)this.gitlab42.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/396fc230a3db05c427737aa5c2eb7856ba72b05d/tree/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab50.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab51.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab711.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlab7114ee.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlabDefault.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlabNaN.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlabInfinity.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/blob/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.gitlabGreater.getFileLink(path).toString());
    }

    @Test
    public void testGetFileLinkPathForDeletedFile() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-deleted-file");
        String fileName = "bar";
        GitChangeSet.Path path = pathMap.get("bar");
        String SHA1 = "fc029da233f161c65eb06d0f1ed4f36ae81d1f4f";
        String expectedPre30 = "https://SERVER/USER/REPO/commits/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar";
        String expectedPre80 = "https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar";
        String expectedURL = "https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0";
        String expectedDefault = "https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0";
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commits/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlabNegative.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commits/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlab29.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlab42.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlab50.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlab51.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlab711.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#bar", (Object)this.gitlab7114ee.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0", (Object)this.gitlab80.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0", (Object)this.gitlabGreater.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0", (Object)this.gitlabDefault.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0", (Object)this.gitlabNaN.getFileLink(path).toString());
        Assert.assertEquals((Object)"https://SERVER/USER/REPO/commit/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f#diff-0", (Object)this.gitlabInfinity.getFileLink(path).toString());
    }

    private GitChangeSet createChangeSet(String rawchangelogpath) throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(this.random.nextBoolean() ? "Default" : "jgit").getClient();
        GitChangeLogParser logParser = new GitChangeLogParser(gitClient, false);
        List changeSetList = logParser.parse(GitLabTest.class.getResourceAsStream(rawchangelogpath));
        return (GitChangeSet)changeSetList.get(0);
    }

    private HashMap<String, GitChangeSet.Path> createPathMap(String changelog) throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = new HashMap<String, GitChangeSet.Path>();
        Collection changeSet = this.createChangeSet(changelog).getPaths();
        for (GitChangeSet.Path path : changeSet) {
            pathMap.put(path.getPath(), path);
        }
        return pathMap;
    }
}

