/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitBranchSCMHead;
import jenkins.plugins.git.GitBranchSCMRevision;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.plugins.git.Messages;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTrait;
import jenkins.plugins.git.traits.GitSCMExtensionTraitDescriptor;
import jenkins.plugins.git.traits.GitToolSCMSourceTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import jenkins.scm.api.trait.SCMHeadPrefilter;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import jenkins.scm.impl.trait.WildcardSCMHeadFilterTrait;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GitSCMSource
extends AbstractGitSCMSource {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final Logger LOGGER = Logger.getLogger(GitSCMSource.class.getName());
    private final String remote;
    @CheckForNull
    private String credentialsId;
    @Deprecated
    private transient String remoteName;
    @Deprecated
    private transient String rawRefSpecs;
    @Deprecated
    private transient String includes;
    @Deprecated
    private transient String excludes;
    @Deprecated
    private transient boolean ignoreOnPushNotifications;
    @Deprecated
    private transient GitRepositoryBrowser browser;
    @Deprecated
    private transient String gitTool;
    @Deprecated
    private transient List<GitSCMExtension> extensions;
    private List<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();

    @DataBoundConstructor
    public GitSCMSource(String remote) {
        this.remote = remote;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @DataBoundSetter
    public void setTraits(List<SCMSourceTrait> traits) {
        this.traits = SCMTrait.asSetList(traits);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public GitSCMSource(String id, String remote, String credentialsId, String remoteName, String rawRefSpecs, String includes, String excludes, boolean ignoreOnPushNotifications) {
        super(id);
        RefSpecsSCMSourceTrait trait;
        this.remote = remote;
        this.credentialsId = credentialsId;
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
        traits.add(new BranchDiscoveryTrait());
        if (!DEFAULT_INCLUDES.equals(includes) || !DEFAULT_EXCLUDES.equals(excludes)) {
            traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(includes, excludes));
        }
        if (!"origin".equals(remoteName) && StringUtils.isNotBlank((String)remoteName)) {
            traits.add(new RemoteNameSCMSourceTrait(remoteName));
        }
        if (ignoreOnPushNotifications) {
            traits.add(new IgnoreOnPushNotificationTrait());
        }
        if ((trait = this.asRefSpecsSCMSourceTrait(rawRefSpecs, remoteName)) != null) {
            traits.add(trait);
        }
        this.setTraits(traits);
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="3.4.0")
    public GitSCMSource(String id, String remote, String credentialsId, String includes, String excludes, boolean ignoreOnPushNotifications) {
        this(id, remote, credentialsId, null, null, includes, excludes, ignoreOnPushNotifications);
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.traits == null) {
            RefSpecsSCMSourceTrait trait;
            ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>();
            traits.add(new BranchDiscoveryTrait());
            if (this.includes != null && !DEFAULT_INCLUDES.equals(this.includes) || this.excludes != null && !DEFAULT_EXCLUDES.equals(this.excludes)) {
                traits.add((SCMSourceTrait)new WildcardSCMHeadFilterTrait(this.includes, this.excludes));
            }
            if (this.extensions != null) {
                block2: for (GitSCMExtension extension : this.extensions) {
                    for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                        GitSCMExtensionTraitDescriptor descriptor;
                        if (d instanceof GitSCMExtensionTraitDescriptor && (descriptor = (GitSCMExtensionTraitDescriptor)d).getExtensionClass().isInstance((Object)extension)) {
                            try {
                                SCMSourceTrait trait2 = descriptor.convertToTrait(extension);
                                if (trait2 != null) {
                                    traits.add(trait2);
                                    continue block2;
                                }
                            }
                            catch (UnsupportedOperationException e) {
                                LOGGER.log(Level.WARNING, "Could not convert " + ((Object)((Object)extension)).getClass().getName() + " to a trait", e);
                            }
                        }
                        LOGGER.log(Level.FINE, "Could not convert {0} to a trait (likely because this option does not make sense for a GitSCMSource)", ((Object)((Object)this)).getClass().getName());
                    }
                }
            }
            if (this.remoteName != null && !"origin".equals(this.remoteName) && StringUtils.isNotBlank((String)this.remoteName)) {
                traits.add(new RemoteNameSCMSourceTrait(this.remoteName));
            }
            if (StringUtils.isNotBlank((String)this.gitTool)) {
                traits.add(new GitToolSCMSourceTrait(this.gitTool));
            }
            if (this.browser != null) {
                traits.add(new GitBrowserSCMSourceTrait(this.browser));
            }
            if (this.ignoreOnPushNotifications) {
                traits.add(new IgnoreOnPushNotificationTrait());
            }
            if ((trait = this.asRefSpecsSCMSourceTrait(this.rawRefSpecs, this.remoteName)) != null) {
                traits.add(trait);
            }
            this.setTraits(traits);
        }
        return this;
    }

    private RefSpecsSCMSourceTrait asRefSpecsSCMSourceTrait(String rawRefSpecs, String remoteName) {
        if (rawRefSpecs != null) {
            HashSet<String> defaults = new HashSet<String>();
            defaults.add("+refs/heads/*:refs/remotes/origin/*");
            if (remoteName != null) {
                defaults.add("+refs/heads/*:refs/remotes/" + remoteName + "/*");
            }
            if (!defaults.contains(rawRefSpecs.trim())) {
                ArrayList<String> templates = new ArrayList<String>();
                for (String rawRefSpec : rawRefSpecs.split(" ")) {
                    if (StringUtils.isBlank((String)rawRefSpec)) continue;
                    if (defaults.contains(rawRefSpec)) {
                        templates.add("+refs/heads/*:refs/remotes/@{remote}/*");
                        continue;
                    }
                    templates.add(rawRefSpec);
                }
                if (!templates.isEmpty()) {
                    return new RefSpecsSCMSourceTrait(templates.toArray(new String[0]));
                }
            }
        }
        return null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    public boolean isIgnoreOnPushNotifications() {
        return SCMTrait.find(this.traits, IgnoreOnPushNotificationTrait.class) != null;
    }

    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    public void setBrowser(GitRepositoryBrowser browser) {
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>(this.traits);
        Iterator iterator = traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitBrowserSCMSourceTrait)) continue;
            iterator.remove();
        }
        if (browser != null) {
            traits.add(new GitBrowserSCMSourceTrait(browser));
        }
        this.setTraits(traits);
    }

    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    public void setGitTool(String gitTool) {
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>(this.traits);
        gitTool = Util.fixEmptyAndTrim((String)gitTool);
        Iterator iterator = traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitToolSCMSourceTrait)) continue;
            iterator.remove();
        }
        if (gitTool != null) {
            traits.add(new GitToolSCMSourceTrait(gitTool));
        }
        this.setTraits(traits);
    }

    @Restricted(value={DoNotUse.class})
    @DataBoundSetter
    @Deprecated
    public void setExtensions(@CheckForNull List<GitSCMExtension> extensions) {
        ArrayList<SCMSourceTrait> traits = new ArrayList<SCMSourceTrait>(this.traits);
        Iterator iterator = traits.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof GitSCMExtensionTrait)) continue;
            iterator.remove();
        }
        block3: for (GitSCMExtension extension : Util.fixNull(extensions)) {
            for (SCMSourceTraitDescriptor d : SCMSourceTrait.all()) {
                GitSCMExtensionTraitDescriptor descriptor;
                if (d instanceof GitSCMExtensionTraitDescriptor && (descriptor = (GitSCMExtensionTraitDescriptor)d).getExtensionClass().isInstance((Object)extension)) {
                    try {
                        SCMSourceTrait trait = descriptor.convertToTrait(extension);
                        if (trait != null) {
                            traits.add(trait);
                            continue block3;
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.log(Level.WARNING, "Could not convert " + ((Object)((Object)extension)).getClass().getName() + " to a trait", e);
                    }
                }
                LOGGER.log(Level.FINE, "Could not convert {0} to a trait (likely because this option does not make sense for a GitSCMSource)", ((Object)((Object)extension)).getClass().getName());
            }
        }
        this.setTraits(traits);
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    public String getRawRefSpecs() {
        String remoteName = null;
        RefSpecsSCMSourceTrait refSpecs = null;
        for (SCMSourceTrait trait : this.traits) {
            if (trait instanceof RemoteNameSCMSourceTrait) {
                remoteName = ((RemoteNameSCMSourceTrait)trait).getRemoteName();
                if (refSpecs != null) break;
            }
            if (!(trait instanceof RefSpecsSCMSourceTrait)) continue;
            refSpecs = (RefSpecsSCMSourceTrait)trait;
            if (remoteName == null) continue;
            break;
        }
        if (remoteName == null) {
            remoteName = "origin";
        }
        if (refSpecs == null) {
            return "+refs/heads/*:refs/remotes/@{remote}/*".replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, remoteName);
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        Pattern placeholder = Pattern.compile(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER);
        for (String template : refSpecs.asStrings()) {
            if (first) {
                first = false;
            } else {
                result.append(' ');
            }
            result.append(placeholder.matcher(template).replaceAll(remoteName));
        }
        return result.toString();
    }

    @Override
    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="3.4.0")
    protected List<RefSpec> getRefSpecs() {
        return ((GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).asRefSpecs();
    }

    @Override
    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return this.traits;
    }

    @Extension
    public static class ListenerImpl
    extends GitStatus.Listener {
        @Override
        public List<GitStatus.ResponseContributor> onNotifyCommit(String origin, URIish uri, final @Nullable String sha1, List<ParameterValue> buildParameters, String ... branches) {
            boolean[] notified;
            ArrayList<GitStatus.ResponseContributor> result;
            block19: {
                result = new ArrayList<GitStatus.ResponseContributor>();
                notified = new boolean[]{false};
                try (ACLContext context = ACL.as((Authentication)ACL.SYSTEM);){
                    if (branches.length > 0) {
                        final URIish u = uri;
                        for (final String branch : branches) {
                            SCMHeadEvent.fireNow((SCMHeadEvent)new SCMHeadEvent<String>(SCMEvent.Type.UPDATED, branch, origin){

                                public boolean isMatch(@NonNull SCMNavigator navigator) {
                                    return false;
                                }

                                @NonNull
                                public String getSourceName() {
                                    return u.getHumanishName();
                                }

                                public boolean isMatch(SCMSource source) {
                                    if (source instanceof GitSCMSource) {
                                        URIish remote;
                                        GitSCMSource git = (GitSCMSource)source;
                                        GitSCMSourceContext ctx = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                                        if (ctx.ignoreOnPushNotifications()) {
                                            return false;
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return false;
                                        }
                                        if (GitStatus.looselyMatches(u, remote)) {
                                            notified[0] = true;
                                            return true;
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @NonNull
                                public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
                                    if (source instanceof GitSCMSource) {
                                        URIish remote;
                                        GitSCMSource git = (GitSCMSource)source;
                                        GitSCMSourceContext ctx = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                                        if (ctx.ignoreOnPushNotifications()) {
                                            return Collections.emptyMap();
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return Collections.emptyMap();
                                        }
                                        if (GitStatus.looselyMatches(u, remote)) {
                                            GitBranchSCMHead head = new GitBranchSCMHead(branch);
                                            for (SCMHeadPrefilter filter : ctx.prefilters()) {
                                                if (!filter.isExcluded((SCMSource)git, (SCMHead)head)) continue;
                                                return Collections.emptyMap();
                                            }
                                            return Collections.singletonMap(head, sha1 != null ? new GitBranchSCMRevision(head, sha1) : null);
                                        }
                                    }
                                    return Collections.emptyMap();
                                }

                                public boolean isMatch(@NonNull SCM scm) {
                                    return false;
                                }
                            });
                        }
                        break block19;
                    }
                    for (final SCMSourceOwner owner : SCMSourceOwners.all()) {
                        for (SCMSource source : owner.getSCMSources()) {
                            URIish remote;
                            if (!(source instanceof GitSCMSource)) continue;
                            GitSCMSource git = (GitSCMSource)source;
                            GitSCMSourceContext ctx = (GitSCMSourceContext)new GitSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(git.getTraits());
                            if (ctx.ignoreOnPushNotifications()) continue;
                            try {
                                remote = new URIish(git.getRemote());
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                            if (!GitStatus.looselyMatches(uri, remote)) continue;
                            LOGGER.info("Triggering the indexing of " + owner.getFullDisplayName() + " as a result of event from " + origin);
                            this.triggerIndexing(owner, source);
                            result.add(new GitStatus.ResponseContributor(){

                                @Override
                                public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                                    rsp.addHeader("Triggered", owner.getAbsoluteUrl());
                                }

                                @Override
                                public void writeBody(PrintWriter w) {
                                    w.println("Scheduled indexing of " + owner.getFullDisplayName());
                                }
                            });
                            notified[0] = true;
                        }
                    }
                }
            }
            if (!notified[0]) {
                result.add(new GitStatus.MessageResponseContributor("No Git consumers using SCM API plugin for: " + uri.toString()));
            }
            return result;
        }

        private void triggerIndexing(SCMSourceOwner owner, SCMSource source) {
            owner.onSCMSourceUpdated(source);
        }
    }

    @Symbol(value={"git"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.GitSCMSource_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)remote).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item context, @QueryParameter String remote, @QueryParameter String value) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((remote = Util.fixEmptyAndTrim((String)remote)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)remote).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        @Deprecated
        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="3.4.0")
        public GitSCM.DescriptorImpl getSCMDescriptor() {
            return (GitSCM.DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(GitSCM.class);
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return this.getSCMDescriptor().getExtensionDescriptors();
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return this.getSCMDescriptor().getBrowserDescriptors();
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public boolean showGitToolOptions() {
            return this.getSCMDescriptor().showGitToolOptions();
        }

        @Deprecated
        @Restricted(value={DoNotUse.class})
        @RestrictedSince(value="3.4.0")
        public ListBoxModel doFillGitToolItems() {
            return this.getSCMDescriptor().doFillGitToolItems();
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            List descriptors = SCMSourceTrait._for((SCMSourceDescriptor)this, GitSCMSourceContext.class, GitSCMBuilder.class);
            NamedArrayList.select((List)descriptors, (String)Messages.within_Repository(), (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Selection.class), NamedArrayList.withAnnotation(Discovery.class)}), (boolean)true, result);
            NamedArrayList.select((List)descriptors, (String)Messages.additional(), null, (boolean)true, result);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Collections.singletonList(new BranchDiscoveryTrait());
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT};
        }
    }
}

