/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import java.util.Objects;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CleanCheckout
extends GitSCMExtension {
    private boolean deleteUntrackedNestedRepositories;

    @DataBoundConstructor
    public CleanCheckout() {
    }

    public boolean isDeleteUntrackedNestedRepositories() {
        return this.deleteUntrackedNestedRepositories;
    }

    @DataBoundSetter
    public void setDeleteUntrackedNestedRepositories(boolean deleteUntrackedNestedRepositories) {
        this.deleteUntrackedNestedRepositories = deleteUntrackedNestedRepositories;
    }

    @Override
    public void onCheckoutCompleted(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        listener.getLogger().println("Cleaning workspace");
        git.clean(this.deleteUntrackedNestedRepositories);
        for (GitSCMExtension ext : scm.getExtensions()) {
            ext.onClean(scm, git);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CleanCheckout that = (CleanCheckout)((Object)o);
        return this.deleteUntrackedNestedRepositories == that.deleteUntrackedNestedRepositories;
    }

    public int hashCode() {
        return Objects.hash(this.deleteUntrackedNestedRepositories);
    }

    public String toString() {
        return "CleanCheckout{deleteUntrackedNestedRepositories=" + this.deleteUntrackedNestedRepositories + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Clean after checkout";
        }
    }
}

