/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.util.GitUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitToolChooser {
    private long sizeOfRepo = 0L;
    private String implementation;
    private String gitTool;
    private static final int SIZE_TO_SWITCH = 5000;
    private boolean JGIT_SUPPORTED = false;
    private static final Logger LOGGER = Logger.getLogger(GitToolChooser.class.getName());

    public GitToolChooser(String remoteName, Item projectContext, String credentialsId, String gitExe, Boolean useJGit) throws IOException, InterruptedException {
        boolean useCache = false;
        if (useJGit != null) {
            this.JGIT_SUPPORTED = useJGit;
        }
        this.implementation = "NONE";
        useCache = this.decideAndUseCache(remoteName);
        if (useCache) {
            this.implementation = this.determineSwitchOnSize(this.sizeOfRepo, gitExe);
        } else {
            this.decideAndUseAPI(remoteName, projectContext, credentialsId, gitExe);
        }
        this.determineGitTool(this.implementation, gitExe);
    }

    private boolean decideAndUseCache(String remoteName) throws IOException, InterruptedException {
        Git git;
        GitClient client;
        boolean useCache = false;
        String cacheEntry = AbstractGitSCMSource.getCacheEntry(remoteName);
        File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry, false);
        if (cacheDir != null && (client = (git = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir).using("git")).getClient()).hasGitRepo()) {
            this.sizeOfRepo = FileUtils.sizeOfDirectory((File)cacheDir);
            this.sizeOfRepo /= 1000L;
            useCache = true;
        }
        return useCache;
    }

    private void decideAndUseAPI(String remoteName, Item context, String credentialsId, String gitExe) {
        if (this.setSizeFromAPI(remoteName, context, credentialsId)) {
            this.implementation = this.determineSwitchOnSize(this.sizeOfRepo, gitExe);
        }
    }

    private boolean setSizeFromAPI(String repoUrl, Item context, String credentialsId) {
        List acceptedRepository = Objects.requireNonNull(RepositorySizeAPI.all()).stream().filter(r -> r.isApplicableTo(repoUrl, context, credentialsId)).collect(Collectors.toList());
        if (acceptedRepository.size() > 0) {
            try {
                for (RepositorySizeAPI repo : acceptedRepository) {
                    long size = repo.getSizeOfRepository(repoUrl, context, credentialsId);
                    if (size == 0L) continue;
                    this.sizeOfRepo = size;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Not using performance improvement from REST API: {0}", e.getMessage());
                return false;
            }
            return this.sizeOfRepo != 0L;
        }
        return false;
    }

    String determineSwitchOnSize(Long sizeOfRepo, String gitExe) {
        if (sizeOfRepo != 0L) {
            if (sizeOfRepo < 5000L) {
                if (!this.JGIT_SUPPORTED) {
                    return "NONE";
                }
                return this.determineToolName(gitExe, "jgit");
            }
            return this.determineToolName(gitExe, "git");
        }
        return "NONE";
    }

    private void determineGitTool(String gitImplementation, String gitExe) {
        if (gitImplementation.equals("NONE")) {
            this.gitTool = "NONE";
            return;
        }
        Jenkins jenkins = Jenkins.get();
        GitTool tool = GitUtils.resolveGitTool(gitImplementation, (Node)jenkins, null, TaskListener.NULL);
        if (tool != null) {
            this.gitTool = tool.getGitExe();
        }
    }

    public String getGitTool() {
        return this.gitTool;
    }

    private String determineToolName(String gitExe, String recommendation) {
        if (gitExe.contains(recommendation) && !gitExe.equals("jgit") && !gitExe.equals("jgitapache")) {
            return gitExe;
        }
        if (!recommendation.equals(gitExe) && gitExe.equals("jgitapache") && recommendation.equals("jgit")) {
            return gitExe;
        }
        return recommendation;
    }

    public static abstract class RepositorySizeAPI
    implements ExtensionPoint {
        public abstract boolean isApplicableTo(String var1, Item var2, String var3);

        public abstract Long getSizeOfRepository(String var1, Item var2, String var3) throws Exception;

        public static ExtensionList<RepositorySizeAPI> all() {
            return Jenkins.get().getExtensionList(RepositorySizeAPI.class);
        }
    }
}

