/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.Messages;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class AssemblaWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public AssemblaWeb(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commits/" + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        return this.getChangeSetLink(changeSet);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return AssemblaWeb.encodeURL(new URL(url, url.getPath() + "nodes/" + changeSet.getParentCommit() + path.getPath()));
        }
        return AssemblaWeb.encodeURL(new URL(url, url.getPath() + "nodes/" + changeSet.getId() + path.getPath()));
    }

    @Extension
    public static class AssemblaWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "AssemblaWeb";
        }

        public AssemblaWeb newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (AssemblaWeb)((Object)req.bindJSON(AssemblaWeb.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckRepoUrl(@AncestorInPath Item project, @QueryParameter(fixEmpty=true) String repoUrl) throws IOException, ServletException, URISyntaxException {
            final String cleanUrl = Util.fixEmptyAndTrim((String)repoUrl);
            if (GitRepositoryBrowser.initialChecksAndReturnOk(project, cleanUrl)) {
                return FormValidation.ok();
            }
            if (!this.checkURIFormatAndHostName(cleanUrl, "assembla")) {
                return FormValidation.error((String)Messages.invalidUrl());
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = cleanUrl;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "Assembla")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it does not look like Assembla");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }

        private boolean checkURIFormatAndHostName(String url, String hostNameFragment) throws URISyntaxException {
            URI uri = new URI(url);
            String[] schemes = new String[]{"http", "https"};
            UrlValidator urlValidator = new UrlValidator(schemes);
            hostNameFragment = hostNameFragment + ".";
            return urlValidator.isValid(uri.toString()) && uri.getHost().contains(hostNameFragment);
        }
    }
}

