/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.scm.SCM;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import jenkins.plugins.git.Messages;
import org.jenkinsci.plugins.workflow.steps.scm.SCMStep;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public final class GitStep
extends SCMStep {
    private final String url;
    private String branch = "master";
    private String credentialsId;

    @DataBoundConstructor
    public GitStep(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setBranch(String branch) {
        this.branch = branch;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public SCM createSCM() {
        return new GitSCM(GitSCM.createRepoList(this.url, this.credentialsId), Collections.singletonList(new BranchSpec("*/" + this.branch)), false, Collections.emptyList(), null, null, Collections.singletonList(new LocalBranch(this.branch)));
    }

    @Extension
    public static final class DescriptorImpl
    extends SCMStep.SCMStepDescriptor {
        @Inject
        private UserRemoteConfig.DescriptorImpl delegate;

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project, @QueryParameter String url, @QueryParameter String credentialsId) {
            return this.delegate.doFillCredentialsIdItems(project, url, credentialsId);
        }

        @RequirePOST
        public FormValidation doCheckUrl(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String value) throws IOException, InterruptedException {
            return this.delegate.doCheckUrl(item, credentialsId, value);
        }

        public String getFunctionName() {
            return "git";
        }

        public String getDisplayName() {
            return Messages.GitStep_git();
        }
    }
}

