/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.Messages;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitBlitRepositoryBrowser
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String projectName;

    @DataBoundConstructor
    public GitBlitRepositoryBrowser(String repoUrl, String projectName) {
        super(repoUrl);
        this.projectName = projectName;
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "blobdiff?r=%s&h=%s&hb=%s", this.encodeString(this.projectName), path.getChangeSet().getId(), path.getChangeSet().getParentCommit()));
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return null;
        }
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "blob?r=%s&h=%s&f=%s", this.encodeString(this.projectName), path.getChangeSet().getId(), this.encodeString(path.getPath())));
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "commit?r=%s&h=%s", this.encodeString(this.projectName), changeSet.getId()));
    }

    public String getProjectName() {
        return this.projectName;
    }

    private String encodeString(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
    }

    @Extension
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @Nonnull
        public String getDisplayName() {
            return "gitblit";
        }

        public GitBlitRepositoryBrowser newInstance(StaplerRequest req, @Nonnull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (GitBlitRepositoryBrowser)((Object)req.bindJSON(GitBlitRepositoryBrowser.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckRepoUrl(@AncestorInPath Item project, @QueryParameter(fixEmpty=true) String repoUrl) throws IOException, ServletException, URISyntaxException {
            final String cleanUrl = Util.fixEmptyAndTrim((String)repoUrl);
            if (GitRepositoryBrowser.initialChecksAndReturnOk(project, cleanUrl)) {
                return FormValidation.ok();
            }
            if (!GitRepositoryBrowser.checkURIFormat(cleanUrl)) {
                return FormValidation.error((String)Messages.invalidUrl());
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = cleanUrl;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "Gitblit")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Gitblit");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }
    }
}

