/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.Messages;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.CommitTimeComparator;
import hudson.plugins.git.util.GitUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.stapler.DataBoundConstructor;

public class InverseBuildChooser
extends BuildChooser {
    private static final BranchSpec HEAD = new BranchSpec("*/HEAD");
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public InverseBuildChooser() {
    }

    @Override
    public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
        EnvVars env = context.getEnvironment();
        GitUtils utils = new GitUtils(listener, git);
        List<Revision> branchRevs = new ArrayList<Revision>(utils.getAllBranchRevisions());
        List<BranchSpec> specifiedBranches = this.gitSCM.getBranches();
        Iterator<Object> i = branchRevs.iterator();
        while (i.hasNext()) {
            Revision revision = (Revision)i.next();
            Iterator j = revision.getBranches().iterator();
            block1: while (j.hasNext()) {
                Branch branch = (Branch)j.next();
                for (BranchSpec spec : specifiedBranches) {
                    if (!spec.matches(branch.getName(), env) && !HEAD.matches(branch.getName(), env)) continue;
                    j.remove();
                    continue block1;
                }
            }
            if (!revision.getBranches().isEmpty()) continue;
            i.remove();
        }
        if ((branchRevs = utils.filterTipBranches(branchRevs)).isEmpty()) {
            listener.getLogger().println(Messages.BuildChooser_Inverse_EverythingExcluded());
        }
        i = branchRevs.iterator();
        while (i.hasNext()) {
            Revision r = (Revision)i.next();
            if (!buildData.hasBeenBuilt(r.getSha1())) continue;
            i.remove();
        }
        if (!isPollCall && branchRevs.isEmpty() && buildData.getLastBuiltRevision() != null) {
            listener.getLogger().println(Messages.BuildChooser_BuildingLastRevision());
            return Collections.singletonList(buildData.getLastBuiltRevision());
        }
        List<Revision> in = branchRevs;
        return (Collection)utils.git.withRepository((RepositoryCallback & Serializable)(repo, channel) -> {
            in.sort(new CommitTimeComparator(repo));
            return in;
        });
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildChooserDescriptor {
        public String getDisplayName() {
            return Messages.BuildChooser_Inverse();
        }
    }
}

