/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class TFS2013GitRepositoryBrowser
extends GitRepositoryBrowser {
    @DataBoundConstructor
    public TFS2013GitRepositoryBrowser(String repoUrl) {
        super(repoUrl);
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        String spec = String.format("commit/%s#path=%s&_a=compare", path.getChangeSet().getId(), path.getPath());
        return new URL(this.getRepoUrl(path.getChangeSet()), spec);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        String spec = String.format("commit/%s#path=%s&_a=history", path.getChangeSet().getId(), path.getPath());
        return TFS2013GitRepositoryBrowser.encodeURL(new URL(this.getRepoUrl(path.getChangeSet()), spec));
    }

    public URL getChangeSetLink(GitChangeSet gitChangeSet) throws IOException {
        return new URL(this.getRepoUrl(gitChangeSet), "commit/" + gitChangeSet.getId());
    }

    URL getRepoUrl(GitChangeSet changeSet) throws IOException {
        String result = this.getRepoUrl();
        if (StringUtils.isBlank((String)result)) {
            return TFS2013GitRepositoryBrowser.normalizeToEndWithSlash((URL)this.getUrlFromFirstConfiguredRepository(changeSet));
        }
        if (!result.contains("/")) {
            return TFS2013GitRepositoryBrowser.normalizeToEndWithSlash((URL)this.getResultFromNamedRepository(changeSet));
        }
        return this.getUrl();
    }

    private URL getResultFromNamedRepository(GitChangeSet changeSet) throws MalformedURLException {
        GitSCM scm = this.getScmFromProject(changeSet);
        return new URL(((URIish)scm.getRepositoryByName(this.getRepoUrl()).getURIs().get(0)).toString());
    }

    private URL getUrlFromFirstConfiguredRepository(GitChangeSet changeSet) throws MalformedURLException {
        GitSCM scm = this.getScmFromProject(changeSet);
        return new URL(((URIish)scm.getRepositories().get(0).getURIs().get(0)).toString());
    }

    private GitSCM getScmFromProject(GitChangeSet changeSet) {
        AbstractProject build = (AbstractProject)changeSet.getParent().getRun().getParent();
        return (GitSCM)build.getScm();
    }

    @Extension
    public static class TFS2013GitRepositoryBrowserDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        private static final String REPOSITORY_BROWSER_LABEL = "Microsoft Team Foundation Server/Visual Studio Team Services";
        private static final Pattern URL_PATTERN = Pattern.compile(".+/_git/[^/]+/");

        @NonNull
        public String getDisplayName() {
            return REPOSITORY_BROWSER_LABEL;
        }

        public TFS2013GitRepositoryBrowser newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            try {
                req.getSubmittedForm();
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
            return (TFS2013GitRepositoryBrowser)((Object)req.bindJSON(TFS2013GitRepositoryBrowser.class, jsonObject));
        }

        @RequirePOST
        public FormValidation doCheckRepoUrl(@QueryParameter(fixEmpty=true) String value, @AncestorInPath AbstractProject project) throws IOException, ServletException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            if (value == null) {
                value = "origin";
            }
            if (!value.contains("/") && project != null) {
                GitSCM scm = (GitSCM)project.getScm();
                RemoteConfig remote = scm.getRepositoryByName(value);
                if (remote == null) {
                    return FormValidation.errorWithMarkup((String)("There is no remote with the name <code>" + Util.escape((String)value) + "</code>"));
                }
                value = ((URIish)remote.getURIs().get(0)).toString();
            }
            if (!value.endsWith("/")) {
                value = value + '/';
            }
            if (!URL_PATTERN.matcher(value).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <code>.../_git/foobar/</code>");
            }
            final String finalValue = value;
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    try {
                        if (this.findText(this.open(new URL(finalValue)), "icrosoft")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like a Microsoft server");
                    }
                    catch (IOException e) {
                        return this.handleIOException(finalValue, e);
                    }
                }
            }.check();
        }
    }
}

