/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.SerializableConverter;
import com.thoughtworks.xstream.core.util.CustomObjectInputStream;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectOutput;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.RemoteConfig;

public class RemoteConfigConverter
implements Converter {
    private final Mapper mapper;
    private final SerializableConverter converter;

    public RemoteConfigConverter(XStream xStream) {
        this.mapper = xStream.getMapper();
        this.converter = new SerializableConverter(this.mapper, xStream.getReflectionProvider());
    }

    public boolean canConvert(Class type) {
        return RemoteConfig.class == type;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        this.converter.marshal(source, writer, context);
    }

    protected boolean isLegacyNode(HierarchicalStreamReader reader, UnmarshallingContext context) {
        return reader.getNodeName().startsWith("org.spearce");
    }

    protected Object legacyUnmarshal(final HierarchicalStreamReader reader, final UnmarshallingContext context) {
        final RemoteConfigProxy proxy = new RemoteConfigProxy();
        CustomObjectInputStream.StreamCallback callback = new CustomObjectInputStream.StreamCallback(){

            public Object readFromStream() {
                reader.moveDown();
                Class type = HierarchicalStreams.readClassType((HierarchicalStreamReader)reader, (Mapper)RemoteConfigConverter.this.mapper);
                Object streamItem = context.convertAnother((Object)proxy, type);
                reader.moveUp();
                return streamItem;
            }

            public Map readFieldsFromStream() {
                throw new UnsupportedOperationException();
            }

            public void defaultReadObject() {
                throw new UnsupportedOperationException();
            }

            public void registerValidation(ObjectInputValidation validation, int priority) throws NotActiveException {
                throw new NotActiveException();
            }

            public void close() {
                throw new UnsupportedOperationException();
            }
        };
        try {
            CustomObjectInputStream objectInput = CustomObjectInputStream.getInstance((DataHolder)context, (CustomObjectInputStream.StreamCallback)callback);
            proxy.readExternal((ObjectInput)objectInput);
            objectInput.popCallback();
            return proxy.toRemote();
        }
        catch (IOException | ClassNotFoundException | URISyntaxException e) {
            throw new ConversionException("Unmarshal failed", (Throwable)e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        if (this.isLegacyNode(reader, context)) {
            return this.legacyUnmarshal(reader, context);
        }
        return this.converter.unmarshal(reader, context);
    }

    private static class RemoteConfigProxy
    extends Config
    implements Externalizable {
        private static final String KEY_URL = "url";
        private static final String KEY_FETCH = "fetch";
        private static final String KEY_PUSH = "push";
        private static final String KEY_UPLOADPACK = "uploadpack";
        private static final String KEY_RECEIVEPACK = "receivepack";
        private static final String KEY_TAGOPT = "tagopt";
        private String name;
        private String[] uris = new String[0];
        private String[] fetch = new String[0];
        private String[] push = new String[0];
        private String uploadpack = "git-upload-pack";
        private String receivepack = "git-receive-pack";
        private String tagopt;

        public String getString(String section, String subsection, String name) {
            if (KEY_UPLOADPACK.equals(name)) {
                return this.uploadpack;
            }
            if (KEY_RECEIVEPACK.equals(name)) {
                return this.receivepack;
            }
            if (KEY_TAGOPT.equals(name)) {
                return this.tagopt;
            }
            return super.getString(section, subsection, name);
        }

        public String[] getStringList(String section, String subsection, String name) {
            if (KEY_URL.equals(name)) {
                return this.uris;
            }
            if (KEY_FETCH.equals(name)) {
                return this.fetch;
            }
            if (KEY_PUSH.equals(name)) {
                return this.push;
            }
            return super.getStringList(section, subsection, name);
        }

        private void fromMap(Map<String, Collection<String>> map) {
            block16: for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
                String key = entry.getKey();
                Collection<String> values = entry.getValue();
                if (null == key) continue;
                switch (key) {
                    case "url": {
                        this.uris = values.toArray(new String[0]);
                        break;
                    }
                    case "fetch": {
                        this.fetch = values.toArray(new String[0]);
                        break;
                    }
                    case "push": {
                        this.push = values.toArray(new String[0]);
                        break;
                    }
                    case "uploadpack": {
                        String value;
                        Iterator<String> iterator = values.iterator();
                        while (iterator.hasNext()) {
                            this.uploadpack = value = iterator.next();
                        }
                        continue block16;
                    }
                    case "receivepack": {
                        String value;
                        Iterator<String> iterator = values.iterator();
                        while (iterator.hasNext()) {
                            this.receivepack = value = iterator.next();
                        }
                        continue block16;
                    }
                    case "tagopt": {
                        String value;
                        Iterator<String> iterator = values.iterator();
                        while (iterator.hasNext()) {
                            this.tagopt = value = iterator.next();
                        }
                        continue block16;
                    }
                }
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = in.readUTF();
            int items = in.readInt();
            HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
            for (int i = 0; i < items; ++i) {
                String key = in.readUTF();
                String value = in.readUTF();
                ArrayList<String> values = (ArrayList<String>)map.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    map.put(key, values);
                }
                values.add(value);
            }
            this.fromMap(map);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            throw new IOException("writeExternal not supported");
        }

        public RemoteConfig toRemote() throws URISyntaxException {
            return new RemoteConfig((Config)this, this.name);
        }
    }
}

