/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import hudson.scm.ChangeLogParser;
import hudson.scm.RepositoryBrowser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.xml.sax.SAXException;

public class GitChangeLogParser
extends ChangeLogParser {
    private boolean authorOrCommitter;
    private boolean showEntireCommitSummaryInChanges;
    private static int THRESHOLD = 1000;

    @Deprecated
    public GitChangeLogParser(boolean authorOrCommitter) {
        this(null, authorOrCommitter);
    }

    public GitChangeLogParser(GitClient git, boolean authorOrCommitter) {
        this.authorOrCommitter = authorOrCommitter;
        this.showEntireCommitSummaryInChanges = GitChangeSet.isShowEntireCommitSummaryInChanges() || !(git instanceof CliGitAPIImpl);
    }

    public List<GitChangeSet> parse(@Nonnull InputStream changelog) throws IOException {
        return this.parse(IOUtils.readLines((InputStream)changelog, (String)"UTF-8"));
    }

    public List<GitChangeSet> parse(@Nonnull List<String> changelog) {
        return this.parse(changelog.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitChangeSetList parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
        LineIterator lineIterator = null;
        try {
            lineIterator = FileUtils.lineIterator((File)changelogFile, (String)"UTF-8");
            GitChangeSetList gitChangeSetList = new GitChangeSetList(build, browser, this.parse((Iterator<String>)lineIterator));
            return gitChangeSetList;
        }
        finally {
            LineIterator.closeQuietly((LineIterator)lineIterator);
        }
    }

    private List<GitChangeSet> parse(Iterator<String> changelog) {
        LinkedHashSet<GitChangeSet> r = new LinkedHashSet<GitChangeSet>();
        ArrayList<String> lines = null;
        while (changelog.hasNext()) {
            String line = changelog.next();
            if (line.startsWith("commit ")) {
                if (lines != null) {
                    r.add(this.parseCommit(lines, this.authorOrCommitter));
                }
                lines = new ArrayList<String>();
            }
            if (lines == null || lines.size() >= THRESHOLD) continue;
            lines.add(line);
        }
        if (lines != null) {
            r.add(this.parseCommit(lines, this.authorOrCommitter));
        }
        return new ArrayList<GitChangeSet>(r);
    }

    private GitChangeSet parseCommit(List<String> lines, boolean authorOrCommitter) {
        return new GitChangeSet(lines, authorOrCommitter, this.showEntireCommitSummaryInChanges);
    }
}

