/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git.traits;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.ListBoxModel;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitToolSCMSourceTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String gitTool;

    @DataBoundConstructor
    public GitToolSCMSourceTrait(@CheckForNull String gitTool) {
        this.gitTool = Util.fixEmpty((String)gitTool);
    }

    @CheckForNull
    public String getGitTool() {
        return this.gitTool;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        ((GitSCMSourceContext)context).withGitTool(this.gitTool);
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        ((GitSCMBuilder)builder).withGitTool(this.gitTool);
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Select Git executable";
        }

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GitSCMSourceContext.class;
        }

        public boolean isApplicableToBuilder(@NonNull Class<? extends SCMBuilder> builderClass) {
            return super.isApplicableToBuilder(builderClass) && this.getSCMDescriptor().showGitToolOptions();
        }

        public boolean isApplicableToContext(@NonNull Class<? extends SCMSourceContext> contextClass) {
            return super.isApplicableToContext(contextClass) && this.getSCMDescriptor().showGitToolOptions();
        }

        public Class<? extends SCM> getScmClass() {
            return GitSCM.class;
        }

        private GitSCM.DescriptorImpl getSCMDescriptor() {
            return (GitSCM.DescriptorImpl)Jenkins.getActiveInstance().getDescriptor(GitSCM.class);
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillGitToolItems() {
            return this.getSCMDescriptor().doFillGitToolItems();
        }
    }
}

