/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMSourceRequest;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.trait.SCMSourceContext;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;

public class GitSCMSourceContext<C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest>
extends SCMSourceContext<C, R> {
    private boolean wantBranches;
    private boolean wantTags;
    private boolean pruneRefs;
    private Set<RefNameMapping> refNameMappings;
    @CheckForNull
    private String gitTool;
    private boolean ignoreOnPushNotifications;
    @NonNull
    private List<String> refSpecs = new ArrayList<String>();
    @NonNull
    private String remoteName = "origin";

    public GitSCMSourceContext(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer) {
        super(criteria, observer);
    }

    public final boolean wantBranches() {
        return this.wantBranches;
    }

    public final boolean wantTags() {
        return this.wantTags;
    }

    public final boolean pruneRefs() {
        return this.pruneRefs;
    }

    public final boolean wantOtherRefs() {
        return this.refNameMappings != null && !this.refNameMappings.isEmpty();
    }

    @NonNull
    public Collection<RefNameMapping> getRefNameMappings() {
        if (this.refNameMappings == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.refNameMappings);
    }

    @CheckForNull
    public final String gitTool() {
        return this.gitTool;
    }

    public final boolean ignoreOnPushNotifications() {
        return this.ignoreOnPushNotifications;
    }

    @NonNull
    public final List<String> refSpecs() {
        if (this.refSpecs.isEmpty()) {
            return Collections.singletonList("+refs/heads/*:refs/remotes/@{remote}/*");
        }
        return Collections.unmodifiableList(this.refSpecs);
    }

    @NonNull
    public final String remoteName() {
        return this.remoteName;
    }

    @NonNull
    public C wantBranches(boolean include) {
        this.wantBranches = this.wantBranches || include;
        return (C)((Object)this);
    }

    @NonNull
    public C wantTags(boolean include) {
        this.wantTags = this.wantTags || include;
        return (C)((Object)this);
    }

    @NonNull
    public C pruneRefs(boolean include) {
        this.pruneRefs = this.pruneRefs || include;
        return (C)((Object)this);
    }

    @NonNull
    public C wantOtherRef(RefNameMapping other) {
        if (this.refNameMappings == null) {
            this.refNameMappings = new TreeSet<RefNameMapping>();
        }
        this.refNameMappings.add(other);
        return (C)((Object)this);
    }

    @NonNull
    public final C withGitTool(String gitTool) {
        this.gitTool = gitTool;
        return (C)((Object)this);
    }

    @NonNull
    public final C withIgnoreOnPushNotifications(boolean ignoreOnPushNotifications) {
        this.ignoreOnPushNotifications = ignoreOnPushNotifications;
        return (C)((Object)this);
    }

    @NonNull
    public final C withRefSpec(@NonNull String refSpec) {
        this.refSpecs.add(refSpec);
        return (C)((Object)this);
    }

    @NonNull
    public final C withRefSpecs(List<String> refSpecs) {
        this.refSpecs.addAll(refSpecs);
        return (C)((Object)this);
    }

    @NonNull
    public final C withoutRefSpecs() {
        this.refSpecs.clear();
        return (C)((Object)this);
    }

    @NonNull
    public final C withRemoteName(String remoteName) {
        this.remoteName = StringUtils.defaultIfBlank((String)remoteName, (String)"origin");
        return (C)((Object)this);
    }

    @NonNull
    public final List<RefSpec> asRefSpecs() {
        ArrayList<RefSpec> result = new ArrayList<RefSpec>(Math.max(this.refSpecs.size(), 1));
        if (this.wantOtherRefs() && this.wantBranches()) {
            result.add(new RefSpec("+refs/heads/*:refs/remotes/" + this.remoteName() + "/*"));
        }
        for (String template : this.refSpecs()) {
            result.add(new RefSpec(template.replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, this.remoteName())));
        }
        return result;
    }

    @NonNull
    public R newRequest(@NonNull SCMSource source, TaskListener listener) {
        return (R)((Object)new GitSCMSourceRequest(source, this, listener));
    }

    public static final class RefNameMapping
    implements Comparable<RefNameMapping> {
        private final String ref;
        private final String name;
        private transient Pattern refPattern;

        public RefNameMapping(@NonNull String ref, @NonNull String name) {
            this.ref = ref;
            this.name = name;
        }

        @NonNull
        public String getRef() {
            return this.ref;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        Pattern refAsPattern() {
            if (this.refPattern == null) {
                this.refPattern = Pattern.compile("refs/" + this.ref.replace("*", "(.+)"));
            }
            return this.refPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RefNameMapping that = (RefNameMapping)o;
            return Objects.equals(this.ref, that.ref) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.ref, this.name);
        }

        @Override
        public int compareTo(RefNameMapping o) {
            return Integer.compare(this.hashCode(), o != null ? o.hashCode() : 0);
        }

        public boolean matches(String revision, String remoteName, String remoteRev) {
            Matcher matcher = this.refAsPattern().matcher(remoteName);
            if (matcher.matches()) {
                if (matcher.groupCount() > 0) {
                    String resolvedName = this.name.replace("@{1}", matcher.group(1));
                    return resolvedName.equals(revision);
                }
                return this.name.equals(revision);
            }
            return false;
        }

        public boolean matches(String remoteName) {
            Matcher matcher = this.refAsPattern().matcher(remoteName);
            return matcher.matches();
        }

        public String getName(String remoteName) {
            Matcher matcher = this.refAsPattern().matcher(remoteName);
            if (matcher.matches()) {
                if (matcher.groupCount() > 0) {
                    return this.name.replace("@{1}", matcher.group(1));
                }
                if (!this.name.contains("@{1}")) {
                    return this.name;
                }
            }
            return null;
        }
    }
}

