/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CloneOption
extends GitSCMExtension {
    private final boolean shallow;
    private final boolean noTags;
    private final String reference;
    private final Integer timeout;
    private int depth = 1;
    private boolean honorRefspec = false;

    public CloneOption(boolean shallow, String reference, Integer timeout) {
        this(shallow, false, reference, timeout);
    }

    @DataBoundConstructor
    public CloneOption(boolean shallow, boolean noTags, String reference, Integer timeout) {
        this.shallow = shallow;
        this.noTags = noTags;
        this.reference = reference;
        this.timeout = timeout;
        this.honorRefspec = false;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public boolean isNoTags() {
        return this.noTags;
    }

    @DataBoundSetter
    public void setHonorRefspec(boolean honorRefspec) {
        this.honorRefspec = honorRefspec;
    }

    public boolean isHonorRefspec() {
        return this.honorRefspec;
    }

    public String getReference() {
        return this.reference;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public void decorateCloneCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        if (this.shallow) {
            listener.getLogger().println("Using shallow clone");
            cmd.shallow();
            if (this.depth > 1) {
                listener.getLogger().println("shallow clone depth " + this.depth);
                cmd.depth(Integer.valueOf(this.depth));
            }
        }
        if (this.noTags) {
            listener.getLogger().println("Avoid fetching tags");
            cmd.tags(false);
        }
        if (this.honorRefspec) {
            listener.getLogger().println("Honoring refspec on initial clone");
            RemoteConfig rc = scm.getRepositories().get(0);
            List refspecs = rc.getFetchRefSpecs();
            cmd.refspecs(refspecs);
        }
        cmd.timeout(this.timeout);
        cmd.reference(build.getEnvironment(listener).expand(this.reference));
    }

    @Override
    public void decorateFetchCommand(GitSCM scm, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
        cmd.shallow(this.shallow);
        if (this.shallow && this.depth > 1) {
            cmd.depth(Integer.valueOf(this.depth));
        }
        cmd.tags(!this.noTags);
        cmd.timeout(this.timeout);
    }

    @Override
    public GitClientType getRequiredClient() {
        return GitClientType.GITCLI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CloneOption that = (CloneOption)((Object)o);
        if (this.shallow != that.shallow) {
            return false;
        }
        if (this.noTags != that.noTags) {
            return false;
        }
        if (this.depth != that.depth) {
            return false;
        }
        if (this.honorRefspec != that.honorRefspec) {
            return false;
        }
        if (this.reference != null ? !this.reference.equals(that.reference) : that.reference != null) {
            return false;
        }
        return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
    }

    public int hashCode() {
        return CloneOption.class.hashCode();
    }

    public String toString() {
        return "CloneOption{shallow=" + this.shallow + ", noTags=" + this.noTags + ", reference='" + this.reference + '\'' + ", timeout=" + this.timeout + ", depth=" + this.depth + ", honorRefspec=" + this.honorRefspec + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Advanced clone behaviours";
        }
    }
}

