/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.SubmoduleCombinator;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class SubmoduleOption
extends GitSCMExtension {
    private boolean disableSubmodules;
    private boolean recursiveSubmodules;
    private boolean trackingSubmodules;
    private String reference;
    private boolean parentCredentials;
    private Integer timeout;

    @DataBoundConstructor
    public SubmoduleOption(boolean disableSubmodules, boolean recursiveSubmodules, boolean trackingSubmodules, String reference, Integer timeout, boolean parentCredentials) {
        this.disableSubmodules = disableSubmodules;
        this.recursiveSubmodules = recursiveSubmodules;
        this.trackingSubmodules = trackingSubmodules;
        this.parentCredentials = parentCredentials;
        this.reference = reference;
        this.timeout = timeout;
    }

    public boolean isDisableSubmodules() {
        return this.disableSubmodules;
    }

    public boolean isRecursiveSubmodules() {
        return this.recursiveSubmodules;
    }

    public boolean isTrackingSubmodules() {
        return this.trackingSubmodules;
    }

    public boolean isParentCredentials() {
        return this.parentCredentials;
    }

    public String getReference() {
        return this.reference;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public void onClean(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
        if (!this.disableSubmodules && git.hasGitModules()) {
            git.submoduleClean(this.recursiveSubmodules);
        }
    }

    @Override
    public void onCheckoutCompleted(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        BuildData revToBuild = scm.getBuildData(build);
        if (!this.disableSubmodules && git.hasGitModules()) {
            git.setupSubmoduleUrls(revToBuild.lastBuild.getRevision(), listener);
            git.submoduleUpdate().recursive(this.recursiveSubmodules).remoteTracking(this.trackingSubmodules).parentCredentials(this.parentCredentials).ref(build.getEnvironment(listener).expand(this.reference)).timeout(this.timeout).execute();
        }
        if (scm.isDoGenerateSubmoduleConfigurations()) {
            SubmoduleCombinator combinator = new SubmoduleCombinator(git, listener, scm.getSubmoduleCfg());
            combinator.createSubmoduleCombinations();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SubmoduleOption that = (SubmoduleOption)((Object)o);
        if (this.disableSubmodules != that.disableSubmodules) {
            return false;
        }
        if (this.recursiveSubmodules != that.recursiveSubmodules) {
            return false;
        }
        if (this.trackingSubmodules != that.trackingSubmodules) {
            return false;
        }
        if (this.parentCredentials != that.parentCredentials) {
            return false;
        }
        if (this.reference != null ? !this.reference.equals(that.reference) : that.reference != null) {
            return false;
        }
        return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
    }

    public int hashCode() {
        return SubmoduleOption.class.hashCode();
    }

    public String toString() {
        return "SubmoduleOption{disableSubmodules=" + this.disableSubmodules + ", recursiveSubmodules=" + this.recursiveSubmodules + ", trackingSubmodules=" + this.trackingSubmodules + ", reference='" + this.reference + '\'' + ", parentCredentials=" + this.parentCredentials + ", timeout=" + this.timeout + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Advanced sub-modules behaviours";
        }
    }
}

