/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;

class MethodUtils {
    MethodUtils() {
    }

    static boolean isOverridden(@Nonnull Class base, @Nonnull Class derived, @Nonnull String methodName, Class ... types) {
        Method baseMethod = MethodUtils.getMethodImpl(base, methodName, types);
        Method derivedMethod = MethodUtils.getMethodImpl(derived, methodName, types);
        return baseMethod == null ? derivedMethod != null && !Modifier.isAbstract(derivedMethod.getModifiers()) : !baseMethod.equals(derivedMethod);
    }

    static Method getMethodImpl(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Validate.notNull(cls, (String)"Null class not allowed.");
        Validate.notEmpty((String)methodName, (String)"Null or blank methodName not allowed.");
        for (Method method : cls.getDeclaredMethods()) {
            if (!methodName.equals(method.getName()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
            return method;
        }
        if (!cls.isInterface()) {
            for (Class<?> klass = cls.getSuperclass(); klass != null; klass = klass.getSuperclass()) {
                for (Method method : klass.getDeclaredMethods()) {
                    if (!methodName.equals(method.getName()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
                    return method;
                }
            }
        }
        Method res = null;
        for (Class klass : ClassUtils.getAllInterfaces(cls)) {
            for (Method method : klass.getDeclaredMethods()) {
                if (!methodName.equals(method.getName()) || !Arrays.equals(parameterTypes, method.getParameterTypes())) continue;
                if (res == null) {
                    res = method;
                    continue;
                }
                Class<?> c = res.getDeclaringClass();
                if (c == klass) continue;
                if (c.isAssignableFrom(klass)) {
                    res = method;
                    continue;
                }
                if (klass.isAssignableFrom(c)) continue;
                return null;
            }
        }
        return res;
    }
}

