/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.google.common.base.Function;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class SparseCheckoutPath
extends AbstractDescribableImpl<SparseCheckoutPath>
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    public static final transient SparseCheckoutPathToPath SPARSE_CHECKOUT_PATH_TO_PATH = new SparseCheckoutPathToPath();
    private String path;

    @DataBoundConstructor
    public SparseCheckoutPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SparseCheckoutPath)) {
            return false;
        }
        SparseCheckoutPath that = (SparseCheckoutPath)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.path;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() is not null")
    public Descriptor<SparseCheckoutPath> getDescriptor() {
        return Jenkins.getInstance().getDescriptor(this.getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SparseCheckoutPath> {
        public String getDisplayName() {
            return "Path";
        }
    }

    private static class SparseCheckoutPathToPath
    implements Function<SparseCheckoutPath, String>,
    Serializable {
        private SparseCheckoutPathToPath() {
        }

        public String apply(SparseCheckoutPath sparseCheckoutPath) {
            return sparseCheckoutPath.getPath();
        }
    }
}

