/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMSourceRequest;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.trait.SCMSourceContext;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;

public class GitSCMSourceContext<C extends GitSCMSourceContext<C, R>, R extends GitSCMSourceRequest>
extends SCMSourceContext<C, R> {
    private boolean wantBranches;
    private boolean wantTags;
    @CheckForNull
    private String gitTool;
    private boolean ignoreOnPushNotifications;
    @NonNull
    private List<String> refSpecs = new ArrayList<String>();
    @NonNull
    private String remoteName = "origin";

    public GitSCMSourceContext(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer) {
        super(criteria, observer);
    }

    public final boolean wantBranches() {
        return this.wantBranches;
    }

    public final boolean wantTags() {
        return this.wantTags;
    }

    @CheckForNull
    public final String gitTool() {
        return this.gitTool;
    }

    public final boolean ignoreOnPushNotifications() {
        return this.ignoreOnPushNotifications;
    }

    @NonNull
    public final List<String> refSpecs() {
        if (this.refSpecs.isEmpty()) {
            return Collections.singletonList("+refs/heads/*:refs/remotes/@{remote}/*");
        }
        return Collections.unmodifiableList(this.refSpecs);
    }

    @NonNull
    public final String remoteName() {
        return this.remoteName;
    }

    @NonNull
    public C wantBranches(boolean include) {
        this.wantBranches = this.wantBranches || include;
        return (C)((Object)this);
    }

    @NonNull
    public C wantTags(boolean include) {
        this.wantTags = this.wantTags || include;
        return (C)((Object)this);
    }

    @NonNull
    public final C withGitTool(String gitTool) {
        this.gitTool = gitTool;
        return (C)((Object)this);
    }

    @NonNull
    public final C withIgnoreOnPushNotifications(boolean ignoreOnPushNotifications) {
        this.ignoreOnPushNotifications = ignoreOnPushNotifications;
        return (C)((Object)this);
    }

    @NonNull
    public final C withRefSpec(@NonNull String refSpec) {
        this.refSpecs.add(refSpec);
        return (C)((Object)this);
    }

    @NonNull
    public final C withRefSpecs(List<String> refSpecs) {
        this.refSpecs.addAll(refSpecs);
        return (C)((Object)this);
    }

    @NonNull
    public final C withoutRefSpecs() {
        this.refSpecs.clear();
        return (C)((Object)this);
    }

    @NonNull
    public final C withRemoteName(String remoteName) {
        this.remoteName = StringUtils.defaultIfBlank((String)remoteName, (String)"origin");
        return (C)((Object)this);
    }

    @NonNull
    public final List<RefSpec> asRefSpecs() {
        ArrayList<RefSpec> result = new ArrayList<RefSpec>(Math.max(this.refSpecs.size(), 1));
        for (String template : this.refSpecs()) {
            result.add(new RefSpec(template.replaceAll(AbstractGitSCMSource.REF_SPEC_REMOTE_NAME_PLACEHOLDER, this.remoteName())));
        }
        return result;
    }

    @NonNull
    public R newRequest(@NonNull SCMSource source, TaskListener listener) {
        return (R)((Object)new GitSCMSourceRequest(source, this, listener));
    }
}

