/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeSet;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.eclipse.jgit.lib.ObjectId;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class GitSCMFileSystemTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void ofSource_Smokes() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"));
        Assert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        SCMFile root = fs.getRoot();
        Assert.assertThat((Object)root, (Matcher)Matchers.notNullValue());
        Assert.assertTrue((boolean)root.isRoot());
        Iterable children = root.children();
        Iterator iterator = children.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        Assert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
    }

    @Test
    public void ofSourceRevision() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMRevision revision = source.fetch(new SCMHead("dev"), null);
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"), (SCMRevision)revision);
        Assert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        Iterator iterator = children.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        Assert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void lastModified_Smokes() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMRevision revision = source.fetch(new SCMHead("dev"), null);
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        long fileSystemAllowedOffset = this.isWindows() ? 3000L : 1000L;
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"), (SCMRevision)revision);
        long currentTime = this.isWindows() ? System.currentTimeMillis() / 1000L * 1000L : System.currentTimeMillis();
        long lastModified = fs.lastModified();
        Assert.assertThat((Object)lastModified, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(currentTime - fileSystemAllowedOffset)));
        Assert.assertThat((Object)lastModified, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(currentTime + fileSystemAllowedOffset)));
        SCMFile file = fs.getRoot().child("file");
        currentTime = this.isWindows() ? System.currentTimeMillis() / 1000L * 1000L : System.currentTimeMillis();
        lastModified = file.lastModified();
        Assert.assertThat((Object)lastModified, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(currentTime - fileSystemAllowedOffset)));
        Assert.assertThat((Object)lastModified, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(currentTime + fileSystemAllowedOffset)));
    }

    @Test
    public void directoryTraversal() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.mkdirs("dir/subdir");
        this.sampleRepo.git("mv", "file", "dir/subdir/file");
        this.sampleRepo.write("dir/subdir/file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"));
        Assert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        Iterator iterator = children.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile dir = (SCMFile)iterator.next();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)dir.getName(), (Matcher)Matchers.is((Object)"dir"));
        Assert.assertThat((Object)dir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        children = dir.children();
        iterator = children.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile subdir = (SCMFile)iterator.next();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)subdir.getName(), (Matcher)Matchers.is((Object)"subdir"));
        Assert.assertThat((Object)subdir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        children = subdir.children();
        iterator = children.iterator();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)true));
        SCMFile file = (SCMFile)iterator.next();
        Assert.assertThat((Object)iterator.hasNext(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)file.getName(), (Matcher)Matchers.is((Object)"file"));
        Assert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
    }

    @Test
    public void mixedContent() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.write("file2", "new");
        this.sampleRepo.git("add", "file2");
        this.sampleRepo.write("dir/file3", "modified");
        this.sampleRepo.git("add", "file", "dir/file3");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        SCMFileSystem fs = SCMFileSystem.of((SCMSource)source, (SCMHead)new SCMHead("dev"));
        Assert.assertThat((Object)fs, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)fs.getRoot(), (Matcher)Matchers.notNullValue());
        Iterable children = fs.getRoot().children();
        TreeSet<String> names = new TreeSet<String>();
        SCMFile file = null;
        SCMFile file2 = null;
        SCMFile dir = null;
        for (SCMFile f : children) {
            names.add(f.getName());
            if ("file".equals(f.getName())) {
                file = f;
                continue;
            }
            if ("file2".equals(f.getName())) {
                file2 = f;
                continue;
            }
            if (!"dir".equals(f.getName())) continue;
            dir = f;
        }
        Assert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.is((Object)"file"), Matchers.is((Object)"file2"), Matchers.is((Object)"dir")}));
        Assert.assertThat((Object)file.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.REGULAR_FILE));
        Assert.assertThat((Object)file2.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.REGULAR_FILE));
        Assert.assertThat((Object)dir.getType(), (Matcher)Matchers.is((Object)SCMFile.Type.DIRECTORY));
        Assert.assertThat((Object)file.contentAsString(), (Matcher)Matchers.is((Object)"modified"));
        Assert.assertThat((Object)file2.contentAsString(), (Matcher)Matchers.is((Object)"new"));
    }

    @Test
    public void given_filesystem_when_askingChangesSinceSameRevision_then_changesAreEmpty() throws Exception {
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("git").getClient();
        ObjectId git261 = client.revParse("git-2.6.1");
        AbstractGitSCMSource.SCMRevisionImpl rev261 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git261.getName());
        GitSCMFileSystem instance = new GitSCMFileSystem(client, "origin", git261.getName(), rev261);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert.assertFalse((boolean)instance.changesSince((SCMRevision)rev261, (OutputStream)out));
        Assert.assertThat((Object)out.toString(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void given_filesystem_when_askingChangesSinceOldRevision_then_changesArePopulated() throws Exception {
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("git").getClient();
        ObjectId git261 = client.revParse("git-2.6.1");
        AbstractGitSCMSource.SCMRevisionImpl rev261 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git261.getName());
        GitSCMFileSystem instance = new GitSCMFileSystem(client, "origin", git261.getName(), rev261);
        ObjectId git260 = client.revParse("git-2.6.0");
        AbstractGitSCMSource.SCMRevisionImpl rev260 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git260.getName());
        Assert.assertThat((Object)git260, (Matcher)Matchers.not((Matcher)Matchers.is((Object)git261)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)instance.changesSince((SCMRevision)rev260, (OutputStream)out));
        Assert.assertThat((Object)out.toString(), (Matcher)Matchers.containsString((String)"prepare release git-2.6.1"));
    }

    @Test
    public void given_filesystem_when_askingChangesSinceNewRevision_then_changesArePopulatedButEmpty() throws Exception {
        File gitDir = new File(".");
        GitClient client = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(gitDir).using("git").getClient();
        ObjectId git260 = client.revParse("git-2.6.0");
        AbstractGitSCMSource.SCMRevisionImpl rev261 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git260.getName());
        GitSCMFileSystem instance = new GitSCMFileSystem(client, "origin", git260.getName(), rev261);
        ObjectId git261 = client.revParse("git-2.6.1");
        AbstractGitSCMSource.SCMRevisionImpl rev260 = new AbstractGitSCMSource.SCMRevisionImpl(new SCMHead("origin"), git261.getName());
        GitSCMFileSystem gitPlugin300FS = new GitSCMFileSystem(client, "origin", git261.getName(), rev260);
        Assert.assertEquals((Object)git261.getName(), (Object)gitPlugin300FS.getRevision().getHash());
        Assert.assertThat((Object)git261, (Matcher)Matchers.not((Matcher)Matchers.is((Object)git260)));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)instance.changesSince((SCMRevision)rev260, (OutputStream)out));
        Assert.assertThat((Object)out.toString(), (Matcher)Matchers.is((Object)""));
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

