/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.FreeStyleBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.LocalBranch;
import hudson.scm.SCMRevisionState;
import hudson.util.StreamTaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitRemoteHeadRefAction;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.Mockito;

public class AbstractGitSCMSourceTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();
    @Rule
    public GitSampleRepoRule sampleRepo2 = new GitSampleRepoRule();

    @Test
    public void retrieveHeads() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void retrievePrimaryHead_NotDuplicated() throws Exception {
        this.retrievePrimaryHead(false);
    }

    @Test
    public void retrievePrimaryHead_Duplicated() throws Exception {
        this.retrievePrimaryHead(true);
    }

    public void retrievePrimaryHead(boolean duplicatePrimary) throws Exception {
        boolean CLI_GIT_LESS_THAN_280;
        this.sampleRepo.init();
        this.sampleRepo.write("file.txt", "");
        this.sampleRepo.git("add", "file.txt");
        this.sampleRepo.git("commit", "--all", "--message=add-empty-file");
        this.sampleRepo.git("checkout", "-b", "new-primary");
        this.sampleRepo.write("file.txt", "content");
        this.sampleRepo.git("add", "file.txt");
        this.sampleRepo.git("commit", "--all", "--message=add-file");
        if (duplicatePrimary) {
            this.sampleRepo.git("checkout", "-b", "new-primary-duplicate", "new-primary");
        }
        this.sampleRepo.git("checkout", "master");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.git("symbolic-ref", "HEAD", "refs/heads/new-primary");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        ActionableSCMSourceOwner owner = (ActionableSCMSourceOwner)((Object)Mockito.mock(ActionableSCMSourceOwner.class));
        Mockito.when((Object)owner.getSCMSource(source.getId())).thenReturn((Object)source);
        Mockito.when((Object)owner.getSCMSources()).thenReturn(Collections.singletonList(source));
        source.setOwner((SCMSourceOwner)owner);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        TreeMap<String, SCMHead> headByName = new TreeMap<String, SCMHead>();
        for (SCMHead h : source.fetch((TaskListener)listener)) {
            headByName.put(h.getName(), h);
        }
        if (duplicatePrimary) {
            Assert.assertThat(headByName.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"master", "dev", "new-primary", "new-primary-duplicate"}));
        } else {
            Assert.assertThat(headByName.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"master", "dev", "new-primary"}));
        }
        List actions = source.fetchActions(null, (TaskListener)listener);
        GitRemoteHeadRefAction refAction = null;
        for (Action a : actions) {
            if (!(a instanceof GitRemoteHeadRefAction)) continue;
            refAction = (GitRemoteHeadRefAction)a;
            break;
        }
        boolean bl = CLI_GIT_LESS_THAN_280 = !this.sampleRepo.gitVersionAtLeast(2, 8);
        if (duplicatePrimary && CLI_GIT_LESS_THAN_280) {
            Assert.assertThat((Object)refAction, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            Assert.assertThat((Object)refAction, (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)refAction.getName(), (Matcher)Matchers.is((Object)"new-primary"));
            Mockito.when((Object)owner.getAction(GitRemoteHeadRefAction.class)).thenReturn((Object)refAction);
            Mockito.when((Object)owner.getActions(GitRemoteHeadRefAction.class)).thenReturn(Collections.singletonList(refAction));
            actions = source.fetchActions((SCMHead)headByName.get("new-primary"), null, (TaskListener)listener);
        }
        PrimaryInstanceMetadataAction primary = null;
        for (Action a : actions) {
            if (!(a instanceof PrimaryInstanceMetadataAction)) continue;
            primary = (PrimaryInstanceMetadataAction)a;
            break;
        }
        if (duplicatePrimary && CLI_GIT_LESS_THAN_280) {
            Assert.assertThat(primary, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        } else {
            Assert.assertThat(primary, (Matcher)Matchers.notNullValue());
        }
    }

    @Test
    public void retrieveRevision() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("file", "v1");
        this.sampleRepo.git("commit", "--all", "--message=v1");
        this.sampleRepo.git("tag", "v1");
        String v1 = this.sampleRepo.head();
        this.sampleRepo.write("file", "v2");
        this.sampleRepo.git("commit", "--all", "--message=v2");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "v3");
        this.sampleRepo.git("commit", "--all", "--message=v3");
        FreeStyleBuild run = this.r.buildAndAssertSuccess(this.r.createFreeStyleProject());
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"v2", (Object)this.fileAt("master", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v3", (Object)this.fileAt("dev", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt("v1", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt(v1, (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertEquals((Object)"v1", (Object)this.fileAt(v1.substring(0, 7), (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("nonexistent", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("1234567", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertNull((Object)this.fileAt("\n", (Run<?, ?>)run, (SCMSource)source, (TaskListener)listener));
        Assert.assertThat((Object)source.fetchRevisions((TaskListener)listener), (Matcher)Matchers.hasItems((Object[])new String[]{"master", "dev", "v1"}));
    }

    private String fileAt(String revision, Run<?, ?> run, SCMSource source, TaskListener listener) throws Exception {
        SCMRevision rev = source.fetch(revision, listener);
        if (rev == null) {
            return null;
        }
        FilePath ws = new FilePath(run.getRootDir()).child("tmp-" + revision);
        source.build(rev.getHead(), rev).checkout(run, (Launcher)new Launcher.LocalLauncher(listener), ws, listener, null, SCMRevisionState.NONE);
        return ws.child("file").readToString();
    }

    @Test
    public void pruneRemovesDeletedBranches() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("dev-file", "dev-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "dev-file");
        this.sampleRepo.git("commit", "--message=dev-branch-commit-message");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2", "master");
        this.sampleRepo.write("dev2-file", "dev2-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "dev2-file");
        this.sampleRepo.git("commit", "--message=dev2-branch-commit-message");
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("branch", "-D", "dev");
        if (!this.sampleRepo.gitVersionAtLeast(1, 7, 10)) {
            Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        } else {
            Assert.assertEquals((Object)"[SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        }
    }

    @Test
    public void testSpecificRevisionBuildChooser() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        ArrayList<LocalBranch> extensions = new ArrayList<LocalBranch>();
        Assert.assertThat((Object)source.getExtensions(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        LocalBranch localBranchExtension = new LocalBranch("**");
        extensions.add(localBranchExtension);
        source.setExtensions(extensions);
        Assert.assertEquals((Object)source.getExtensions(), extensions);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        SCMHead head = new SCMHead("master");
        AbstractGitSCMSource.SCMRevisionImpl revision = new AbstractGitSCMSource.SCMRevisionImpl(head, "beaded4deed2bed4feed2deaf78933d0f97a5a34");
        GitSCM scm = (GitSCM)source.build(head);
        Assert.assertEquals(extensions, (Object)scm.getExtensions());
        GitSCM scmRevision = (GitSCM)source.build(head, (SCMRevision)revision);
        Assert.assertEquals(extensions.get(0), (Object)scmRevision.getExtensions().get(0));
        Assert.assertTrue((boolean)(scmRevision.getExtensions().get(1) instanceof BuildChooserSetting));
        Assert.assertEquals((long)2L, (long)scmRevision.getExtensions().size());
    }

    @Test
    public void testCustomRemoteName() throws Exception {
        this.sampleRepo.init();
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "upstream", null, "*", "", true);
        SCMHead head = new SCMHead("master");
        GitSCM scm = (GitSCM)source.build(head);
        List configs = scm.getUserRemoteConfigs();
        Assert.assertEquals((long)1L, (long)configs.size());
        UserRemoteConfig config = (UserRemoteConfig)configs.get(0);
        Assert.assertEquals((Object)"upstream", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/upstream/*", (Object)config.getRefspec());
    }

    @Test
    public void testCustomRefSpecs() throws Exception {
        this.sampleRepo.init();
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", null, "+refs/heads/*:refs/remotes/origin/* +refs/merge-requests/*/head:refs/remotes/origin/merge-requests/*", "*", "", true);
        SCMHead head = new SCMHead("master");
        GitSCM scm = (GitSCM)source.build(head);
        List configs = scm.getUserRemoteConfigs();
        Assert.assertEquals((long)2L, (long)configs.size());
        UserRemoteConfig config = (UserRemoteConfig)configs.get(0);
        Assert.assertEquals((Object)"origin", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/heads/*:refs/remotes/origin/*", (Object)config.getRefspec());
        config = (UserRemoteConfig)configs.get(1);
        Assert.assertEquals((Object)"origin", (Object)config.getName());
        Assert.assertEquals((Object)"+refs/merge-requests/*/head:refs/remotes/origin/merge-requests/*", (Object)config.getRefspec());
    }

    public static abstract class ActionableSCMSourceOwner
    extends Actionable
    implements SCMSourceOwner {
    }
}

