/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.plugins.git.AbstractGitRepository;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.DefaultBuildChooser;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class DefaultBuildChooserTest
extends AbstractGitRepository {
    @Test
    public void testChooseGitRevisionToBuildByShaHash() throws Exception {
        this.testGitClient.commit("Commit 1");
        String shaHashCommit1 = ((Branch)this.testGitClient.getBranches().iterator().next()).getSHA1String();
        this.testGitClient.commit("Commit 2");
        String shaHashCommit2 = ((Branch)this.testGitClient.getBranches().iterator().next()).getSHA1String();
        Assert.assertNotSame((Object)shaHashCommit1, (Object)shaHashCommit2);
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Collection candidateRevisions = buildChooser.getCandidateRevisions(false, shaHashCommit1, this.testGitClient, null, null, null);
        Assert.assertEquals((long)1L, (long)candidateRevisions.size());
        Assert.assertEquals((Object)shaHashCommit1, (Object)((Revision)candidateRevisions.iterator().next()).getSha1String());
        candidateRevisions = buildChooser.getCandidateRevisions(false, "aaa" + shaHashCommit1.substring(3), this.testGitClient, null, null, null);
        Assert.assertTrue((boolean)candidateRevisions.isEmpty());
    }

    @Test
    public void testIsAdvancedSpec() throws Exception {
        DefaultBuildChooser buildChooser = (DefaultBuildChooser)new GitSCM("foo").getBuildChooser();
        Assert.assertFalse((boolean)buildChooser.isAdvancedSpec("origin/master"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec("origin/master-*"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec("origin**"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec(":origin/master"));
        Assert.assertTrue((boolean)buildChooser.isAdvancedSpec(":origin/master-\\d{*}"));
    }
}

