/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import hudson.plugins.git.util.BuildData;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BuildDataLoggingTest {
    private BuildData data;
    private final Level ORIGINAL_LEVEL = BuildData.LOGGER.getLevel();
    private final boolean ORIGINAL_USE_PARENT_HANDLERS = BuildData.LOGGER.getUseParentHandlers();
    private LogHandler handler = null;

    @Before
    public void createTestData() throws Exception {
        this.data = new BuildData();
    }

    @Before
    public void reconfigureLogging() throws Exception {
        this.handler = new LogHandler();
        this.handler.setLevel(Level.ALL);
        BuildData.LOGGER.setUseParentHandlers(false);
        BuildData.LOGGER.addHandler(this.handler);
        BuildData.LOGGER.setLevel(Level.ALL);
    }

    @After
    public void restoreLogging() throws Exception {
        BuildData.LOGGER.removeHandler(this.handler);
        BuildData.LOGGER.setUseParentHandlers(this.ORIGINAL_USE_PARENT_HANDLERS);
        BuildData.LOGGER.setLevel(this.ORIGINAL_LEVEL);
    }

    @Test
    public void testSimilarToInvalidHttpsRemoteURL() {
        String INVALID_URL = "https://github.com/jenkinsci/git-plugin?s=^IXIC";
        BuildData invalid = new BuildData();
        invalid.addRemoteUrl("https://github.com/jenkinsci/git-plugin?s=^IXIC");
        Assert.assertTrue((String)"Invalid URL not similar to itself https://github.com/jenkinsci/git-plugin?s=^IXIC", (boolean)invalid.similarTo(invalid));
        String expectedMessage = "URI syntax exception on https://github.com/jenkinsci/git-plugin?s=^IXIC";
        Assert.assertThat((Object)this.handler.checkMessage(), (Matcher)Matchers.is((Object)expectedMessage));
        Assert.assertThat((Object)this.handler.checkLevel(), (Matcher)Matchers.is((Object)Level.FINEST));
    }

    class LogHandler
    extends Handler {
        private Level lastLevel = Level.INFO;
        private String lastMessage = "";

        LogHandler() {
        }

        public Level checkLevel() {
            return this.lastLevel;
        }

        public String checkMessage() {
            return this.lastMessage;
        }

        @Override
        public void publish(LogRecord record) {
            this.lastLevel = record.getLevel();
            this.lastMessage = record.getMessage();
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

