/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.model.FreeStyleProject;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.TestGitRepo;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionTest;
import hudson.plugins.git.extensions.impl.CloneOption;
import java.io.IOException;
import java.util.Set;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

public class CloneOptionShallowDefaultTagsTest
extends GitSCMExtensionTest {
    FreeStyleProject project;
    TestGitRepo repo;

    @Override
    public void before() throws Exception {
        this.repo = new TestGitRepo("repo", this.tmp.newFolder(), this.listener);
        this.project = this.setupBasicProject(this.repo);
    }

    @Override
    protected GitSCMExtension getExtension() {
        boolean shallowClone = true;
        String noReference = null;
        Integer noTimeout = null;
        return new CloneOption(true, noReference, noTimeout);
    }

    @Test
    public void evenShallowCloningFetchesTagsByDefault() throws Exception {
        String tagName = "v0.0.1";
        this.repo.commit("repo-init", this.repo.johnDoe, "repo0 initial commit");
        this.repo.tag("v0.0.1", "a tag that should be fetched by default");
        Assert.assertTrue((String)"scm polling should detect a change after initial commit", (boolean)this.project.poll(this.listener).hasChanges());
        this.build(this.project, Result.SUCCESS);
        Assert.assertEquals((String)"tag v0.0.1 should have been cloned from remote", (long)1L, (long)this.tagsInProjectWorkspaceWithName("v0.0.1").size());
    }

    private Set<String> tagsInProjectWorkspaceWithName(String tagPattern) throws IOException, InterruptedException {
        GitClient git = Git.with((TaskListener)this.listener, null).in(this.project.getWorkspace()).getClient();
        return git.getTagNames(tagPattern);
    }
}

