/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.BitbucketWeb;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public class BitbucketWebTest {
    private static final String BITBUCKET_URL = "http://bitbucket.org/USER/REPO";
    private final BitbucketWeb bitbucketWeb = new BitbucketWeb("http://bitbucket.org/USER/REPO");

    @Test
    public void testGetUrl() throws IOException {
        Assert.assertEquals((Object)String.valueOf(this.bitbucketWeb.getUrl()), (Object)"http://bitbucket.org/USER/REPO/");
    }

    @Test
    public void testGetUrlForRepoWithTrailingSlash() throws IOException {
        Assert.assertEquals((Object)String.valueOf(new BitbucketWeb("http://bitbucket.org/USER/REPO/").getUrl()), (Object)"http://bitbucket.org/USER/REPO/");
    }

    @Test
    public void testGetChangeSetLinkGitChangeSet() throws IOException, SAXException {
        URL changeSetLink = this.bitbucketWeb.getChangeSetLink(this.createChangeSet("rawchangelog"));
        Assert.assertEquals((Object)"http://bitbucket.org/USER/REPO/commits/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)changeSetLink.toString());
    }

    @Test
    public void testGetDiffLinkPath() throws IOException, SAXException {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        String path1Str = "src/main/java/hudson/plugins/git/browser/GithubWeb.java";
        GitChangeSet.Path path1 = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        Assert.assertEquals((Object)"http://bitbucket.org/USER/REPO/commits/396fc230a3db05c427737aa5c2eb7856ba72b05d#chg-src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.bitbucketWeb.getDiffLink(path1).toString());
        String path2Str = "src/test/java/hudson/plugins/git/browser/GithubWebTest.java";
        GitChangeSet.Path path2 = pathMap.get("src/test/java/hudson/plugins/git/browser/GithubWebTest.java");
        Assert.assertEquals((Object)"http://bitbucket.org/USER/REPO/commits/396fc230a3db05c427737aa5c2eb7856ba72b05d#chg-src/test/java/hudson/plugins/git/browser/GithubWebTest.java", (Object)this.bitbucketWeb.getDiffLink(path2).toString());
        String path3Str = "src/test/resources/hudson/plugins/git/browser/rawchangelog-with-deleted-file";
        GitChangeSet.Path path3 = pathMap.get("src/test/resources/hudson/plugins/git/browser/rawchangelog-with-deleted-file");
        Assert.assertNull((String)"Do not return a diff link for added files.", (Object)this.bitbucketWeb.getDiffLink(path3));
    }

    @Test
    public void testGetFileLinkPath() throws IOException, SAXException {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        URL fileLink = this.bitbucketWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://bitbucket.org/USER/REPO/history/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathForDeletedFile() throws IOException, SAXException {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-deleted-file");
        GitChangeSet.Path path = pathMap.get("bar");
        URL fileLink = this.bitbucketWeb.getFileLink(path);
        Assert.assertEquals((Object)"http://bitbucket.org/USER/REPO/history/bar", (Object)String.valueOf(fileLink));
    }

    private GitChangeSet createChangeSet(String rawchangelogpath) throws IOException, SAXException {
        GitChangeLogParser logParser = new GitChangeLogParser(false);
        List changeSetList = logParser.parse(BitbucketWebTest.class.getResourceAsStream(rawchangelogpath));
        return (GitChangeSet)changeSetList.get(0);
    }

    private HashMap<String, GitChangeSet.Path> createPathMap(String changelog) throws IOException, SAXException {
        HashMap<String, GitChangeSet.Path> pathMap = new HashMap<String, GitChangeSet.Path>();
        Collection changeSet = this.createChangeSet(changelog).getPaths();
        for (GitChangeSet.Path path : changeSet) {
            pathMap.put(path.getPath(), path);
        }
        return pathMap;
    }
}

