/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Environment;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitObject;
import hudson.plugins.git.Revision;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

public class GitUtils
implements Serializable {
    @Nonnull
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="known non-serializable field")
    GitClient git;
    @Nonnull
    TaskListener listener;
    private static final Logger LOGGER = Logger.getLogger(GitUtils.class.getName());
    private static final long serialVersionUID = 1L;

    public GitUtils(@Nonnull TaskListener listener, @Nonnull GitClient git) {
        this.git = git;
        this.listener = listener;
    }

    public static Node workspaceToNode(FilePath workspace) {
        Jenkins j = Jenkins.getActiveInstance();
        if (workspace != null && workspace.isRemote()) {
            for (Computer c : j.getComputers()) {
                Node n;
                if (c.getChannel() != workspace.getChannel() || (n = c.getNode()) == null) continue;
                return n;
            }
        }
        return j;
    }

    public Collection<Revision> getAllBranchRevisions() throws GitException, IOException, InterruptedException {
        HashMap<ObjectId, Revision> revisions = new HashMap<ObjectId, Revision>();
        for (Branch b : this.git.getRemoteBranches()) {
            Revision r = (Revision)revisions.get(b.getSHA1());
            if (r == null) {
                r = new Revision(b.getSHA1());
                revisions.put(b.getSHA1(), r);
            }
            r.getBranches().add(b);
        }
        for (GitObject tagEntry : this.git.getTags()) {
            String tagRef = "refs/tags/" + tagEntry.getName();
            ObjectId objectId = tagEntry.getSHA1();
            Revision r = (Revision)revisions.get(objectId);
            if (r == null) {
                r = new Revision(objectId);
                revisions.put(objectId, r);
            }
            r.getBranches().add(new Branch(tagRef, objectId));
        }
        return revisions.values();
    }

    public Revision getRevisionContainingBranch(String branchName) throws GitException, IOException, InterruptedException {
        for (Revision revision : this.getAllBranchRevisions()) {
            for (Branch b : revision.getBranches()) {
                if (!b.getName().equals(branchName)) continue;
                return revision;
            }
        }
        return null;
    }

    public Revision getRevisionForSHA1(ObjectId sha1) throws GitException, IOException, InterruptedException {
        for (Revision revision : this.getAllBranchRevisions()) {
            if (!revision.getSha1().equals((AnyObjectId)sha1)) continue;
            return revision;
        }
        return new Revision(sha1);
    }

    public Revision sortBranchesForRevision(Revision revision, List<BranchSpec> branchOrder) {
        EnvVars env = new EnvVars();
        return this.sortBranchesForRevision(revision, branchOrder, env);
    }

    public Revision sortBranchesForRevision(Revision revision, List<BranchSpec> branchOrder, EnvVars env) {
        ArrayList<Object> orderedBranches = new ArrayList<Object>(revision.getBranches().size());
        ArrayList revisionBranches = new ArrayList(revision.getBranches());
        for (BranchSpec branchSpec : branchOrder) {
            Iterator i = revisionBranches.iterator();
            while (i.hasNext()) {
                Branch b = (Branch)i.next();
                if (!branchSpec.matches(b.getName(), env)) continue;
                i.remove();
                orderedBranches.add(b);
            }
        }
        orderedBranches.addAll(revisionBranches);
        return new Revision(revision.getSha1(), orderedBranches);
    }

    @WithBridgeMethods(value={Collection.class})
    public List<Revision> filterTipBranches(final Collection<Revision> revisions) throws InterruptedException {
        final ArrayList<Revision> l = new ArrayList<Revision>(revisions);
        if (l.size() <= 1) {
            return l;
        }
        try {
            return (List)this.git.withRepository((RepositoryCallback)new RepositoryCallback<List<Revision>>(){

                public List<Revision> invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
                    HashSet<RevCommit> visited = new HashSet<RevCommit>();
                    HashMap<RevCommit, Revision> tipCandidates = new HashMap<RevCommit, Revision>();
                    long calls = 0L;
                    long start = System.currentTimeMillis();
                    boolean log = LOGGER.isLoggable(Level.FINE);
                    if (log) {
                        LOGGER.fine(MessageFormat.format("Computing merge base of {0}  branches", l.size()));
                    }
                    try (RevWalk walk = new RevWalk(repo);){
                        walk.setRetainBody(false);
                        block9: for (Revision r : revisions) {
                            walk.reset();
                            RevCommit head = walk.parseCommit((AnyObjectId)r.getSha1());
                            if (visited.contains(head)) continue;
                            tipCandidates.put(head, r);
                            walk.markStart(head);
                            for (RevCommit commit : walk) {
                                ++calls;
                                if (visited.contains(commit)) {
                                    tipCandidates.remove(commit);
                                    continue block9;
                                }
                                visited.add(commit);
                            }
                        }
                    }
                    if (log) {
                        LOGGER.fine(MessageFormat.format("Computed merge bases in {0} commit steps and {1} ms", calls, System.currentTimeMillis() - start));
                    }
                    return new ArrayList<Revision>(tipCandidates.values());
                }
            });
        }
        catch (IOException e) {
            throw new GitException("Error computing merge base", (Throwable)e);
        }
    }

    public static EnvVars getPollEnvironment(AbstractProject p, FilePath ws, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        return GitUtils.getPollEnvironment(p, ws, launcher, listener, true);
    }

    public static EnvVars getPollEnvironment(AbstractProject p, FilePath ws, Launcher launcher, TaskListener listener, boolean reuseLastBuildEnv) throws IOException, InterruptedException {
        Environment environment;
        EnvVars env = null;
        StreamBuildListener buildListener = new StreamBuildListener((OutputStream)listener.getLogger());
        AbstractBuild b = p.getLastBuild();
        if (b == null) {
            throw new IllegalArgumentException("Last build must not be null. If there really is no last build, a new build should be triggered without polling the SCM.");
        }
        if (reuseLastBuildEnv) {
            Computer lastComputer;
            Node lastBuiltOn = b.getBuiltOn();
            if (lastBuiltOn != null && (lastComputer = lastBuiltOn.toComputer()) != null) {
                env = lastComputer.getEnvironment().overrideAll((Map)b.getCharacteristicEnvVars());
                for (NodeProperty nodeProperty : lastBuiltOn.getNodeProperties()) {
                    environment = nodeProperty.setUp(b, launcher, (BuildListener)buildListener);
                    if (environment == null) continue;
                    environment.buildEnvVars((Map)env);
                }
            }
            if (env == null) {
                env = p.getEnvironment(GitUtils.workspaceToNode(ws), listener);
            }
            p.getScm().buildEnvVars(b, (Map)env);
        } else {
            env = p.getEnvironment(GitUtils.workspaceToNode(ws), listener);
        }
        Jenkins jenkinsInstance = Jenkins.getInstance();
        if (jenkinsInstance == null) {
            throw new IllegalArgumentException("Jenkins instance is null");
        }
        String rootUrl = jenkinsInstance.getRootUrl();
        if (rootUrl != null) {
            env.put("HUDSON_URL", rootUrl);
            env.put("JENKINS_URL", rootUrl);
            env.put("BUILD_URL", rootUrl + b.getUrl());
            env.put("JOB_URL", rootUrl + p.getUrl());
        }
        if (!env.containsKey((Object)"HUDSON_HOME")) {
            env.put("HUDSON_HOME", jenkinsInstance.getRootDir().getPath());
        }
        if (!env.containsKey((Object)"JENKINS_HOME")) {
            env.put("JENKINS_HOME", jenkinsInstance.getRootDir().getPath());
        }
        if (ws != null) {
            env.put("WORKSPACE", ws.getRemote());
        }
        for (NodeProperty nodeProperty : jenkinsInstance.getGlobalNodeProperties()) {
            environment = nodeProperty.setUp(b, launcher, (BuildListener)buildListener);
            if (environment == null) continue;
            environment.buildEnvVars((Map)env);
        }
        GitUtils.addEnvironmentContributingActionsValues(env, b);
        EnvVars.resolve((Map)env);
        return env;
    }

    private static void addEnvironmentContributingActionsValues(EnvVars env, AbstractBuild b) {
        ParametersDefinitionProperty paramDefProp;
        List buildActions = b.getAllActions();
        if (buildActions != null) {
            for (Action action : buildActions) {
                if (!(action instanceof ParametersAction)) continue;
                ParametersAction envAction = (ParametersAction)action;
                envAction.buildEnvVars(b, env);
            }
        }
        if ((paramDefProp = (ParametersDefinitionProperty)b.getProject().getProperty(ParametersDefinitionProperty.class)) != null) {
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defaultValue.buildEnvironment((Run)b, env);
            }
        }
    }

    public static String[] fixupNames(String[] names, String[] urls) {
        String[] returnNames = new String[urls.length];
        HashSet<String> usedNames = new HashSet<String>();
        for (int i = 0; i < urls.length; ++i) {
            String name = names[i];
            if (name == null || name.trim().length() == 0) {
                name = "origin";
            }
            String baseName = name;
            int j = 1;
            while (usedNames.contains(name)) {
                name = baseName + j++;
            }
            usedNames.add(name);
            returnNames[i] = name;
        }
        return returnNames;
    }
}

