/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import com.google.common.base.Objects;
import hudson.model.Result;
import hudson.plugins.git.Revision;
import java.io.IOException;
import java.io.Serializable;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class Build
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public Revision marked;
    public Revision revision;
    public int hudsonBuildNumber;
    public Result hudsonBuildResult;

    public Build(Revision marked, Revision revision, int buildNumber, Result result) {
        this.marked = marked;
        this.revision = revision;
        this.hudsonBuildNumber = buildNumber;
        this.hudsonBuildResult = result;
    }

    public Build(Revision revision, int buildNumber, Result result) {
        this(revision, revision, buildNumber, result);
    }

    public ObjectId getSHA1() {
        return this.revision.getSha1();
    }

    @Exported
    public Revision getRevision() {
        return this.revision;
    }

    @Exported
    public Revision getMarked() {
        return this.marked;
    }

    @Exported
    public int getBuildNumber() {
        return this.hudsonBuildNumber;
    }

    @Exported
    public Result getBuildResult() {
        return this.hudsonBuildResult;
    }

    public String toString() {
        return "Build #" + this.hudsonBuildNumber + " of " + this.revision.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Build)) {
            return false;
        }
        Build otherBuild = (Build)o;
        return otherBuild.hudsonBuildNumber == this.hudsonBuildNumber && Objects.equal((Object)otherBuild.revision, (Object)this.revision) && Objects.equal((Object)otherBuild.marked, (Object)this.marked);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.hudsonBuildNumber;
        if (this.revision != null) {
            result = 37 * result + this.revision.hashCode();
        }
        if (this.marked != null) {
            result = 37 * result + this.marked.hashCode();
        }
        return result;
    }

    public Build clone() {
        Build clone;
        try {
            clone = (Build)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning Build", e);
        }
        if (this.revision != null) {
            clone.revision = this.revision.clone();
        }
        if (this.marked != null) {
            clone.marked = this.marked.clone();
        }
        return clone;
    }

    public boolean isFor(String sha1) {
        return this.revision != null && this.revision.getSha1String().startsWith(sha1);
    }

    public Object readResolve() throws IOException {
        if (this.marked == null) {
            this.marked = this.revision;
        }
        return this;
    }
}

