/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Util;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.queue.FoldableAction;
import hudson.plugins.git.Branch;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;

public class RevisionParameterAction
extends InvisibleAction
implements Serializable,
Queue.QueueAction,
FoldableAction {
    public final String commit;
    public final boolean combineCommits;
    public final Revision revision;
    private final URIish repoURL;
    private static final long serialVersionUID = 2L;
    private static final Logger LOGGER = Logger.getLogger(RevisionParameterAction.class.getName());

    public RevisionParameterAction(String commit) {
        this(commit, false, null);
    }

    public RevisionParameterAction(String commit, URIish repoURL) {
        this(commit, false, repoURL);
    }

    public RevisionParameterAction(String commit, boolean combineCommits) {
        this(commit, combineCommits, null);
    }

    public RevisionParameterAction(String commit, boolean combineCommits, URIish repoURL) {
        this.commit = commit;
        this.combineCommits = combineCommits;
        this.revision = null;
        this.repoURL = repoURL;
    }

    public RevisionParameterAction(Revision revision) {
        this(revision, false);
    }

    public RevisionParameterAction(Revision revision, boolean combineCommits) {
        this.revision = revision;
        this.commit = revision.getSha1String();
        this.combineCommits = combineCommits;
        this.repoURL = null;
    }

    @Deprecated
    public Revision toRevision(IGitAPI git) throws InterruptedException {
        return this.toRevision((GitClient)git);
    }

    public Revision toRevision(GitClient git) throws InterruptedException {
        if (this.revision != null) {
            return this.revision;
        }
        ObjectId sha1 = git.revParse(this.commit);
        Revision revision = new Revision(sha1);
        List<Branch> branches = this.normalizeBranches(git.getBranchesContaining(ObjectId.toString((ObjectId)sha1), true));
        revision.getBranches().addAll(branches);
        return revision;
    }

    public boolean canOriginateFrom(Iterable<RemoteConfig> remotes) {
        if (this.repoURL == null) {
            return true;
        }
        for (RemoteConfig remote : remotes) {
            for (URIish remoteURL : remote.getURIs()) {
                if (!remoteURL.equals((Object)this.repoURL)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Branch> normalizeBranches(List<Branch> branches) {
        ArrayList<Branch> normalBranches = new ArrayList<Branch>(branches.size());
        String remotesPrefix = "remotes/";
        for (Branch initialBranch : branches) {
            Branch normalBranch;
            String initialBranchName = initialBranch.getName();
            if (initialBranchName.startsWith("remotes/")) {
                String normalName = initialBranchName.substring("remotes/".length());
                normalBranch = new Branch(normalName, initialBranch.getSHA1());
            } else {
                normalBranch = initialBranch;
            }
            normalBranches.add(normalBranch);
        }
        return normalBranches;
    }

    public String toString() {
        return super.toString() + "[commit=" + this.commit + "]";
    }

    public boolean shouldSchedule(List<Action> actions) {
        List otherActions = Util.filter(actions, RevisionParameterAction.class);
        if (this.combineCommits) {
            if (otherActions.size() != 0) {
                return false;
            }
        } else {
            for (RevisionParameterAction action : otherActions) {
                if (!this.commit.equals(action.commit)) continue;
                return false;
            }
        }
        return true;
    }

    public void foldIntoExisting(Queue.Item item, Queue.Task owner, List<Action> otherActions) {
        if (this.combineCommits) {
            RevisionParameterAction existing = (RevisionParameterAction)item.getAction(RevisionParameterAction.class);
            if (existing != null) {
                item.getActions().remove(existing);
                item.getActions().add(this);
                return;
            }
            item.getActions().add(this);
        }
    }
}

