/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserExclusion
extends GitSCMExtension {
    private String excludedUsers;

    @DataBoundConstructor
    public UserExclusion(String excludedUsers) {
        this.excludedUsers = excludedUsers;
    }

    @Override
    public boolean requiresWorkspaceForPolling() {
        return true;
    }

    public String getExcludedUsers() {
        return this.excludedUsers;
    }

    public Set<String> getExcludedUsersNormalized() {
        String s = Util.fixEmptyAndTrim((String)this.excludedUsers);
        if (s == null) {
            return Collections.emptySet();
        }
        HashSet<String> users = new HashSet<String>();
        for (String user : s.split("[\\r\\n]+")) {
            users.add(user.trim());
        }
        return users;
    }

    @Override
    public Boolean isRevExcluded(GitSCM scm, GitClient git, GitChangeSet commit, TaskListener listener, BuildData buildData) {
        String author = commit.getAuthorName();
        if (this.getExcludedUsersNormalized().contains(author)) {
            listener.getLogger().println("Ignored commit " + commit.getCommitId() + ": Found excluded author: " + author);
            return true;
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Polling ignores commits from certain users";
        }
    }
}

