/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.GitSCMFileSystem;
import jenkins.scm.api.SCMFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitSCMFile
extends SCMFile {
    private final GitSCMFileSystem fs;

    public GitSCMFile(GitSCMFileSystem fs) {
        this.fs = fs;
    }

    public GitSCMFile(GitSCMFileSystem fs, @NonNull GitSCMFile parent, String name) {
        super((SCMFile)parent, name);
        this.fs = fs;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new GitSCMFile(this.fs, this, name);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        return this.fs.invoke(new GitSCMFileSystem.FSFunction<List<SCMFile>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<SCMFile> invoke(Repository repository) throws IOException, InterruptedException {
                ArrayList<SCMFile> arrayList;
                TreeWalk tw;
                RevWalk walk;
                block15: {
                    walk = new RevWalk(repository);
                    RevCommit commit = walk.parseCommit((AnyObjectId)GitSCMFile.this.fs.getCommitId());
                    RevTree tree = commit.getTree();
                    if (GitSCMFile.this.isRoot()) {
                        TreeWalk tw2 = new TreeWalk(repository);
                        tw2.addTree((AnyObjectId)tree);
                        tw2.setRecursive(false);
                        try {
                            ArrayList<SCMFile> result = new ArrayList<SCMFile>();
                            while (tw2.next()) {
                                result.add(new GitSCMFile(GitSCMFile.this.fs, GitSCMFile.this, tw2.getNameString()));
                            }
                            ArrayList<SCMFile> arrayList2 = result;
                            return arrayList2;
                        }
                        finally {
                            AbstractGitSCMSource._release(tw2);
                        }
                    }
                    tw = TreeWalk.forPath((Repository)repository, (String)GitSCMFile.this.getPath(), (RevTree)tree);
                    if (tw != null) break block15;
                    throw new FileNotFoundException();
                }
                try {
                    FileMode fileMode = tw.getFileMode(0);
                    if (fileMode == FileMode.MISSING) {
                        throw new FileNotFoundException();
                    }
                    if (fileMode != FileMode.TREE) {
                        throw new IOException("Not a directory");
                    }
                    tw.enterSubtree();
                    ArrayList<SCMFile> result = new ArrayList<SCMFile>();
                    while (tw.next()) {
                        result.add(new GitSCMFile(GitSCMFile.this.fs, GitSCMFile.this, tw.getNameString()));
                    }
                    arrayList = result;
                }
                catch (Throwable throwable) {
                    AbstractGitSCMSource._release(tw);
                    throw throwable;
                }
                AbstractGitSCMSource._release(tw);
                return arrayList;
                finally {
                    AbstractGitSCMSource._release(walk);
                }
            }
        });
    }

    public long lastModified() throws IOException, InterruptedException {
        return this.fs.lastModified();
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isRoot()) {
            return SCMFile.Type.DIRECTORY;
        }
        return this.fs.invoke(new GitSCMFileSystem.FSFunction<SCMFile.Type>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SCMFile.Type invoke(Repository repository) throws IOException, InterruptedException {
                RevWalk walk = new RevWalk(repository);
                try {
                    TreeWalk tw;
                    block23: {
                        FileMode fileMode;
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            SCMFile.Type type;
                                            RevCommit commit = walk.parseCommit((AnyObjectId)GitSCMFile.this.fs.getCommitId());
                                            RevTree tree = commit.getTree();
                                            tw = TreeWalk.forPath((Repository)repository, (String)GitSCMFile.this.getPath(), (RevTree)tree);
                                            try {
                                                if (tw != null) break block18;
                                                type = SCMFile.Type.NONEXISTENT;
                                            }
                                            catch (Throwable throwable) {
                                                AbstractGitSCMSource._release(tw);
                                                throw throwable;
                                            }
                                            AbstractGitSCMSource._release(tw);
                                            return type;
                                        }
                                        fileMode = tw.getFileMode(0);
                                        if (fileMode != FileMode.MISSING) break block19;
                                        SCMFile.Type type = SCMFile.Type.NONEXISTENT;
                                        AbstractGitSCMSource._release(tw);
                                        return type;
                                    }
                                    if (fileMode != FileMode.EXECUTABLE_FILE) break block20;
                                    SCMFile.Type type = SCMFile.Type.REGULAR_FILE;
                                    AbstractGitSCMSource._release(tw);
                                    return type;
                                }
                                if (fileMode != FileMode.REGULAR_FILE) break block21;
                                SCMFile.Type type = SCMFile.Type.REGULAR_FILE;
                                AbstractGitSCMSource._release(tw);
                                return type;
                            }
                            if (fileMode != FileMode.SYMLINK) break block22;
                            SCMFile.Type type = SCMFile.Type.LINK;
                            AbstractGitSCMSource._release(tw);
                            return type;
                        }
                        if (fileMode != FileMode.TREE) break block23;
                        SCMFile.Type type = SCMFile.Type.DIRECTORY;
                        AbstractGitSCMSource._release(tw);
                        return type;
                    }
                    SCMFile.Type type = SCMFile.Type.OTHER;
                    AbstractGitSCMSource._release(tw);
                    return type;
                }
                finally {
                    AbstractGitSCMSource._release(walk);
                }
            }
        });
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        return this.fs.invoke(new GitSCMFileSystem.FSFunction<InputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public InputStream invoke(Repository repository) throws IOException, InterruptedException {
                RevWalk walk = new RevWalk(repository);
                try {
                    ByteArrayInputStream byteArrayInputStream;
                    RevCommit commit = walk.parseCommit((AnyObjectId)GitSCMFile.this.fs.getCommitId());
                    RevTree tree = commit.getTree();
                    TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)GitSCMFile.this.getPath(), (RevTree)tree);
                    try {
                        if (tw == null) {
                            throw new FileNotFoundException();
                        }
                        FileMode fileMode = tw.getFileMode(0);
                        if (fileMode == FileMode.MISSING) {
                            throw new FileNotFoundException();
                        }
                        if (fileMode == FileMode.TREE) {
                            throw new IOException("Directory");
                        }
                        ObjectId objectId = tw.getObjectId(0);
                        ObjectLoader loader = repository.open((AnyObjectId)objectId);
                        byteArrayInputStream = new ByteArrayInputStream(loader.getBytes());
                    }
                    catch (Throwable throwable) {
                        AbstractGitSCMSource._release(tw);
                        throw throwable;
                    }
                    AbstractGitSCMSource._release(tw);
                    return byteArrayInputStream;
                }
                finally {
                    AbstractGitSCMSource._release(walk);
                }
            }
        });
    }
}

