/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.scm.SCM;
import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;

public abstract class AbstractGitSCMSource
extends SCMSource {
    private static final ConcurrentMap<String, Lock> cacheLocks = new ConcurrentHashMap<String, Lock>();
    private static final Logger LOGGER = Logger.getLogger(AbstractGitSCMSource.class.getName());

    public AbstractGitSCMSource(String id) {
        super(id);
    }

    @CheckForNull
    public abstract String getCredentialsId();

    public abstract String getRemote();

    public abstract String getIncludes();

    public abstract String getExcludes();

    @CheckForNull
    public GitRepositoryBrowser getBrowser() {
        return null;
    }

    @CheckForNull
    public String getGitTool() {
        return null;
    }

    @NonNull
    public List<GitSCMExtension> getExtensions() {
        return Collections.emptyList();
    }

    public String getRemoteName() {
        return "origin";
    }

    @CheckForNull
    protected GitTool resolveGitTool() {
        GitTool tool = ((GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallation(this.getGitTool());
        if (this.getGitTool() == null) {
            tool = GitTool.getDefaultInstallation();
        }
        return tool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doRetrieve(Retriever<T> retriever, @NonNull TaskListener listener, boolean prune) throws IOException, InterruptedException {
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = AbstractGitSCMSource.getCacheLock(cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = AbstractGitSCMSource.getCacheDir(cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitTool tool = this.resolveGitTool();
            if (tool != null) {
                git.using(tool.getGitExe());
            }
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials());
            if (!client.hasGitRepo()) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            String remoteName = this.getRemoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println((prune ? "Fetching & pruning " : "Fetching ") + remoteName + "...");
            FetchCommand fetch = client.fetch_();
            if (prune) {
                fetch = fetch.prune();
            }
            URIish remoteURI = null;
            try {
                remoteURI = new URIish(remoteName);
            }
            catch (URISyntaxException ex) {
                listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
            }
            fetch.from(remoteURI, this.getRefSpecs()).execute();
            T t = retriever.run(client, remoteName);
            return t;
        }
        finally {
            cacheLock.unlock();
        }
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                for (Branch b : client.getRemoteBranches()) {
                    String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                    if (!branchName.equals(head.getName())) continue;
                    return new SCMRevisionImpl(head, b.getSHA1String());
                }
                return null;
            }
        }, listener, false);
    }

    private static void _close(@NonNull Object walk) {
        Method closeMethod;
        try {
            closeMethod = walk.getClass().getDeclaredMethod("close", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            LOGGER.log(Level.SEVERE, "Exception finding walker close method: {0}", ex);
            return;
        }
        catch (SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Exception finding walker close method: {0}", ex);
            return;
        }
        try {
            closeMethod.invoke(walk, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            LOGGER.log(Level.SEVERE, "Exception calling walker close method: {0}", ex);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.SEVERE, "Exception calling walker close method: {0}", ex);
        }
        catch (InvocationTargetException ex) {
            LOGGER.log(Level.SEVERE, "Exception calling walker close method: {0}", ex);
        }
    }

    static void _release(TreeWalk walk) throws IOException {
        if (walk == null) {
            return;
        }
        try {
            walk.release();
        }
        catch (NoSuchMethodError noMethod) {
            AbstractGitSCMSource._close(walk);
        }
    }

    static void _release(RevWalk walk) {
        if (walk == null) {
            return;
        }
        try {
            walk.release();
        }
        catch (NoSuchMethodError noMethod) {
            AbstractGitSCMSource._close(walk);
        }
    }

    protected void retrieve(final @CheckForNull SCMSourceCriteria criteria, final @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.doRetrieve(new Retriever<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run(GitClient client, String remoteName) throws IOException, InterruptedException {
                final Repository repository = client.getRepository();
                listener.getLogger().println("Getting remote branches...");
                RevWalk walk = new RevWalk(repository);
                try {
                    walk.setRetainBody(false);
                    for (Branch b : client.getRemoteBranches()) {
                        AbstractGitSCMSource.this.checkInterrupt();
                        if (!b.getName().startsWith(remoteName + "/")) continue;
                        final String branchName = StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/"));
                        listener.getLogger().println("Checking branch " + branchName);
                        if (AbstractGitSCMSource.this.isExcluded(branchName)) continue;
                        if (criteria != null) {
                            RevTree tree;
                            RevCommit commit = walk.parseCommit((AnyObjectId)b.getSHA1());
                            final long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                            SCMProbe probe = new SCMProbe(tree = commit.getTree()){
                                final /* synthetic */ RevTree val$tree;
                                {
                                    this.val$tree = revTree;
                                }

                                public void close() throws IOException {
                                }

                                public String name() {
                                    return branchName;
                                }

                                public long lastModified() {
                                    return lastModified;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @NonNull
                                public SCMProbeStat stat(@NonNull String path) throws IOException {
                                    TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)this.val$tree);
                                    try {
                                        if (tw == null) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                            return sCMProbeStat;
                                        }
                                        FileMode fileMode = tw.getFileMode(0);
                                        if (fileMode == FileMode.MISSING) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.EXECUTABLE_FILE) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.REGULAR_FILE) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.SYMLINK) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.LINK);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.TREE) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.DIRECTORY);
                                            return sCMProbeStat;
                                        }
                                        SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.OTHER);
                                        return sCMProbeStat;
                                    }
                                    finally {
                                        AbstractGitSCMSource._release(tw);
                                    }
                                }
                            };
                            if (criteria.isHead((SCMSourceCriteria.Probe)probe, listener)) {
                                listener.getLogger().println("Met criteria");
                            } else {
                                listener.getLogger().println("Does not meet criteria");
                                continue;
                            }
                        }
                        SCMHead head = new SCMHead(branchName);
                        SCMRevisionImpl hash = new SCMRevisionImpl(head, b.getSHA1String());
                        observer.observe(head, (SCMRevision)hash);
                        if (observer.isObserving()) continue;
                        Void void_ = null;
                        return void_;
                    }
                }
                finally {
                    AbstractGitSCMSource._release(walk);
                }
                listener.getLogger().println("Done.");
                return null;
            }
        }, listener, true);
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull String revision, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                String hash;
                try {
                    hash = client.revParse(revision).name();
                }
                catch (GitException x) {
                    try {
                        hash = client.revParse("origin/" + revision).name();
                    }
                    catch (GitException x2) {
                        listener.getLogger().println(x.getMessage());
                        listener.getLogger().println(x2.getMessage());
                        return null;
                    }
                }
                return new SCMRevisionImpl(new SCMHead(revision), hash);
            }
        }, listener, false);
    }

    @CheckForNull
    protected Set<String> retrieveRevisions(@NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(new Retriever<Set<String>>(){

            @Override
            public Set<String> run(GitClient client, String remoteName) throws IOException, InterruptedException {
                HashSet<String> revisions = new HashSet<String>();
                for (Branch branch : client.getRemoteBranches()) {
                    revisions.add(branch.getName().replaceFirst("^origin/", ""));
                }
                revisions.addAll(client.getTagNames("*"));
                return revisions;
            }
        }, listener, false);
    }

    protected String getCacheEntry() {
        return AbstractGitSCMSource.getCacheEntry(this.getRemote());
    }

    protected static File getCacheDir(String cacheEntry) {
        boolean ok;
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            LOGGER.severe("Jenkins instance is null in AbstractGitSCMSource.getCacheDir");
            return null;
        }
        File cacheDir = new File(new File(jenkins.getRootDir(), "caches"), cacheEntry);
        if (!cacheDir.isDirectory() && !(ok = cacheDir.mkdirs())) {
            LOGGER.log(Level.WARNING, "Failed mkdirs of {0}", cacheDir);
        }
        return cacheDir;
    }

    protected static Lock getCacheLock(String cacheEntry) {
        Lock cacheLock;
        while (null == (cacheLock = (Lock)cacheLocks.get(cacheEntry))) {
            cacheLocks.putIfAbsent(cacheEntry, new ReentrantLock());
        }
        return cacheLock;
    }

    @CheckForNull
    protected StandardUsernameCredentials getCredentials() {
        String credentialsId = this.getCredentialsId();
        if (credentialsId == null) {
            return null;
        }
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)this.getOwner(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)this.getRemote()).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), GitClient.CREDENTIALS_MATCHER}));
    }

    protected abstract List<RefSpec> getRefSpecs();

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        ArrayList<GitSCMExtension> extensions = new ArrayList<GitSCMExtension>(this.getExtensions());
        if (revision instanceof SCMRevisionImpl) {
            extensions.add(new BuildChooserSetting(new SpecificRevisionBuildChooser((SCMRevisionImpl)revision)));
        }
        return new GitSCM(this.getRemoteConfigs(), Collections.singletonList(new BranchSpec(head.getName())), false, Collections.<SubmoduleConfig>emptyList(), this.getBrowser(), this.getGitTool(), extensions);
    }

    protected List<UserRemoteConfig> getRemoteConfigs() {
        List<RefSpec> refSpecs = this.getRefSpecs();
        ArrayList<UserRemoteConfig> result = new ArrayList<UserRemoteConfig>(refSpecs.size());
        String remote = this.getRemote();
        for (RefSpec refSpec : refSpecs) {
            result.add(new UserRemoteConfig(remote, this.getRemoteName(), refSpec.toString(), this.getCredentialsId()));
        }
        return result;
    }

    protected boolean isExcluded(String branchName) {
        return !Pattern.matches(this.getPattern(this.getIncludes()), branchName) || Pattern.matches(this.getPattern(this.getExcludes()), branchName);
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    static String getCacheEntry(String remote) {
        return "git-" + Util.getDigestOf((String)remote);
    }

    public static class SpecificRevisionBuildChooser
    extends BuildChooser {
        private final Revision revision;

        public SpecificRevisionBuildChooser(SCMRevisionImpl revision) {
            ObjectId sha1 = ObjectId.fromString((String)revision.getHash());
            String name = revision.getHead().getName();
            this.revision = new Revision(sha1, Collections.singleton(new Branch(name, sha1)));
        }

        @Override
        public Collection<Revision> getCandidateRevisions(boolean isPollCall, String singleBranch, GitClient git, TaskListener listener, BuildData buildData, BuildChooserContext context) throws GitException, IOException, InterruptedException {
            return Collections.singleton(this.revision);
        }

        @Override
        public Build prevBuildForChangelog(String branch, @Nullable BuildData data, GitClient git, BuildChooserContext context) throws IOException, InterruptedException {
            return data == null ? null : data.lastBuild;
        }

        @Extension
        public static class DescriptorImpl
        extends BuildChooserDescriptor {
            public String getDisplayName() {
                return "Specific revision";
            }

            @Override
            public boolean isApplicable(Class<? extends Item> job) {
                return SCMSourceOwner.class.isAssignableFrom(job);
            }
        }
    }

    public static class SCMRevisionImpl
    extends SCMRevision {
        private String hash;

        public SCMRevisionImpl(SCMHead head, String hash) {
            super(head);
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            SCMRevisionImpl that = (SCMRevisionImpl)((Object)o);
            return StringUtils.equals((String)this.hash, (String)that.hash) && this.getHead().equals((Object)that.getHead());
        }

        public int hashCode() {
            return this.hash != null ? this.hash.hashCode() : 0;
        }

        public String toString() {
            return this.hash;
        }
    }

    private static interface Retriever<T> {
        public T run(GitClient var1, String var2) throws IOException, InterruptedException;
    }
}

