/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GitoriousWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GitoriousWeb(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.getUrl(), "commit/" + changeSet.getId().toString());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        return new URL(this.getUrl(), "commit/" + changeSet.getId().toString() + "/diffs?diffmode=sidebyside&fragment=1#" + path.getPath());
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLink(path);
        }
        String spec = "blobs/" + path.getChangeSet().getId() + "/" + path.getPath();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + spec);
    }

    @Extension
    public static class GitoriousWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "gitoriousweb";
        }

        public GitoriousWeb newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (GitoriousWeb)((Object)req.bindJSON(GitoriousWeb.class, jsonObject));
        }
    }
}

