/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.Run;
import hudson.plugins.git.GitChangeSet;
import hudson.scm.ChangeLogSet;
import hudson.scm.RepositoryBrowser;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.kohsuke.stapler.export.Exported;

public class GitChangeSetList
extends ChangeLogSet<GitChangeSet> {
    private final List<GitChangeSet> changeSets;

    GitChangeSetList(Run build, RepositoryBrowser<?> browser, List<GitChangeSet> logs) {
        super(build, browser);
        Collections.reverse(logs);
        this.changeSets = Collections.unmodifiableList(logs);
        for (GitChangeSet log : logs) {
            log.setParent(this);
        }
    }

    public boolean isEmptySet() {
        return this.changeSets.isEmpty();
    }

    public Iterator<GitChangeSet> iterator() {
        return this.changeSets.iterator();
    }

    public List<GitChangeSet> getLogs() {
        return this.changeSets;
    }

    @Exported
    public String getKind() {
        return "git";
    }
}

