/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.plugins.git.Messages;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class GitSCMSource
extends AbstractGitSCMSource {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final Logger LOGGER = Logger.getLogger(GitSCMSource.class.getName());
    private final String remote;
    private final String credentialsId;
    private final String includes;
    private final String excludes;
    private final boolean ignoreOnPushNotifications;
    @CheckForNull
    private GitRepositoryBrowser browser;
    @CheckForNull
    private String gitTool;
    private List<GitSCMExtension> extensions;

    @DataBoundConstructor
    public GitSCMSource(String id, String remote, String credentialsId, String includes, String excludes, boolean ignoreOnPushNotifications) {
        super(id);
        this.remote = remote;
        this.credentialsId = credentialsId;
        this.includes = includes;
        this.excludes = excludes;
        this.ignoreOnPushNotifications = ignoreOnPushNotifications;
    }

    public boolean isIgnoreOnPushNotifications() {
        return this.ignoreOnPushNotifications;
    }

    @Override
    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setBrowser(GitRepositoryBrowser browser) {
        this.browser = browser;
    }

    @Override
    public String getGitTool() {
        return this.gitTool;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setGitTool(String gitTool) {
        this.gitTool = Util.fixEmptyAndTrim((String)gitTool);
    }

    @Override
    public List<GitSCMExtension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<GitSCMExtension>(this.extensions));
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setExtensions(List<GitSCMExtension> extensions) {
        this.extensions = Util.fixNull(extensions);
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public String getRemote() {
        return this.remote;
    }

    @Override
    public String getIncludes() {
        return this.includes;
    }

    @Override
    public String getExcludes() {
        return this.excludes;
    }

    @Override
    protected List<RefSpec> getRefSpecs() {
        return Arrays.asList(new RefSpec("+refs/heads/*:refs/remotes/" + this.getRemoteName() + "/*"));
    }

    @Extension
    public static class ListenerImpl
    extends GitStatus.Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<GitStatus.ResponseContributor> onNotifyCommit(URIish uri, final String sha1, List<ParameterValue> buildParameters, String ... branches) {
            boolean[] notified;
            ArrayList<GitStatus.ResponseContributor> result;
            block11: {
                result = new ArrayList<GitStatus.ResponseContributor>();
                notified = new boolean[]{false};
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    LOGGER.severe("Jenkins instance is null in GitSCMSource.onNotifyCommit");
                    return result;
                }
                jenkins.getACL();
                SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
                try {
                    if (branches.length > 0) {
                        final URIish u = uri;
                        for (final String branch : branches) {
                            SCMHeadEvent.fireNow((SCMHeadEvent)new SCMHeadEvent<String>(SCMEvent.Type.UPDATED, branch){

                                public boolean isMatch(@NonNull SCMNavigator navigator) {
                                    return false;
                                }

                                @NonNull
                                public String getSourceName() {
                                    return u.getHumanishName();
                                }

                                public boolean isMatch(SCMSource source) {
                                    if (source instanceof GitSCMSource) {
                                        URIish remote;
                                        GitSCMSource git = (GitSCMSource)source;
                                        if (git.ignoreOnPushNotifications) {
                                            return false;
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return false;
                                        }
                                        if (GitStatus.looselyMatches(u, remote)) {
                                            notified[0] = true;
                                            return true;
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @NonNull
                                public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
                                    SCMHead head = new SCMHead(branch);
                                    return Collections.singletonMap(head, sha1 != null ? new AbstractGitSCMSource.SCMRevisionImpl(head, sha1) : null);
                                }

                                public boolean isMatch(@NonNull SCM scm) {
                                    return false;
                                }
                            });
                        }
                        break block11;
                    }
                    for (final SCMSourceOwner owner : SCMSourceOwners.all()) {
                        for (SCMSource source : owner.getSCMSources()) {
                            URIish remote;
                            GitSCMSource git;
                            if (!(source instanceof GitSCMSource) || (git = (GitSCMSource)source).ignoreOnPushNotifications) continue;
                            try {
                                remote = new URIish(git.getRemote());
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                            if (!GitStatus.looselyMatches(uri, remote)) continue;
                            LOGGER.info("Triggering the indexing of " + owner.getFullDisplayName());
                            owner.onSCMSourceUpdated(source);
                            result.add(new GitStatus.ResponseContributor(){

                                @Override
                                public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                                    rsp.addHeader("Triggered", owner.getAbsoluteUrl());
                                }

                                @Override
                                public void writeBody(PrintWriter w) {
                                    w.println("Scheduled indexing of " + owner.getFullDisplayName());
                                }
                            });
                            notified[0] = true;
                        }
                    }
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)old);
                }
            }
            if (!notified[0]) {
                result.add(new GitStatus.MessageResponseContributor("No Git consumers using SCM API plugin for: " + uri.toString()));
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.GitSCMSource_DisplayName();
        }

        @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="pending https://github.com/jenkinsci/credentials-plugin/pull/68")
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String remote, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, (Item)context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)remote).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String url, @QueryParameter String value) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public GitSCM.DescriptorImpl getSCMDescriptor() {
            return (GitSCM.DescriptorImpl)Jenkins.getInstance().getDescriptor(GitSCM.class);
        }

        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return this.getSCMDescriptor().getExtensionDescriptors();
        }

        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return this.getSCMDescriptor().getBrowserDescriptors();
        }

        public boolean showGitToolOptions() {
            return this.getSCMDescriptor().showGitToolOptions();
        }

        public ListBoxModel doFillGitToolItems() {
            return this.getSCMDescriptor().doFillGitToolItems();
        }
    }
}

