/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import hudson.model.UnprotectedRootAction;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class GitStatus
extends AbstractModelObject
implements UnprotectedRootAction {
    private String lastURL = "";
    private String lastBranches = null;
    private String lastSHA1 = null;
    private List<ParameterValue> lastBuildParameters = null;
    private static List<ParameterValue> lastStaticBuildParameters = null;
    private static final Logger LOGGER = Logger.getLogger(GitStatus.class.getName());

    public String getDisplayName() {
        return "Git";
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public String getIconFileName() {
        return null;
    }

    public String getUrlName() {
        return "git";
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("URL: ");
        s.append(this.lastURL);
        if (this.lastSHA1 != null) {
            s.append(" SHA1: ");
            s.append(this.lastSHA1);
        }
        if (this.lastBranches != null) {
            s.append(" Branches: ");
            s.append(this.lastBranches);
        }
        if (this.lastBuildParameters != null && !this.lastBuildParameters.isEmpty()) {
            s.append(" Parameters: ");
            for (ParameterValue buildParameter : this.lastBuildParameters) {
                s.append(buildParameter.getName());
                s.append("='");
                s.append(buildParameter.getValue());
                s.append("',");
            }
            s.delete(s.length() - 1, s.length());
        }
        if (lastStaticBuildParameters != null && !lastStaticBuildParameters.isEmpty()) {
            s.append(" More parameters: ");
            for (ParameterValue buildParameter : lastStaticBuildParameters) {
                s.append(buildParameter.getName());
                s.append("='");
                s.append(buildParameter.getValue());
                s.append("',");
            }
            s.delete(s.length() - 1, s.length());
        }
        return s.toString();
    }

    public HttpResponse doNotifyCommit(HttpServletRequest request, @QueryParameter(required=true) String url, @QueryParameter(required=false) String branches, @QueryParameter(required=false) String sha1) throws ServletException, IOException {
        URIish uri;
        this.lastURL = url;
        this.lastBranches = branches;
        this.lastSHA1 = sha1;
        this.lastBuildParameters = null;
        lastStaticBuildParameters = null;
        ArrayList<ParameterValue> buildParameters = new ArrayList<ParameterValue>();
        try {
            uri = new URIish(url);
        }
        catch (URISyntaxException e) {
            return HttpResponses.error((int)400, (Throwable)new Exception("Illegal URL: " + url, e));
        }
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (((String)entry.getKey()).equals("url") || ((String)entry.getKey()).equals("branches") || ((String)entry.getKey()).equals("sha1") || ((String[])entry.getValue())[0] == null) continue;
            buildParameters.add((ParameterValue)new StringParameterValue((String)entry.getKey(), ((String[])entry.getValue())[0]));
        }
        this.lastBuildParameters = buildParameters;
        String[] branchesArray = (branches = Util.fixEmptyAndTrim((String)branches)) == null ? new String[]{} : branches.split(",");
        final ArrayList<ResponseContributor> contributors = new ArrayList<ResponseContributor>();
        for (Listener listener : Jenkins.getInstance().getExtensionList(Listener.class)) {
            contributors.addAll(listener.onNotifyCommit(uri, sha1, buildParameters, branchesArray));
        }
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setStatus(200);
                rsp.setContentType("text/plain");
                for (ResponseContributor c : contributors) {
                    c.addHeaders(req, rsp);
                }
                PrintWriter w = rsp.getWriter();
                for (ResponseContributor c : contributors) {
                    c.writeBody(req, rsp, w);
                }
            }
        };
    }

    public static boolean looselyMatches(URIish lhs, URIish rhs) {
        return StringUtils.equals((String)lhs.getHost(), (String)rhs.getHost()) && StringUtils.equals((String)GitStatus.normalizePath(lhs.getPath()), (String)GitStatus.normalizePath(rhs.getPath()));
    }

    private static String normalizePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".git")) {
            path = path.substring(0, path.length() - 4);
        }
        return path;
    }

    public static class CommitHookCause
    extends Cause {
        public final String sha1;

        public CommitHookCause(String sha1) {
            this.sha1 = sha1;
        }

        public String getShortDescription() {
            return "commit notification " + this.sha1;
        }
    }

    public static class MessageResponseContributor
    extends ResponseContributor {
        private final String msg;

        public MessageResponseContributor(String msg) {
            this.msg = msg;
        }

        public void writeBody(PrintWriter w) {
            w.println(this.msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class JenkinsAbstractProjectListener
    extends Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ResponseContributor> onNotifyCommit(URIish uri, String sha1, List<ParameterValue> buildParameters, String ... branches) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Received notification for uri = " + uri + " ; sha1 = " + sha1 + " ; branches = " + Arrays.toString(branches));
            }
            lastStaticBuildParameters = null;
            ArrayList<ParameterValue> allBuildParameters = new ArrayList<ParameterValue>(buildParameters);
            ArrayList<ResponseContributor> result = new ArrayList<ResponseContributor>();
            SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
            try {
                boolean scmFound = false;
                boolean urlFound = false;
                block3: for (Item project : Jenkins.getInstance().getAllItems()) {
                    SCMTriggerItem scmTriggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                    if (scmTriggerItem == null) continue;
                    block4: for (SCM scm : scmTriggerItem.getSCMs()) {
                        if (!(scm instanceof GitSCM)) continue;
                        GitSCM git = (GitSCM)scm;
                        scmFound = true;
                        for (RemoteConfig repository : git.getRepositories()) {
                            boolean repositoryMatches = false;
                            boolean branchMatches = false;
                            URIish matchedURL = null;
                            for (URIish remoteURL : repository.getURIs()) {
                                if (!GitStatus.looselyMatches(uri, remoteURL)) continue;
                                repositoryMatches = true;
                                matchedURL = remoteURL;
                                break;
                            }
                            if (!repositoryMatches || git.getExtensions().get(IgnoreNotifyCommit.class) != null) continue;
                            SCMTrigger trigger = scmTriggerItem.getSCMTrigger();
                            if (trigger == null || trigger.isIgnorePostCommitHooks()) {
                                LOGGER.info("no trigger, or post-commit hooks disabled, on " + project.getFullDisplayName());
                                continue;
                            }
                            boolean branchFound = false;
                            boolean parametrizedBranchSpec = false;
                            if (branches.length == 0) {
                                branchFound = true;
                            } else {
                                block7: for (BranchSpec branchSpec : git.getBranches()) {
                                    if (branchSpec.getName().contains("$")) {
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine("Branch Spec is parametrized for " + project.getFullDisplayName() + ". ");
                                        }
                                        branchFound = true;
                                        parametrizedBranchSpec = true;
                                        continue;
                                    }
                                    for (String branch : branches) {
                                        if (!branchSpec.matches(repository.getName() + "/" + branch)) continue;
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.fine("Branch Spec " + branchSpec + " matches modified branch " + branch + " for " + project.getFullDisplayName() + ". ");
                                        }
                                        branchFound = true;
                                        break block7;
                                    }
                                }
                            }
                            if (!branchFound) continue;
                            urlFound = true;
                            if (project instanceof AbstractProject && ((AbstractProject)project).isDisabled()) continue block4;
                            if (project instanceof Job) {
                                HashSet<String> buildParametersNames = new HashSet<String>();
                                for (ParameterValue parameterValue : allBuildParameters) {
                                    buildParametersNames.add(parameterValue.getName());
                                }
                                ArrayList<ParameterValue> jobParametersValues = this.getDefaultParametersValues((Job)project);
                                for (ParameterValue defaultParameterValue : jobParametersValues) {
                                    if (buildParametersNames.contains(defaultParameterValue.getName())) continue;
                                    allBuildParameters.add(defaultParameterValue);
                                }
                            }
                            if (!parametrizedBranchSpec && StringUtils.isNotEmpty((String)sha1)) {
                                LOGGER.info("Scheduling " + project.getFullDisplayName() + " to build commit " + sha1);
                                scmTriggerItem.scheduleBuild2(scmTriggerItem.getQuietPeriod(), new Action[]{new CauseAction((Cause)new CommitHookCause(sha1)), new RevisionParameterAction(sha1, matchedURL), new ParametersAction(allBuildParameters)});
                                result.add(new ScheduledResponseContributor(project));
                                continue block4;
                            }
                            LOGGER.info("Triggering the polling of " + project.getFullDisplayName());
                            trigger.run();
                            result.add(new PollingScheduledResponseContributor(project));
                            continue block3;
                        }
                    }
                }
                if (!scmFound) {
                    result.add(new MessageResponseContributor("No git jobs found"));
                } else if (!urlFound) {
                    result.add(new MessageResponseContributor("No git jobs using repository: " + uri.toString() + " and branches: " + StringUtils.join((Object[])branches, (String)",")));
                }
                lastStaticBuildParameters = allBuildParameters;
                ArrayList<ResponseContributor> arrayList = result;
                return arrayList;
            }
            finally {
                SecurityContextHolder.setContext((SecurityContext)old);
            }
        }

        private ArrayList<ParameterValue> getDefaultParametersValues(Job<?, ?> job) {
            ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
            if (paramDefProp == null) {
                ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
                return defValues;
            }
            List parameterDefinition = paramDefProp.getParameterDefinitions();
            ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>(parameterDefinition.size());
            for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
                ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
                if (defaultValue == null) continue;
                defValues.add(defaultValue);
            }
            return defValues;
        }

        private static class ScheduledResponseContributor
        extends ResponseContributor {
            private final Item project;

            public ScheduledResponseContributor(Item project) {
                this.project = project;
            }

            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
            }

            public void writeBody(PrintWriter w) {
                w.println("Scheduled " + this.project.getFullDisplayName());
            }
        }

        private static class PollingScheduledResponseContributor
        extends ResponseContributor {
            private final Item project;

            public PollingScheduledResponseContributor(Item project) {
                this.project = project;
            }

            public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                rsp.addHeader("Triggered", this.project.getAbsoluteUrl());
            }

            public void writeBody(PrintWriter w) {
                w.println("Scheduled polling of " + this.project.getFullDisplayName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Listener
    implements ExtensionPoint {
        public List<ResponseContributor> onNotifyCommit(URIish uri, String[] branches) {
            throw new AbstractMethodError();
        }

        public List<ResponseContributor> onNotifyCommit(URIish uri, @Nullable String sha1, String ... branches) {
            return this.onNotifyCommit(uri, branches);
        }

        public List<ResponseContributor> onNotifyCommit(URIish uri, @Nullable String sha1, List<ParameterValue> buildParameters, String ... branches) {
            return this.onNotifyCommit(uri, sha1, branches);
        }
    }

    public static class ResponseContributor {
        public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
        }

        public void writeBody(StaplerRequest req, StaplerResponse rsp, PrintWriter w) {
            this.writeBody(w);
        }

        public void writeBody(PrintWriter w) {
        }
    }
}

