/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.collect.Iterables;
import com.thoughtworks.xstream.converters.Converter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.GitSCMBackwardCompatibility;
import hudson.plugins.git.GitTagAction;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.ObjectIdConverter;
import hudson.plugins.git.RemoteConfigConverter;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.SubmoduleConfig;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.browser.GithubWeb;
import hudson.plugins.git.extensions.GitClientConflictException;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.extensions.impl.AuthorInChangelog;
import hudson.plugins.git.extensions.impl.BuildChooserSetting;
import hudson.plugins.git.extensions.impl.ChangelogToBranch;
import hudson.plugins.git.opt.PreBuildMergeOptions;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.BuildChooser;
import hudson.plugins.git.util.BuildChooserContext;
import hudson.plugins.git.util.BuildChooserDescriptor;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.git.util.DefaultBuildChooser;
import hudson.plugins.git.util.GitUtils;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogParser;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.triggers.SCMTrigger;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.IOException2;
import hudson.util.IOUtils;
import hudson.util.ListBoxModel;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitSCM
extends GitSCMBackwardCompatibility {
    private Long configVersion;
    private List<UserRemoteConfig> userRemoteConfigs;
    private transient List<RemoteConfig> remoteRepositories;
    private List<BranchSpec> branches;
    private boolean doGenerateSubmoduleConfigurations;
    public String gitTool = null;
    private GitRepositoryBrowser browser;
    private Collection<SubmoduleConfig> submoduleCfg;
    public static final String GIT_BRANCH = "GIT_BRANCH";
    public static final String GIT_COMMIT = "GIT_COMMIT";
    public static final String GIT_PREVIOUS_COMMIT = "GIT_PREVIOUS_COMMIT";
    public static final String GIT_PREVIOUS_SUCCESSFUL_COMMIT = "GIT_PREVIOUS_SUCCESSFUL_COMMIT";
    private DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> extensions;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitSCM.class.getName());
    public static boolean VERBOSE = Boolean.getBoolean(GitSCM.class.getName() + ".verbose");
    public static final int MAX_CHANGELOG = Integer.getInteger(GitSCM.class.getName() + ".maxChangelog", 1024);

    public Collection<SubmoduleConfig> getSubmoduleCfg() {
        return this.submoduleCfg;
    }

    public void setSubmoduleCfg(Collection<SubmoduleConfig> submoduleCfg) {
        this.submoduleCfg = submoduleCfg;
    }

    private static List<UserRemoteConfig> createRepoList(String url) {
        ArrayList<UserRemoteConfig> repoList = new ArrayList<UserRemoteConfig>();
        repoList.add(new UserRemoteConfig(url, null, null, null));
        return repoList;
    }

    public GitSCM(String repositoryUrl) {
        this(GitSCM.createRepoList(repositoryUrl), Collections.singletonList(new BranchSpec("")), false, Collections.emptyList(), null, null, null);
    }

    @DataBoundConstructor
    public GitSCM(List<UserRemoteConfig> userRemoteConfigs, List<BranchSpec> branches, Boolean doGenerateSubmoduleConfigurations, Collection<SubmoduleConfig> submoduleCfg, GitRepositoryBrowser browser, String gitTool, List<GitSCMExtension> extensions) {
        if (branches == null) {
            branches = new ArrayList<BranchSpec>();
        }
        if (branches.isEmpty()) {
            branches.add(new BranchSpec("*/master"));
        }
        this.branches = branches;
        this.userRemoteConfigs = userRemoteConfigs;
        this.updateFromUserData();
        this.browser = browser;
        this.doGenerateSubmoduleConfigurations = doGenerateSubmoduleConfigurations != null ? doGenerateSubmoduleConfigurations : false;
        if (submoduleCfg == null) {
            submoduleCfg = new ArrayList<SubmoduleConfig>();
        }
        this.submoduleCfg = submoduleCfg;
        this.configVersion = 2L;
        this.gitTool = gitTool;
        this.extensions = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(extensions));
        this.getBuildChooser();
    }

    @Override
    public DescribableList<GitSCMExtension, GitSCMExtensionDescriptor> getExtensions() {
        return this.extensions;
    }

    private void updateFromUserData() throws GitException {
        if (this.userRemoteConfigs == null) {
            return;
        }
        try {
            String[] pUrls = new String[this.userRemoteConfigs.size()];
            String[] repoNames = new String[this.userRemoteConfigs.size()];
            String[] refSpecs = new String[this.userRemoteConfigs.size()];
            for (int i = 0; i < this.userRemoteConfigs.size(); ++i) {
                pUrls[i] = this.userRemoteConfigs.get(i).getUrl();
                repoNames[i] = this.userRemoteConfigs.get(i).getName();
                refSpecs[i] = this.userRemoteConfigs.get(i).getRefspec();
            }
            this.remoteRepositories = DescriptorImpl.createRepositoryConfigurations(pUrls, repoNames, refSpecs);
        }
        catch (IOException e1) {
            throw new GitException("Error creating repositories", (Throwable)e1);
        }
    }

    public Object readResolve() throws IOException {
        if (this.configVersion == null) {
            this.configVersion = 0L;
        }
        if (this.source != null) {
            this.remoteRepositories = new ArrayList<RemoteConfig>();
            this.branches = new ArrayList<BranchSpec>();
            this.doGenerateSubmoduleConfigurations = false;
            ArrayList<RefSpec> rs = new ArrayList<RefSpec>();
            rs.add(new RefSpec("+refs/heads/*:refs/remotes/origin/*"));
            this.remoteRepositories.add(this.newRemoteConfig("origin", this.source, rs.toArray(new RefSpec[0])));
            if (this.branch != null) {
                this.branches.add(new BranchSpec(this.branch));
            } else {
                this.branches.add(new BranchSpec("*/master"));
            }
        }
        if (this.configVersion < 1L && this.branches != null) {
            for (BranchSpec branchSpec : this.branches) {
                String name = branchSpec.getName();
                name = name.replace("*", "**");
                branchSpec.setName(name);
            }
        }
        if (this.remoteRepositories != null && this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
            for (RemoteConfig cfg : this.remoteRepositories) {
                String url = "";
                if (cfg.getURIs().size() > 0 && cfg.getURIs().get(0) != null) {
                    url = ((URIish)cfg.getURIs().get(0)).toPrivateString();
                }
                String refspec = "";
                if (cfg.getFetchRefSpecs().size() > 0 && cfg.getFetchRefSpecs().get(0) != null) {
                    refspec = ((RefSpec)cfg.getFetchRefSpecs().get(0)).toString();
                }
                this.userRemoteConfigs.add(new UserRemoteConfig(url, cfg.getName(), refspec, null));
            }
        }
        if (this.remoteRepositories == null) {
            try {
                this.updateFromUserData();
            }
            catch (GitException e) {
                LOGGER.log(Level.WARNING, "Failed to load SCM data", e);
            }
        }
        if (this.extensions == null) {
            this.extensions = new DescribableList(Saveable.NOOP);
        }
        this.readBackExtensionsFromLegacy();
        if (this.choosingStrategy != null && this.getBuildChooser().getClass() == DefaultBuildChooser.class) {
            for (BuildChooserDescriptor d : BuildChooser.all()) {
                if (!this.choosingStrategy.equals(d.getLegacyId())) continue;
                try {
                    this.setBuildChooser((BuildChooser)d.clazz.newInstance());
                }
                catch (InstantiationException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
                catch (IllegalAccessException e) {
                    LOGGER.log(Level.WARNING, "Failed to instantiate the build chooser", e);
                }
            }
        }
        this.getBuildChooser();
        return this;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    public RepositoryBrowser<?> guessBrowser() {
        List uris;
        if (this.remoteRepositories != null && this.remoteRepositories.size() == 1 && (uris = this.remoteRepositories.get(0).getURIs()).size() == 1) {
            String uri = ((URIish)uris.get(0)).toString();
            Matcher m = Pattern.compile("(https://github[.]com/[^/]+/[^/]+)[.]git").matcher(uri);
            if (m.matches()) {
                return new GithubWeb(m.group(1) + "/");
            }
            m = Pattern.compile("git@github[.]com:([^/]+/[^/]+)[.]git").matcher(uri);
            if (m.matches()) {
                return new GithubWeb("https://github.com/" + m.group(1) + "/");
            }
        }
        return null;
    }

    public boolean isCreateAccountBasedOnEmail() {
        DescriptorImpl gitDescriptor = this.getDescriptor();
        return gitDescriptor != null && gitDescriptor.isCreateAccountBasedOnEmail();
    }

    public BuildChooser getBuildChooser() {
        BuildChooserSetting bcs = (BuildChooserSetting)this.getExtensions().get(BuildChooserSetting.class);
        BuildChooser bc = bcs != null ? bcs.getBuildChooser() : new DefaultBuildChooser();
        bc.gitSCM = this;
        return bc;
    }

    public void setBuildChooser(BuildChooser buildChooser) throws IOException {
        if (buildChooser.getClass() == DefaultBuildChooser.class) {
            this.getExtensions().remove(BuildChooserSetting.class);
        } else {
            this.getExtensions().replace((Describable)new BuildChooserSetting(buildChooser));
        }
    }

    @Deprecated
    public String getParamLocalBranch(Run<?, ?> build) throws IOException, InterruptedException {
        return this.getParamLocalBranch(build, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
    }

    public String getParamLocalBranch(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String branch = this.getLocalBranch();
        return GitSCM.getParameterString(branch != null ? branch : null, build.getEnvironment(listener));
    }

    @Deprecated
    public List<RemoteConfig> getParamExpandedRepos(Run<?, ?> build) throws IOException, InterruptedException {
        return this.getParamExpandedRepos(build, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
    }

    public List<RemoteConfig> getParamExpandedRepos(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<RemoteConfig> expandedRepos = new ArrayList<RemoteConfig>();
        EnvVars env = build.getEnvironment(listener);
        for (RemoteConfig oldRepo : Util.fixNull(this.remoteRepositories)) {
            expandedRepos.add(this.getParamExpandedRepo(env, oldRepo));
        }
        return expandedRepos;
    }

    public RemoteConfig getParamExpandedRepo(EnvVars env, RemoteConfig remoteRepository) {
        return this.newRemoteConfig(GitSCM.getParameterString(remoteRepository.getName(), env), GitSCM.getParameterString(((URIish)remoteRepository.getURIs().get(0)).toPrivateString(), env), this.getRefSpecs(remoteRepository, env).toArray(new RefSpec[0]));
    }

    public RemoteConfig getRepositoryByName(String repoName) {
        for (RemoteConfig r : this.getRepositories()) {
            if (!r.getName().equals(repoName)) continue;
            return r;
        }
        return null;
    }

    @Exported
    public List<UserRemoteConfig> getUserRemoteConfigs() {
        if (this.userRemoteConfigs == null) {
            this.userRemoteConfigs = new ArrayList<UserRemoteConfig>();
        }
        return Collections.unmodifiableList(this.userRemoteConfigs);
    }

    public List<RemoteConfig> getRepositories() {
        if (this.remoteRepositories == null) {
            return new ArrayList<RemoteConfig>();
        }
        return this.remoteRepositories;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    public static String getParameterString(String original, EnvVars env) {
        return env.expand(original);
    }

    private List<RefSpec> getRefSpecs(RemoteConfig repo, EnvVars env) {
        ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
        for (RefSpec refSpec : repo.getFetchRefSpecs()) {
            refSpecs.add(new RefSpec(GitSCM.getParameterString(refSpec.toString(), env)));
        }
        return refSpecs;
    }

    private String getSingleBranch(EnvVars env) {
        if (this.getBranches().size() != 1) {
            return null;
        }
        String branch = this.getBranches().get(0).getName();
        String repository = null;
        if (this.getRepositories().size() != 1) {
            for (RemoteConfig repo : this.getRepositories()) {
                if (!branch.startsWith(repo.getName() + "/")) continue;
                repository = repo.getName();
                break;
            }
            if (repository == null) {
                return null;
            }
        } else {
            repository = this.getRepositories().get(0).getName();
        }
        if (branch.startsWith("*/")) {
            branch = repository + branch.substring(1);
        }
        if (branch.contains("*")) {
            return null;
        }
        if ((branch = GitSCM.getParameterString(branch, env)).equals("")) {
            branch = "**";
        }
        return branch;
    }

    public SCMRevisionState calcRevisionsFromBuild(Run<?, ?> abstractBuild, FilePath workspace, Launcher launcher, TaskListener taskListener) throws IOException, InterruptedException {
        return SCMRevisionState.NONE;
    }

    public boolean requiresWorkspaceForPolling() {
        for (GitSCMExtension ext : this.getExtensions()) {
            if (!ext.requiresWorkspaceForPolling()) continue;
            return true;
        }
        return this.getSingleBranch(new EnvVars()) == null;
    }

    public PollingResult compareRemoteRevisionWith(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener, SCMRevisionState baseline) throws IOException, InterruptedException {
        try {
            return this.compareRemoteRevisionWithImpl(project, launcher, workspace, listener);
        }
        catch (GitException e) {
            throw new IOException2((Throwable)e);
        }
    }

    private static Node workspaceToNode(FilePath workspace) {
        Jenkins j = Jenkins.getInstance();
        if (workspace != null && workspace.isRemote()) {
            for (Computer c : j.getComputers()) {
                Node n;
                if (c.getChannel() != workspace.getChannel() || (n = c.getNode()) == null) continue;
                return n;
            }
        }
        return j;
    }

    private PollingResult compareRemoteRevisionWithImpl(Job<?, ?> project, Launcher launcher, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String singleBranch;
        listener.getLogger().println("Using strategy: " + this.getBuildChooser().getDisplayName());
        Run lastBuild = project.getLastBuild();
        if (lastBuild == null) {
            listener.getLogger().println("[poll] No previous build, so forcing an initial build.");
            return PollingResult.BUILD_NOW;
        }
        BuildData buildData = this.fixNull(this.getBuildData(lastBuild));
        if (buildData.lastBuild != null) {
            listener.getLogger().println("[poll] Last Built Revision: " + buildData.lastBuild.revision);
        }
        if ((singleBranch = this.getSingleBranch(lastBuild.getEnvironment(listener))) != null && buildData.lastBuild != null && buildData.lastBuild.getMarked() != null && !this.requiresWorkspaceForPolling()) {
            String gitRepo;
            EnvVars environment = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener, false) : new EnvVars();
            GitClient git = this.createClient(listener, environment, project, (Node)Jenkins.getInstance(), null);
            ObjectId head = git.getHeadRev(gitRepo = ((URIish)this.getParamExpandedRepos(lastBuild, listener).get(0).getURIs().get(0)).toString(), singleBranch);
            if (head != null) {
                listener.getLogger().println("[poll] Latest remote head revision is: " + head.getName());
                if (buildData.lastBuild.getMarked().getSha1().equals((AnyObjectId)head)) {
                    return PollingResult.NO_CHANGES;
                }
                return PollingResult.BUILD_NOW;
            }
            listener.getLogger().println("[poll] Couldn't get remote head revision");
            return PollingResult.BUILD_NOW;
        }
        EnvVars environment = project instanceof AbstractProject ? GitUtils.getPollEnvironment((AbstractProject)project, workspace, launcher, listener) : new EnvVars();
        FilePath workingDirectory = this.workingDirectory(project, workspace, environment, listener);
        if (workingDirectory == null || !workingDirectory.exists()) {
            return PollingResult.BUILD_NOW;
        }
        GitClient git = this.createClient(listener, environment, project, GitSCM.workspaceToNode(workspace), workingDirectory);
        if (git.hasGitRepo()) {
            listener.getLogger().println("Fetching changes from the remote Git repositories");
            for (RemoteConfig remoteRepository : this.getParamExpandedRepos(lastBuild, listener)) {
                this.fetchFrom(git, listener, remoteRepository);
            }
            listener.getLogger().println("Polling for changes in");
            Collection<Revision> candidates = this.getBuildChooser().getCandidateRevisions(true, singleBranch, git, listener, buildData, (BuildChooserContext)new BuildChooserContextImpl(project, null, environment));
            for (Revision c : candidates) {
                if (this.isRevExcluded(git, c, listener, buildData)) continue;
                return PollingResult.SIGNIFICANT;
            }
            return PollingResult.NO_CHANGES;
        }
        listener.getLogger().println("No Git repository yet, an initial checkout is required");
        return PollingResult.SIGNIFICANT;
    }

    public GitClient createClient(TaskListener listener, EnvVars environment, Run<?, ?> build, FilePath workspace) throws IOException, InterruptedException {
        FilePath ws = this.workingDirectory(build.getParent(), workspace, environment, listener);
        if (ws != null) {
            ws.mkdirs();
        }
        return this.createClient(listener, environment, build.getParent(), GitSCM.workspaceToNode(workspace), ws);
    }

    GitClient createClient(TaskListener listener, EnvVars environment, Job project, Node n, FilePath ws) throws IOException, InterruptedException {
        String gitExe = this.getGitExe(n, listener);
        Git git = Git.with((TaskListener)listener, (EnvVars)environment).in(ws).using(gitExe);
        GitClient c = git.getClient();
        for (GitSCMExtension ext : this.extensions) {
            c = ext.decorate(this, c);
        }
        for (UserRemoteConfig uc : this.getUserRemoteConfigs()) {
            if (uc.getCredentialsId() == null) continue;
            String url = uc.getUrl();
            url = GitSCM.getParameterString(url, environment);
            StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)project, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)uc.getCredentialsId()), GitClient.CREDENTIALS_MATCHER}));
            if (credentials == null) continue;
            c.addCredentials(url, (StandardCredentials)credentials);
        }
        return c;
    }

    private BuildData fixNull(BuildData bd) {
        return bd != null ? bd : new BuildData(this.getScmName(), this.getUserRemoteConfigs());
    }

    private void fetchFrom(GitClient git, TaskListener listener, RemoteConfig remoteRepository) throws InterruptedException, IOException {
        boolean first = true;
        for (URIish url : remoteRepository.getURIs()) {
            try {
                if (first) {
                    git.setRemoteUrl(remoteRepository.getName(), url.toPrivateASCIIString());
                    first = false;
                } else {
                    git.addRemoteUrl(remoteRepository.getName(), url.toPrivateASCIIString());
                }
                FetchCommand fetch = git.fetch_().from(url, remoteRepository.getFetchRefSpecs());
                for (GitSCMExtension extension : this.extensions) {
                    extension.decorateFetchCommand(this, git, listener, fetch);
                }
                fetch.execute();
            }
            catch (GitException ex) {
                throw new GitException("Failed to fetch from " + url.toString(), (Throwable)ex);
            }
        }
    }

    private RemoteConfig newRemoteConfig(String name, String refUrl, RefSpec ... refSpec) {
        try {
            Config repoConfig = new Config();
            repoConfig.setString("remote", name, "url", refUrl);
            ArrayList<String> str = new ArrayList<String>();
            if (refSpec != null && refSpec.length > 0) {
                for (RefSpec rs : refSpec) {
                    str.add(rs.toString());
                }
            }
            repoConfig.setStringList("remote", name, "fetch", str);
            return (RemoteConfig)RemoteConfig.getAllRemoteConfigs((Config)repoConfig).get(0);
        }
        catch (Exception ex) {
            throw new GitException("Error trying to create JGit configuration", (Throwable)ex);
        }
    }

    public GitTool resolveGitTool(TaskListener listener) {
        if (this.gitTool == null) {
            return GitTool.getDefaultInstallation();
        }
        GitTool git = ((GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallation(this.gitTool);
        if (git == null) {
            listener.getLogger().println("selected Git installation does not exists. Using Default");
            git = GitTool.getDefaultInstallation();
        }
        return git;
    }

    public String getGitExe(Node builtOn, TaskListener listener) {
        return this.getGitExe(builtOn, null, listener);
    }

    public String getGitExe(Node builtOn, EnvVars env, TaskListener listener) {
        GitClientType client = GitClientType.ANY;
        for (GitSCMExtension ext : this.extensions) {
            try {
                client = client.combine(ext.getRequiredClient());
            }
            catch (GitClientConflictException e) {
                throw new RuntimeException(ext.getDescriptor().getDisplayName() + " extended Git behavior is incompatible with other behaviors");
            }
        }
        if (client == GitClientType.JGIT) {
            return "jgit";
        }
        GitTool tool = this.resolveGitTool(listener);
        if (builtOn != null) {
            try {
                tool = tool.forNode(builtOn, listener);
            }
            catch (IOException e) {
                listener.getLogger().println("Failed to get git executable");
            }
            catch (InterruptedException e) {
                listener.getLogger().println("Failed to get git executable");
            }
        }
        if (env != null) {
            tool = tool.forEnvironment(env);
        }
        return tool.getGitExe();
    }

    public AbstractBuild<?, ?> getBySHA1(String sha1) {
        AbstractProject p = (AbstractProject)Stapler.getCurrentRequest().findAncestorObject(AbstractProject.class);
        for (AbstractBuild b : p.getBuilds()) {
            Build lb;
            BuildData d = (BuildData)b.getAction(BuildData.class);
            if (d == null || d.lastBuild == null || !(lb = d.lastBuild).isFor(sha1)) continue;
            return b;
        }
        return null;
    }

    @NonNull
    private Build determineRevisionToBuild(Run build, BuildData buildData, EnvVars environment, GitClient git, TaskListener listener) throws IOException, InterruptedException {
        Revision marked;
        RevisionParameterAction rpa;
        Build lastBuild;
        BuildData parentBuildData;
        MatrixBuild parentBuild;
        PrintStream log = listener.getLogger();
        Collection<Object> candidates = Collections.EMPTY_LIST;
        if (build instanceof MatrixRun && (parentBuild = ((MatrixRun)build).getParentBuild()) != null && (parentBuildData = this.getBuildData((Run)parentBuild)) != null && (lastBuild = parentBuildData.lastBuild) != null) {
            candidates = Collections.singleton(lastBuild.getMarked());
        }
        if (candidates.isEmpty() && (rpa = (RevisionParameterAction)build.getAction(RevisionParameterAction.class)) != null) {
            candidates = Collections.singleton(rpa.toRevision(git));
        }
        if (candidates.isEmpty()) {
            String singleBranch = environment.expand(this.getSingleBranch(environment));
            BuildChooserContextImpl context = new BuildChooserContextImpl(build.getParent(), build, environment);
            candidates = this.getBuildChooser().getCandidateRevisions(false, singleBranch, git, listener, buildData, (BuildChooserContext)context);
        }
        if (candidates.isEmpty()) {
            throw new AbortException("Couldn't find any revision to build. Verify the repository and branch configuration for this job.");
        }
        Revision rev = marked = (Revision)candidates.iterator().next();
        for (GitSCMExtension ext : this.extensions) {
            rev = ext.decorateRevisionToBuild(this, build, git, listener, marked, rev);
        }
        Build revToBuild = new Build(marked, rev, build.getNumber(), null);
        buildData.saveBuild(revToBuild);
        if (candidates.size() > 1) {
            AbstractProject project;
            log.println("Multiple candidate revisions");
            Job job = build.getParent();
            if (job instanceof AbstractProject && !(project = (AbstractProject)job).isDisabled()) {
                log.println("Scheduling another build to catch up with " + project.getFullDisplayName());
                if (!project.scheduleBuild(0, (Cause)new SCMTrigger.SCMTriggerCause("This build was triggered by build " + build.getNumber() + " because more than one build candidate was found."))) {
                    log.println("WARNING: multiple candidate revisions, but unable to schedule build of " + project.getFullDisplayName());
                }
            }
        }
        return revToBuild;
    }

    private void retrieveChanges(Run build, GitClient git, TaskListener listener) throws IOException, InterruptedException {
        PrintStream log = listener.getLogger();
        List<RemoteConfig> repos = this.getParamExpandedRepos(build, listener);
        if (repos.isEmpty()) {
            return;
        }
        if (git.hasGitRepo()) {
            if (repos.size() == 1) {
                log.println("Fetching changes from the remote Git repository");
            } else {
                log.println(MessageFormat.format("Fetching changes from {0} remote Git repositories", repos.size()));
            }
        } else {
            log.println("Cloning the remote Git repository");
            RemoteConfig rc = repos.get(0);
            try {
                CloneCommand cmd = git.clone_().url(((URIish)rc.getURIs().get(0)).toPrivateString()).repositoryName(rc.getName());
                for (GitSCMExtension ext : this.extensions) {
                    ext.decorateCloneCommand(this, build, git, listener, cmd);
                }
                cmd.execute();
            }
            catch (GitException ex) {
                String message = "Error cloning remote repo '" + rc.getName() + "'";
                listener.error(message);
                throw new AbortException(message);
            }
        }
        for (RemoteConfig remoteRepository : repos) {
            try {
                this.fetchFrom(git, listener, remoteRepository);
            }
            catch (GitException ex) {
                String message = "Error fetching remote repo '" + remoteRepository.getName() + "'";
                listener.error(message);
                throw new AbortException(message);
            }
        }
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        if (VERBOSE) {
            listener.getLogger().println("Using strategy: " + this.getBuildChooser().getDisplayName());
        }
        BuildData previousBuildData = this.getBuildData(build.getPreviousBuild());
        BuildData buildData = this.copyBuildData(build.getPreviousBuild());
        build.addAction((Action)buildData);
        if (VERBOSE && buildData.lastBuild != null) {
            listener.getLogger().println("Last Built Revision: " + buildData.lastBuild.revision);
        }
        EnvVars environment = build.getEnvironment(listener);
        GitClient git = this.createClient(listener, environment, build, workspace);
        for (GitSCMExtension ext : this.extensions) {
            ext.beforeCheckout(this, build, git, listener);
        }
        this.retrieveChanges(build, git, listener);
        Build revToBuild = this.determineRevisionToBuild(build, buildData, environment, git, listener);
        environment.put(GIT_COMMIT, revToBuild.revision.getSha1String());
        Branch branch = (Branch)Iterables.getFirst((Iterable)revToBuild.revision.getBranches(), null);
        if (branch != null) {
            environment.put(GIT_BRANCH, this.getBranchName(branch));
        }
        listener.getLogger().println("Checking out " + revToBuild.revision);
        CheckoutCommand checkoutCommand = git.checkout().branch(this.getParamLocalBranch(build, listener)).ref(revToBuild.revision.getSha1String()).deleteBranchIfExist(true);
        for (GitSCMExtension ext : this.getExtensions()) {
            ext.decorateCheckoutCommand(this, build, git, listener, checkoutCommand);
        }
        try {
            checkoutCommand.execute();
        }
        catch (GitLockFailedException e) {
            throw new IOException("Could not checkout " + revToBuild.revision.getSha1String(), e);
        }
        build.addAction((Action)new GitTagAction(build, workspace, buildData));
        if (changelogFile != null) {
            this.computeChangeLog(git, revToBuild.revision, listener, previousBuildData, new FilePath(changelogFile), new BuildChooserContextImpl(build.getParent(), build, environment));
        }
        for (GitSCMExtension ext : this.extensions) {
            ext.onCheckoutCompleted(this, build, git, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeChangeLog(GitClient git, Revision revToBuild, TaskListener listener, BuildData previousBuildData, FilePath changelogFile, BuildChooserContext context) throws IOException, InterruptedException {
        OutputStreamWriter out = new OutputStreamWriter(changelogFile.write(), "UTF-8");
        boolean executed = false;
        ChangelogCommand changelog = git.changelog();
        changelog.includes(revToBuild.getSha1());
        try {
            boolean exclusion = false;
            ChangelogToBranch changelogToBranch = (ChangelogToBranch)this.getExtensions().get(ChangelogToBranch.class);
            if (changelogToBranch != null) {
                listener.getLogger().println("Using 'Changelog to branch' strategy.");
                changelog.excludes(changelogToBranch.getOptions().getRef());
                exclusion = true;
            } else {
                for (Branch b : revToBuild.getBranches()) {
                    Build lastRevWas = this.getBuildChooser().prevBuildForChangelog(b.getName(), previousBuildData, git, context);
                    if (lastRevWas == null || lastRevWas.revision == null || !git.isCommitInRepo(lastRevWas.getSHA1())) continue;
                    changelog.excludes(lastRevWas.getSHA1());
                    exclusion = true;
                }
            }
            if (!exclusion) {
                listener.getLogger().println("First time build. Skipping changelog.");
            } else {
                changelog.to((Writer)out).max(MAX_CHANGELOG).execute();
                executed = true;
            }
        }
        catch (GitException ge) {
            ge.printStackTrace(listener.error("Unable to retrieve changeset"));
        }
        finally {
            if (!executed) {
                changelog.abort();
            }
            IOUtils.closeQuietly((Writer)out);
        }
    }

    public void buildEnvVars(AbstractBuild<?, ?> build, Map<String, String> env) {
        super.buildEnvVars(build, env);
        Revision rev = this.fixNull(this.getBuildData((Run)build)).getLastBuiltRevision();
        if (rev != null) {
            Branch branch = (Branch)Iterables.getFirst((Iterable)rev.getBranches(), null);
            if (branch != null) {
                String prevSuccessfulCommit;
                env.put(GIT_BRANCH, this.getBranchName(branch));
                String prevCommit = this.getLastBuiltCommitOfBranch(build, branch);
                if (prevCommit != null) {
                    env.put(GIT_PREVIOUS_COMMIT, prevCommit);
                }
                if ((prevSuccessfulCommit = this.getLastSuccessfulBuiltCommitOfBranch(build, branch)) != null) {
                    env.put(GIT_PREVIOUS_SUCCESSFUL_COMMIT, prevSuccessfulCommit);
                }
            }
            env.put(GIT_COMMIT, Util.fixEmpty((String)rev.getSha1String()));
        }
        if (this.userRemoteConfigs.size() == 1) {
            env.put("GIT_URL", this.userRemoteConfigs.get(0).getUrl());
        } else {
            int count = 1;
            for (UserRemoteConfig config : this.userRemoteConfigs) {
                env.put("GIT_URL_" + count, config.getUrl());
                ++count;
            }
        }
        this.getDescriptor().populateEnvironmentVariables(env);
        for (GitSCMExtension ext : this.extensions) {
            ext.populateEnvironmentVariables(this, env);
        }
    }

    private String getBranchName(Branch branch) {
        String name = branch.getName();
        if (name.startsWith("refs/remotes/")) {
            name = name.substring("refs/remotes/".length());
        }
        return name;
    }

    private String getLastBuiltCommitOfBranch(AbstractBuild<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousBuiltBuild() != null && (lastBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousBuiltBuild())).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    private String getLastSuccessfulBuiltCommitOfBranch(AbstractBuild<?, ?> build, Branch branch) {
        Revision previousRev;
        Build lastSuccessfulBuildOfBranch;
        String prevCommit = null;
        if (build.getPreviousSuccessfulBuild() != null && (lastSuccessfulBuildOfBranch = this.fixNull(this.getBuildData(build.getPreviousSuccessfulBuild())).getLastBuildOfBranch(branch.getName())) != null && (previousRev = lastSuccessfulBuildOfBranch.getRevision()) != null) {
            prevCommit = previousRev.getSha1String();
        }
        return prevCommit;
    }

    public ChangeLogParser createChangeLogParser() {
        return new GitChangeLogParser(this.getExtensions().get(AuthorInChangelog.class) != null);
    }

    public boolean isDoGenerateSubmoduleConfigurations() {
        return this.doGenerateSubmoduleConfigurations;
    }

    @Exported
    public List<BranchSpec> getBranches() {
        return this.branches;
    }

    public String getKey() {
        String name = this.getScmName();
        if (name != null) {
            return name;
        }
        StringBuilder b = new StringBuilder("git");
        for (RemoteConfig cfg : this.getRepositories()) {
            for (URIish uri : cfg.getURIs()) {
                b.append(' ').append(uri.toString());
            }
        }
        return b.toString();
    }

    @Exported
    @Deprecated
    public PreBuildMergeOptions getMergeOptions() throws Descriptor.FormException {
        return DescriptorImpl.createMergeOptions(this.getUserMergeOptions(), this.remoteRepositories);
    }

    private boolean isRelevantBuildData(BuildData bd) {
        for (UserRemoteConfig c : this.getUserRemoteConfigs()) {
            if (!bd.hasBeenReferenced(c.getUrl())) continue;
            return true;
        }
        return false;
    }

    public BuildData getBuildData(Run build, boolean clone) {
        return clone ? this.copyBuildData(build) : this.getBuildData(build);
    }

    public BuildData copyBuildData(Run build) {
        BuildData base = this.getBuildData(build);
        if (base == null) {
            return new BuildData(this.getScmName(), this.getUserRemoteConfigs());
        }
        BuildData buildData = base.clone();
        buildData.setScmName(this.getScmName());
        return buildData;
    }

    @CheckForNull
    public BuildData getBuildData(Run build) {
        BuildData buildData = null;
        while (build != null) {
            List buildDataList = build.getActions(BuildData.class);
            for (BuildData bd : buildDataList) {
                if (bd == null || !this.isRelevantBuildData(bd)) continue;
                buildData = bd;
                break;
            }
            if (buildData != null) break;
            build = build.getPreviousBuild();
        }
        return buildData;
    }

    protected FilePath workingDirectory(Job<?, ?> context, FilePath workspace, EnvVars environment, TaskListener listener) throws IOException, InterruptedException {
        if (workspace == null) {
            return null;
        }
        for (GitSCMExtension ext : this.extensions) {
            FilePath r = ext.getWorkingDirectory(this, context, workspace, environment, listener);
            if (r == null) continue;
            return r;
        }
        return workspace;
    }

    private boolean isRevExcluded(GitClient git, Revision r, TaskListener listener, BuildData buildData) throws IOException, InterruptedException {
        try {
            List revShow = buildData != null && buildData.lastBuild != null ? git.showRevision(buildData.lastBuild.revision.getSha1(), r.getSha1()) : git.showRevision(r.getSha1());
            revShow.add("commit ");
            int start = 0;
            int idx = 0;
            for (String line : revShow) {
                if (line.startsWith("commit ") && idx != 0) {
                    GitSCMExtension ext;
                    GitChangeSet change = new GitChangeSet(revShow.subList(start, idx), this.getExtensions().get(AuthorInChangelog.class) != null);
                    Boolean excludeThisCommit = null;
                    Iterator i$ = this.extensions.iterator();
                    while (i$.hasNext() && (excludeThisCommit = (ext = (GitSCMExtension)((Object)i$.next())).isRevExcluded(this, git, change, listener, buildData)) == null) {
                    }
                    if (excludeThisCommit == null || !excludeThisCommit.booleanValue()) {
                        return false;
                    }
                    start = idx;
                }
                ++idx;
            }
            assert (start == revShow.size() - 1);
            return true;
        }
        catch (GitException e) {
            e.printStackTrace(listener.error("Failed to determine if we want to exclude " + r.getSha1String()));
            return false;
        }
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void onLoaded() {
        DescriptorImpl desc = (DescriptorImpl)Jenkins.getInstance().getDescriptorByType(DescriptorImpl.class);
        if (desc.getOldGitExe() != null) {
            String defaultGit;
            String exe = desc.getOldGitExe();
            if (exe.equals(defaultGit = GitTool.getDefaultInstallation().getGitExe())) {
                return;
            }
            System.err.println("[WARNING] you're using deprecated gitexe attribute to configure git plugin. Use Git installations");
        }
    }

    @Initializer(before=InitMilestone.JOB_LOADED)
    public static void configureXtream() {
        Run.XSTREAM.registerConverter((Converter)new ObjectIdConverter());
        Items.XSTREAM.registerConverter((Converter)new RemoteConfigConverter(Items.XSTREAM));
        Items.XSTREAM.alias("org.spearce.jgit.transport.RemoteConfig", RemoteConfig.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends SCMDescriptor<GitSCM> {
        private String gitExe;
        private String globalConfigName;
        private String globalConfigEmail;
        private boolean createAccountBasedOnEmail;

        public DescriptorImpl() {
            super(GitSCM.class, GitRepositoryBrowser.class);
            this.load();
        }

        public String getDisplayName() {
            return "Git";
        }

        public boolean isApplicable(Job project) {
            return true;
        }

        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return GitSCMExtensionDescriptor.all();
        }

        public boolean showGitToolOptions() {
            return ((GitTool[])((GitTool.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations()).length > 1;
        }

        public List<GitTool> getGitTools() {
            GitTool[] gitToolInstallations = (GitTool[])((GitTool.DescriptorImpl)Hudson.getInstance().getDescriptorByType(GitTool.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(gitToolInstallations);
        }

        public ListBoxModel doFillGitToolItems() {
            ListBoxModel r = new ListBoxModel();
            for (GitTool git : this.getGitTools()) {
                r.add(git.getName());
            }
            return r;
        }

        @Deprecated
        public String getGitExe() {
            return this.gitExe;
        }

        public String getGlobalConfigName() {
            return Util.fixEmptyAndTrim((String)this.globalConfigName);
        }

        public void setGlobalConfigName(String globalConfigName) {
            this.globalConfigName = globalConfigName;
        }

        public String getGlobalConfigEmail() {
            return Util.fixEmptyAndTrim((String)this.globalConfigEmail);
        }

        public void setGlobalConfigEmail(String globalConfigEmail) {
            this.globalConfigEmail = globalConfigEmail;
        }

        public boolean isCreateAccountBasedOnEmail() {
            return this.createAccountBasedOnEmail;
        }

        public void setCreateAccountBasedOnEmail(boolean createAccountBasedOnEmail) {
            this.createAccountBasedOnEmail = createAccountBasedOnEmail;
        }

        public String getOldGitExe() {
            return this.gitExe;
        }

        private GitRepositoryBrowser getBrowserFromRequest(StaplerRequest req, JSONObject scmData) {
            if (scmData.containsKey((Object)"browser")) {
                return (GitRepositoryBrowser)((Object)req.bindJSON(GitRepositoryBrowser.class, scmData.getJSONObject("browser")));
            }
            return null;
        }

        public static List<RemoteConfig> createRepositoryConfigurations(String[] urls, String[] repoNames, String[] refs) throws IOException {
            List remoteRepositories;
            Config repoConfig = new Config();
            String[] names = repoNames;
            names = GitUtils.fixupNames(names, urls);
            for (int i = 0; i < names.length; ++i) {
                String url = urls[i];
                if (url == null) continue;
                String name = names[i];
                name = name.replace(' ', '_');
                if (StringUtils.isBlank((String)refs[i])) {
                    refs[i] = "+refs/heads/*:refs/remotes/" + name + "/*";
                }
                repoConfig.setString("remote", name, "url", url);
                repoConfig.setStringList("remote", name, "fetch", new ArrayList<String>(Arrays.asList(refs[i].split("\\s+"))));
            }
            try {
                remoteRepositories = RemoteConfig.getAllRemoteConfigs((Config)repoConfig);
            }
            catch (Exception e) {
                throw new GitException("Error creating repositories", (Throwable)e);
            }
            return remoteRepositories;
        }

        public static PreBuildMergeOptions createMergeOptions(UserMergeOptions mergeOptionsBean, List<RemoteConfig> remoteRepositories) throws Descriptor.FormException {
            PreBuildMergeOptions mergeOptions = new PreBuildMergeOptions();
            if (mergeOptionsBean != null) {
                RemoteConfig mergeRemote = null;
                String mergeRemoteName = mergeOptionsBean.getMergeRemote().trim();
                if (mergeRemoteName.length() == 0) {
                    mergeRemote = remoteRepositories.get(0);
                } else {
                    for (RemoteConfig remote : remoteRepositories) {
                        if (!remote.getName().equals(mergeRemoteName)) continue;
                        mergeRemote = remote;
                        break;
                    }
                }
                if (mergeRemote == null) {
                    throw new Descriptor.FormException("No remote repository configured with name '" + mergeRemoteName + "'", "git.mergeRemote");
                }
                mergeOptions.setMergeRemote(mergeRemote);
                mergeOptions.setMergeTarget(mergeOptionsBean.getMergeTarget());
                mergeOptions.setMergeStrategy(mergeOptionsBean.getMergeStrategy());
            }
            return mergeOptions;
        }

        public FormValidation doGitRemoteNameCheck(StaplerRequest req) throws IOException, ServletException {
            boolean isMerge;
            String mergeRemoteName = req.getParameter("value");
            boolean bl = isMerge = req.getParameter("isMerge") != null;
            if (mergeRemoteName.length() == 0 && isMerge) {
                return FormValidation.ok();
            }
            String[] urls = req.getParameterValues("repo.url");
            String[] names = req.getParameterValues("repo.name");
            if (urls != null && names != null) {
                for (String name : GitUtils.fixupNames(names, urls)) {
                    if (!name.equals(mergeRemoteName)) continue;
                    return FormValidation.ok();
                }
            }
            return FormValidation.error((String)("No remote repository configured with name '" + mergeRemoteName + "'"));
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        public void populateEnvironmentVariables(Map<String, String> env) {
            String email;
            String name = this.getGlobalConfigName();
            if (name != null) {
                env.put("GIT_COMMITTER_NAME", name);
                env.put("GIT_AUTHOR_NAME", name);
            }
            if ((email = this.getGlobalConfigEmail()) != null) {
                env.put("GIT_COMMITTER_EMAIL", email);
                env.put("GIT_AUTHOR_EMAIL", email);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BuildChooserContextImpl
    implements BuildChooserContext,
    Serializable {
        final Job project;
        final Run build;
        final EnvVars environment;

        BuildChooserContextImpl(Job project, Run build, EnvVars environment) {
            this.project = project;
            this.build = build;
            this.environment = environment;
        }

        @Override
        public <T> T actOnBuild(BuildChooserContext.ContextCallable<Run<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.build, (VirtualChannel)Hudson.MasterComputer.localChannel);
        }

        @Override
        public <T> T actOnProject(BuildChooserContext.ContextCallable<Job<?, ?>, T> callable) throws IOException, InterruptedException {
            return callable.invoke(this.project, (VirtualChannel)Hudson.MasterComputer.localChannel);
        }

        @Override
        public Run<?, ?> getBuild() {
            return this.build;
        }

        @Override
        public EnvVars getEnvironment() {
            return this.environment;
        }

        private Object writeReplace() {
            return Channel.current().export(BuildChooserContext.class, (Object)new BuildChooserContext(){

                @Override
                public <T> T actOnBuild(BuildChooserContext.ContextCallable<Run<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(BuildChooserContextImpl.this.build, (VirtualChannel)Channel.current());
                }

                @Override
                public <T> T actOnProject(BuildChooserContext.ContextCallable<Job<?, ?>, T> callable) throws IOException, InterruptedException {
                    return callable.invoke(BuildChooserContextImpl.this.project, (VirtualChannel)Channel.current());
                }

                @Override
                public Run<?, ?> getBuild() {
                    return BuildChooserContextImpl.this.build;
                }

                @Override
                public EnvVars getEnvironment() {
                    return BuildChooserContextImpl.this.environment;
                }
            });
        }
    }
}

