/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.git.Branch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class BranchSpec
extends AbstractDescribableImpl<BranchSpec>
implements Serializable {
    private static final long serialVersionUID = -6177158367915899356L;
    private String name;

    @Exported
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name.length() == 0 ? "**" : name.trim();
    }

    @DataBoundConstructor
    public BranchSpec(String name) {
        this.setName(name);
    }

    public String toString() {
        return this.name;
    }

    public boolean matches(String item) {
        EnvVars env = new EnvVars();
        return this.matches(item, env);
    }

    public boolean matches(String item, EnvVars env) {
        return this.getPattern(env).matcher(item).matches();
    }

    public List<String> filterMatching(Collection<String> branches) {
        EnvVars env = new EnvVars();
        return this.filterMatching(branches, env);
    }

    public List<String> filterMatching(Collection<String> branches, EnvVars env) {
        ArrayList<String> items = new ArrayList<String>();
        for (String b : branches) {
            if (!this.matches(b, env)) continue;
            items.add(b);
        }
        return items;
    }

    public List<Branch> filterMatchingBranches(Collection<Branch> branches) {
        EnvVars env = new EnvVars();
        return this.filterMatchingBranches(branches, env);
    }

    public List<Branch> filterMatchingBranches(Collection<Branch> branches, EnvVars env) {
        ArrayList<Branch> items = new ArrayList<Branch>();
        for (Branch b : branches) {
            if (!this.matches(b.getName(), env)) continue;
            items.add(b);
        }
        return items;
    }

    private String getExpandedName(EnvVars env) {
        return env.expand(this.name);
    }

    private Pattern getPattern(EnvVars env) {
        String expandedName = this.getExpandedName(env);
        if (expandedName.startsWith(":") && expandedName.length() > 1) {
            String regexSubstring = expandedName.substring(1, expandedName.length());
            return Pattern.compile(regexSubstring);
        }
        String qualifiedName = !expandedName.contains("**") && !expandedName.contains("/") ? "*/" + expandedName : expandedName;
        StringBuilder builder = new StringBuilder();
        boolean foundWildcard = false;
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, "*", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("*")) {
                if (foundWildcard) {
                    builder.append(".*");
                    foundWildcard = false;
                    continue;
                }
                foundWildcard = true;
                continue;
            }
            if (foundWildcard) {
                builder.append("[^/]*");
                foundWildcard = false;
            }
            builder.append(Pattern.quote(token));
        }
        if (foundWildcard) {
            builder.append("[^/]*");
        }
        return Pattern.compile(builder.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<BranchSpec> {
        public String getDisplayName() {
            return "Branch Spec";
        }
    }
}

