/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class GithubWeb
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GithubWeb(String repoUrl) {
        super(repoUrl);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commit/" + changeSet.getId().toString());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.getDiffLinkRegardlessOfEditType(path);
    }

    private URL getDiffLinkRegardlessOfEditType(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        ArrayList<String> affectedPaths = new ArrayList<String>(changeSet.getAffectedPaths());
        Collections.sort(affectedPaths);
        String pathAsString = path.getPath();
        int i = Collections.binarySearch(affectedPaths, pathAsString);
        assert (i >= 0);
        return new URL(this.getChangeSetLink(changeSet), "#diff-" + String.valueOf(i));
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLinkRegardlessOfEditType(path);
        }
        String spec = "blob/" + path.getChangeSet().getId() + "/" + path.getPath();
        URL url = this.getUrl();
        return new URL(url, url.getPath() + spec);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class GithubWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "githubweb";
        }

        public GithubWeb newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (GithubWeb)((Object)req.bindJSON(GithubWeb.class, jsonObject));
        }
    }
}

