/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(optional=true)
public class GitBranchTokenMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter
    public boolean all;
    @DataBoundTokenMacro.Parameter
    public boolean fullName;

    public boolean acceptsMacroName(String macroName) {
        return macroName.equals("GIT_BRANCH");
    }

    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        BuildData data = (BuildData)context.getAction(BuildData.class);
        if (data == null) {
            return "";
        }
        Revision lb = data.getLastBuiltRevision();
        if (lb == null || lb.getBranches().isEmpty()) {
            return "";
        }
        if (this.all) {
            StringBuilder buf = new StringBuilder();
            for (Branch b : lb.getBranches()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(this.format(b));
            }
            return buf.toString();
        }
        return this.format((Branch)lb.getBranches().iterator().next());
    }

    private String format(Branch b) {
        String n = b.getName();
        if (this.fullName) {
            return n;
        }
        return n.substring(n.indexOf(47) + 1);
    }
}

