/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserMergeOptions;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.Build;
import hudson.plugins.git.util.GitUtils;
import hudson.plugins.git.util.MergeRecord;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreBuildMerge
extends GitSCMExtension {
    private UserMergeOptions options;

    @DataBoundConstructor
    public PreBuildMerge(UserMergeOptions options) {
        if (options == null) {
            throw new IllegalStateException();
        }
        this.options = options;
    }

    public UserMergeOptions getOptions() {
        return this.options;
    }

    @Override
    public Revision decorateRevisionToBuild(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, Revision rev) throws IOException, InterruptedException {
        String remoteBranchRef = GitSCM.getParameterString(this.options.getRef(), build.getEnvironment((TaskListener)listener));
        if (rev.containsBranchName(remoteBranchRef)) {
            return rev;
        }
        listener.getLogger().println("Merging " + rev + " onto " + remoteBranchRef + " using " + scm.getUserMergeOptions().getMergeStrategy().toString() + " strategy");
        ObjectId target = git.revParse(remoteBranchRef);
        String paramLocalBranch = scm.getParamLocalBranch(build);
        CheckoutCommand checkoutCommand = git.checkout().branch(paramLocalBranch).ref(remoteBranchRef).deleteBranchIfExist(true);
        for (GitSCMExtension ext : scm.getExtensions()) {
            ext.decorateCheckoutCommand(scm, build, git, listener, checkoutCommand);
        }
        checkoutCommand.execute();
        try {
            MergeCommand cmd = git.merge().setRevisionToMerge(rev.getSha1());
            for (GitSCMExtension ext : scm.getExtensions()) {
                ext.decorateMergeCommand(scm, build, git, listener, cmd);
            }
            cmd.execute();
        }
        catch (GitException ex) {
            checkoutCommand = git.checkout().branch(paramLocalBranch).ref(rev.getSha1String()).deleteBranchIfExist(true);
            for (GitSCMExtension ext : scm.getExtensions()) {
                ext.decorateCheckoutCommand(scm, build, git, listener, checkoutCommand);
            }
            checkoutCommand.execute();
            scm.getBuildData((Run)build).saveBuild(new Build(rev, build.getNumber(), Result.FAILURE));
            throw new AbortException("Branch not suitable for integration as it does not merge cleanly");
        }
        build.addAction((Action)new MergeRecord(remoteBranchRef, target.getName()));
        return new GitUtils((TaskListener)listener, git).getRevisionForSHA1(git.revParse("HEAD"));
    }

    @Override
    public void decorateMergeCommand(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, MergeCommand cmd) throws IOException, InterruptedException, GitException {
        if (scm.getUserMergeOptions().getMergeStrategy() != null) {
            cmd.setStrategy(scm.getUserMergeOptions().getMergeStrategy());
        }
    }

    @Override
    public GitClientType getRequiredClient() {
        return GitClientType.GITCLI;
    }

    @Extension
    public static class DescriptorImpl
    extends GitSCMExtensionDescriptor {
        public String getDisplayName() {
            return "Merge before build";
        }
    }
}

