/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.MarkupText;
import hudson.Util;
import hudson.model.Hudson;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.plugins.git.GitSCM;
import hudson.scm.ChangeLogAnnotator;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.tasks.Mailer;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitChangeSet
extends ChangeLogSet.Entry {
    private static final String PREFIX_AUTHOR = "author ";
    private static final String PREFIX_COMMITTER = "committer ";
    private static final String IDENTITY = "([^<]*)<(.*)> (.*) (.*)";
    private static final Pattern FILE_LOG_ENTRY = Pattern.compile("^:[0-9]{6} [0-9]{6} ([0-9a-f]{40}) ([0-9a-f]{40}) ([ACDMRTUX])(?>[0-9]+)?\t(.*)$");
    private static final Pattern AUTHOR_ENTRY = Pattern.compile("^author ([^<]*)<(.*)> (.*) (.*)$");
    private static final Pattern COMMITTER_ENTRY = Pattern.compile("^committer ([^<]*)<(.*)> (.*) (.*)$");
    private static final Pattern RENAME_SPLIT = Pattern.compile("^(.*?)\t(.*)$");
    private static final String NULL_HASH = "0000000000000000000000000000000000000000";
    private String branch;
    private String committer;
    private String committerEmail;
    private String committerTime;
    private String committerTz;
    private String author;
    private String authorEmail;
    private String authorTime;
    private String authorTz;
    private String comment;
    private String title;
    private String id;
    private String parentCommit;
    private Collection<Path> paths = new HashSet<Path>();
    private boolean authorOrCommitter;

    public GitChangeSet(List<String> lines, boolean authorOrCommitter) {
        this.authorOrCommitter = authorOrCommitter;
        if (lines.size() > 0) {
            this.parseCommit(lines);
        }
    }

    private void parseCommit(List<String> lines) {
        StringBuilder message = new StringBuilder();
        for (String line : lines) {
            String mode;
            Matcher fileMatcher;
            if (line.length() < 1) continue;
            if (line.startsWith("commit ")) {
                this.id = line.split(" ")[1];
                continue;
            }
            if (line.startsWith("tree ")) continue;
            if (line.startsWith("parent ")) {
                this.parentCommit = line.split(" ")[1];
                continue;
            }
            if (line.startsWith(PREFIX_COMMITTER)) {
                Matcher committerMatcher = COMMITTER_ENTRY.matcher(line);
                if (!committerMatcher.matches() || committerMatcher.groupCount() < 4) continue;
                this.committer = committerMatcher.group(1).trim();
                this.committerEmail = committerMatcher.group(2);
                this.committerTime = committerMatcher.group(3);
                this.committerTz = committerMatcher.group(4);
                continue;
            }
            if (line.startsWith(PREFIX_AUTHOR)) {
                Matcher authorMatcher = AUTHOR_ENTRY.matcher(line);
                if (!authorMatcher.matches() || authorMatcher.groupCount() < 4) continue;
                this.author = authorMatcher.group(1).trim();
                this.authorEmail = authorMatcher.group(2);
                this.authorTime = authorMatcher.group(3);
                this.authorTz = authorMatcher.group(4);
                continue;
            }
            if (line.startsWith("    ")) {
                message.append(line.substring(4)).append('\n');
                continue;
            }
            if (':' != line.charAt(0) || !(fileMatcher = FILE_LOG_ENTRY.matcher(line)).matches() || fileMatcher.groupCount() < 4 || (mode = fileMatcher.group(3)).length() != 1) continue;
            String src = null;
            String dst = null;
            String path = fileMatcher.group(4);
            char editMode = mode.charAt(0);
            if (editMode == 'M' || editMode == 'A' || editMode == 'D' || editMode == 'R' || editMode == 'C') {
                src = this.parseHash(fileMatcher.group(1));
                dst = this.parseHash(fileMatcher.group(2));
            }
            if (editMode == 'R') {
                Matcher renameSplitMatcher = RENAME_SPLIT.matcher(path);
                if (!renameSplitMatcher.matches() || renameSplitMatcher.groupCount() < 2) continue;
                String oldPath = renameSplitMatcher.group(1);
                String newPath = renameSplitMatcher.group(2);
                this.paths.add(new Path(src, dst, 'D', oldPath, this));
                this.paths.add(new Path(src, dst, 'A', newPath, this));
                continue;
            }
            if (editMode == 'C') {
                Matcher copySplitMatcher = RENAME_SPLIT.matcher(path);
                if (!copySplitMatcher.matches() || copySplitMatcher.groupCount() < 2) continue;
                String newPath = copySplitMatcher.group(2);
                this.paths.add(new Path(src, dst, 'A', newPath, this));
                continue;
            }
            this.paths.add(new Path(src, dst, editMode, path, this));
        }
        this.comment = message.toString();
        int endOfFirstLine = this.comment.indexOf(10);
        this.title = endOfFirstLine == -1 ? this.comment : this.comment.substring(0, endOfFirstLine);
    }

    private String parseHash(String hash) {
        return NULL_HASH.equals(hash) ? null : hash;
    }

    @Exported
    public String getDate() {
        Date csDate;
        String csTz;
        String csTime;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.authorOrCommitter) {
            csTime = this.authorTime;
            csTz = this.authorTz;
        } else {
            csTime = this.committerTime;
            csTz = this.committerTz;
        }
        try {
            csDate = new Date(Long.parseLong(csTime) * 1000L);
        }
        catch (NumberFormatException e) {
            csDate = new Date();
        }
        String dateStr = fmt.format(csDate) + " " + csTz;
        return dateStr;
    }

    public long getTimestamp() {
        return Long.parseLong(this.authorOrCommitter ? this.authorTime : this.committerTime) * 1000L;
    }

    public String getCommitId() {
        return this.id;
    }

    public void setParent(ChangeLogSet parent) {
        super.setParent(parent);
    }

    public String getParentCommit() {
        return this.parentCommit;
    }

    public Collection<String> getAffectedPaths() {
        HashSet<String> affectedPaths = new HashSet<String>(this.paths.size());
        for (Path file : this.paths) {
            affectedPaths.add(file.getPath());
        }
        return affectedPaths;
    }

    @Exported
    public Collection<Path> getPaths() {
        return this.paths;
    }

    public Collection<Path> getAffectedFiles() {
        return this.paths;
    }

    public User findOrCreateUser(String csAuthor, String csAuthorEmail, boolean createAccountBasedOnEmail) {
        User user;
        if (createAccountBasedOnEmail) {
            user = User.get((String)csAuthorEmail, (boolean)false);
            if (user == null) {
                try {
                    user = User.get((String)csAuthorEmail, (boolean)true);
                    user.setFullName(csAuthor);
                    if (this.hasHudsonTasksMailer()) {
                        this.setMail(user, csAuthorEmail);
                    }
                    user.save();
                }
                catch (IOException e) {}
            }
        } else {
            user = User.get((String)csAuthor, (boolean)false);
            if (user == null) {
                user = User.get((String)csAuthorEmail.split("@")[0], (boolean)true);
            }
        }
        if (Util.fixEmpty((String)csAuthorEmail) != null && this.hasHudsonTasksMailer() && !this.hasMail(user)) {
            try {
                this.setMail(user, csAuthorEmail);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return user;
    }

    private void setMail(User user, String csAuthorEmail) throws IOException {
        user.addProperty((UserProperty)new Mailer.UserProperty(csAuthorEmail));
    }

    private boolean hasMail(User user) {
        Mailer.UserProperty property = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
        return property != null && property.hasExplicitlyConfiguredAddress();
    }

    private boolean hasHudsonTasksMailer() {
        try {
            Class.forName("hudson.tasks.Mailer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isCreateAccountBasedOnEmail() {
        GitSCM.DescriptorImpl descriptor = (GitSCM.DescriptorImpl)Hudson.getInstance().getDescriptor(GitSCM.class);
        return descriptor.isCreateAccountBasedOnEmail();
    }

    @Exported
    public User getAuthor() {
        String csAuthorEmail;
        String csAuthor;
        if (this.authorOrCommitter) {
            csAuthor = this.author;
            csAuthorEmail = this.authorEmail;
        } else {
            csAuthor = this.committer;
            csAuthorEmail = this.committerEmail;
        }
        if (csAuthor == null) {
            throw new RuntimeException("No author in changeset " + this.id);
        }
        return this.findOrCreateUser(csAuthor, csAuthorEmail, this.isCreateAccountBasedOnEmail());
    }

    public String getAuthorName() {
        String csAuthor;
        String string = csAuthor = this.authorOrCommitter ? this.author : this.committer;
        if (csAuthor == null) {
            throw new RuntimeException("No author in changeset " + this.id);
        }
        return csAuthor;
    }

    @Exported
    public String getMsg() {
        return this.title;
    }

    @Exported
    public String getId() {
        return this.id;
    }

    public String getRevision() {
        return this.id;
    }

    @Exported
    public String getComment() {
        return this.comment;
    }

    public String getCommentAnnotated() {
        MarkupText markup = new MarkupText(this.getComment());
        for (ChangeLogAnnotator a : ChangeLogAnnotator.all()) {
            a.annotate(this.getParent().build, (ChangeLogSet.Entry)this, markup);
        }
        return markup.toString(false);
    }

    public String getBranch() {
        return this.branch;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GitChangeSet) {
            return this.id != null && this.id.equals(((GitChangeSet)((Object)obj)).id);
        }
        return false;
    }

    @ExportedBean(defaultVisibility=999)
    public static class Path
    implements ChangeLogSet.AffectedFile {
        private String src;
        private String dst;
        private char action;
        private String path;
        private GitChangeSet changeSet;

        private Path(String source, String destination, char action, String filePath, GitChangeSet changeSet) {
            this.src = source;
            this.dst = destination;
            this.action = action;
            this.path = filePath;
            this.changeSet = changeSet;
        }

        public String getSrc() {
            return this.src;
        }

        public String getDst() {
            return this.dst;
        }

        @Exported(name="file")
        public String getPath() {
            return this.path;
        }

        public GitChangeSet getChangeSet() {
            return this.changeSet;
        }

        @Exported
        public EditType getEditType() {
            switch (this.action) {
                case 'A': {
                    return EditType.ADD;
                }
                case 'D': {
                    return EditType.DELETE;
                }
            }
            return EditType.EDIT;
        }
    }
}

