/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GitBlitRepositoryBrowser
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private final String projectName;

    @DataBoundConstructor
    public GitBlitRepositoryBrowser(String url, String projectName) {
        super(url);
        this.projectName = projectName;
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "blobdiff?r=%s&h=%s&hb=%s", this.encodeString(this.projectName), path.getChangeSet().getId(), path.getChangeSet().getParentCommit()));
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return null;
        }
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "blob?r=%s&h=%s&f=%s", this.encodeString(this.projectName), path.getChangeSet().getId(), this.encodeString(path.getPath())));
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, String.format(url.getPath() + "commit?r=%s&h=%s", this.encodeString(this.projectName), changeSet.getId()));
    }

    public String getProjectName() {
        return this.projectName;
    }

    private String encodeString(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ViewGitWebDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "gitblit";
        }

        public GitBlitRepositoryBrowser newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (GitBlitRepositoryBrowser)((Object)req.bindJSON(GitBlitRepositoryBrowser.class, jsonObject));
        }

        public FormValidation doCheckUrl(final @QueryParameter(fixEmpty=true) String url) throws IOException, ServletException {
            if (url == null) {
                return FormValidation.ok();
            }
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    String v = url;
                    if (!v.endsWith("/")) {
                        v = v + '/';
                    }
                    try {
                        if (this.findText(this.open(new URL(v)), "Gitblit")) {
                            return FormValidation.ok();
                        }
                        return FormValidation.error((String)"This is a valid URL but it doesn't look like Gitblit");
                    }
                    catch (IOException e) {
                        return this.handleIOException(v, e);
                    }
                }
            }.check();
        }
    }
}

