/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Util;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.queue.FoldableAction;
import hudson.plugins.git.Branch;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.Revision;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jgit.lib.ObjectId;
import org.jenkinsci.plugins.gitclient.GitClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionParameterAction
extends InvisibleAction
implements Serializable,
Queue.QueueAction,
FoldableAction {
    public final String commit;
    public final boolean combineCommits;
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RevisionParameterAction.class.getName());

    public RevisionParameterAction(String commit) {
        this(commit, false);
    }

    public RevisionParameterAction(String commit, boolean combineCommits) {
        this.commit = commit;
        this.combineCommits = combineCommits;
    }

    @Deprecated
    public Revision toRevision(IGitAPI git) {
        return this.toRevision((GitClient)git);
    }

    public Revision toRevision(GitClient git) {
        ObjectId sha1 = git.revParse(this.commit);
        Revision revision = new Revision(sha1);
        revision.getBranches().add(new Branch("detached", sha1));
        return revision;
    }

    public String toString() {
        return super.toString() + "[commit=" + this.commit + "]";
    }

    public boolean shouldSchedule(List<Action> actions) {
        List otherActions = Util.filter(actions, RevisionParameterAction.class);
        if (this.combineCommits) {
            if (otherActions.size() != 0) {
                return false;
            }
        } else {
            for (RevisionParameterAction action : otherActions) {
                if (!this.commit.equals(action.commit)) continue;
                return false;
            }
        }
        return true;
    }

    public void foldIntoExisting(Queue.Item item, Queue.Task owner, List<Action> otherActions) {
        if (this.combineCommits) {
            RevisionParameterAction existing = (RevisionParameterAction)item.getAction(RevisionParameterAction.class);
            if (existing != null) {
                item.getActions().remove(existing);
                item.getActions().add(this);
                return;
            }
            item.getActions().add(this);
        }
    }
}

