/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.verifier;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Objects;
import org.jenkinsci.plugins.gitclient.verifier.ManuallyProvidedKeyVerifier;
import org.jenkinsci.plugins.gitclient.verifier.SshHostKeyVerificationStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ManuallyProvidedKeyVerificationStrategy
extends SshHostKeyVerificationStrategy<ManuallyProvidedKeyVerifier> {
    private final String approvedHostKeys;

    @DataBoundConstructor
    public ManuallyProvidedKeyVerificationStrategy(String approvedHostKeys) {
        this.approvedHostKeys = approvedHostKeys.trim();
    }

    @Override
    public ManuallyProvidedKeyVerifier getVerifier() {
        return new ManuallyProvidedKeyVerifier(this.approvedHostKeys);
    }

    public String getApprovedHostKeys() {
        return this.approvedHostKeys;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ManuallyProvidedKeyVerificationStrategy that = (ManuallyProvidedKeyVerificationStrategy)((Object)o);
        return Objects.equals(this.approvedHostKeys, that.approvedHostKeys);
    }

    public int hashCode() {
        return Objects.hash(this.approvedHostKeys);
    }

    @Extension
    public static class ManuallyTrustedKeyVerificationStrategyDescriptor
    extends Descriptor<SshHostKeyVerificationStrategy<ManuallyProvidedKeyVerifier>> {
        @NonNull
        public String getDisplayName() {
            return "Manually provided keys";
        }

        public FormValidation doCheckApprovedHostKeys(@QueryParameter String approvedHostKeys) {
            return FormValidation.validateRequired((String)approvedHostKeys);
        }
    }
}

