/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.verifier;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ServerHostKeyVerifier;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public abstract class AbstractJGitHostKeyVerifier
implements ServerHostKeyVerifier,
SerializableOnlyOverRemoting {
    private static final Logger LOGGER = Logger.getLogger(AbstractJGitHostKeyVerifier.class.getName());
    protected final transient KnownHosts knownHosts;

    protected AbstractJGitHostKeyVerifier(KnownHosts knownHosts) {
        this.knownHosts = knownHosts;
    }

    public abstract String[] getServerHostKeyAlgorithms(Connection var1) throws IOException;

    String[] getPreferredServerHostkeyAlgorithmOrder(Connection connection) {
        String[] preferredServerHostkeyAlgorithmOrder = this.knownHosts.getPreferredServerHostkeyAlgorithmOrder(connection.getHostname());
        if (preferredServerHostkeyAlgorithmOrder == null) {
            return this.knownHosts.getPreferredServerHostkeyAlgorithmOrder(connection.getHostname() + ":" + connection.getPort());
        }
        return preferredServerHostkeyAlgorithmOrder;
    }

    boolean verifyServerHostKey(TaskListener taskListener, KnownHosts knownHosts, String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws IOException {
        boolean isValid;
        String hostPort = hostname + ":" + port;
        int resultHost = knownHosts.verifyHostkey(hostname, serverHostKeyAlgorithm, serverHostKey);
        int resultHostPort = knownHosts.verifyHostkey(hostPort, serverHostKeyAlgorithm, serverHostKey);
        boolean bl = isValid = 0 == resultHost || 0 == resultHostPort;
        if (!isValid) {
            LOGGER.log(Level.WARNING, "Host key {0} was not accepted.", hostPort);
            taskListener.getLogger().printf("Host key for host %s was not accepted.%n", hostPort);
        }
        return isValid;
    }

    KnownHosts getKnownHosts() {
        return this.knownHosts;
    }
}

