/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.jgit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import org.eclipse.jgit.transport.http.HttpConnection;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.jenkinsci.plugins.gitclient.jgit.PreemptiveAuthHttpClientConnection;
import org.jenkinsci.plugins.gitclient.trilead.SmartCredentialsProvider;

public class PreemptiveAuthHttpClientConnectionFactory
implements HttpConnectionFactory {
    private static final String NEED_CREDENTIALS_PROVIDER = "The " + PreemptiveAuthHttpClientConnectionFactory.class.getName() + " needs to be provided a credentials provider";
    private SmartCredentialsProvider credentialsProvider;

    public HttpConnection create(URL url) throws IOException {
        return this.innerCreate(url, null);
    }

    public HttpConnection create(URL url, Proxy proxy) throws IOException {
        return this.innerCreate(url, null);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Included in interface definition")
    public SmartCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Included in interface definition")
    public void setCredentialsProvider(SmartCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    protected HttpConnection innerCreate(URL url, Proxy proxy) {
        if (this.credentialsProvider == null) {
            throw new IllegalStateException(NEED_CREDENTIALS_PROVIDER);
        }
        return new PreemptiveAuthHttpClientConnection(this.credentialsProvider, url.toString(), proxy);
    }
}

