/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.InitCommand;
import org.jenkinsci.plugins.gitclient.LegacyCompatibleGitAPIImpl;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.Netrc;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.jenkinsci.plugins.gitclient.RevListCommand;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;
import org.kohsuke.stapler.framework.io.WriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CliGitAPIImpl
extends LegacyCompatibleGitAPIImpl {
    private static final boolean acceptSelfSignedCertificates = Boolean.getBoolean(GitClient.class.getName() + ".untrustedSSL");
    private static final long serialVersionUID = 1L;
    static final String SPARSE_CHECKOUT_FILE_DIR = ".git/info";
    static final String SPARSE_CHECKOUT_FILE_PATH = ".git/info/sparse-checkout";
    static final String TIMEOUT_LOG_PREFIX = " # timeout=";
    transient Launcher launcher;
    TaskListener listener;
    String gitExe;
    EnvVars environment;
    private Map<String, StandardCredentials> credentials = new HashMap<String, StandardCredentials>();
    private StandardCredentials defaultCredentials;
    private long gitVersion = 0L;
    public static final int TIMEOUT = Integer.getInteger(Git.class.getName() + ".timeOut", 10);

    private void warnIfWindowsTemporaryDirNameHasSpaces() {
        String[] varsToCheck;
        if (!Functions.isWindows()) {
            return;
        }
        for (String envVar : varsToCheck = new String[]{"TEMP", "TMP"}) {
            String value = this.environment.get(envVar, "C:\\Temp");
            if (!value.contains(" ")) continue;
            this.listener.getLogger().println("env " + envVar + "='" + value + "' contains an embedded space." + " Some msysgit versions may fail credential related operations.");
        }
    }

    private long computeVersionFromBits(int major, int minor, int rev, int bugfix) {
        return major * 1000000 + minor * 10000 + rev * 100 + bugfix;
    }

    private void getGitVersion() {
        if (this.gitVersion != 0L) {
            return;
        }
        String version = "";
        try {
            version = this.launchCommand("--version").trim();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.computeGitVersion(version);
    }

    void computeGitVersion(String version) {
        int gitMajorVersion = 0;
        int gitMinorVersion = 0;
        int gitRevVersion = 0;
        int gitBugfixVersion = 0;
        try {
            String[] fields = version.split(" ")[2].replaceAll("msysgit.", "").split("\\.");
            gitMajorVersion = Integer.parseInt(fields[0]);
            gitMinorVersion = fields.length > 1 ? Integer.parseInt(fields[1]) : 0;
            gitRevVersion = fields.length > 2 ? Integer.parseInt(fields[2]) : 0;
            gitBugfixVersion = fields.length > 3 ? Integer.parseInt(fields[3]) : 0;
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.gitVersion = this.computeVersionFromBits(gitMajorVersion, gitMinorVersion, gitRevVersion, gitBugfixVersion);
    }

    boolean isAtLeastVersion(int major, int minor, int rev, int bugfix) {
        this.getGitVersion();
        long requestedVersion = this.computeVersionFromBits(major, minor, rev, bugfix);
        return this.gitVersion >= requestedVersion;
    }

    protected CliGitAPIImpl(String gitExe, File workspace, TaskListener listener, EnvVars environment) {
        super(workspace);
        this.listener = listener;
        this.gitExe = gitExe;
        this.environment = environment;
        this.launcher = new Launcher.LocalLauncher(IGitAPI.verbose ? listener : TaskListener.NULL);
    }

    @Override
    public GitClient subGit(String subdir) {
        return new CliGitAPIImpl(this.gitExe, new File(this.workspace, subdir), this.listener, this.environment);
    }

    @Override
    public void init() throws GitException, InterruptedException {
        this.init_().workspace(this.workspace.getAbsolutePath()).execute();
    }

    @Override
    public boolean hasGitRepo() throws GitException, InterruptedException {
        if (this.hasGitRepo(".git")) {
            try {
                this.launchCommand("rev-parse", "--is-inside-work-tree");
            }
            catch (Exception ex) {
                ex.printStackTrace(this.listener.error("Workspace has a .git repository, but it appears to be corrupt."));
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean hasGitRepo(String GIT_DIR) throws GitException {
        try {
            File dotGit = new File(this.workspace, GIT_DIR);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException, InterruptedException {
        List<IndexEntry> submodules = this.lsTree(treeIsh, true);
        Iterator<IndexEntry> it = submodules.iterator();
        while (it.hasNext()) {
            if (it.next().getMode().equals("160000")) continue;
            it.remove();
        }
        return submodules;
    }

    @Override
    public FetchCommand fetch_() {
        return new FetchCommand(){
            public URIish url;
            public List<RefSpec> refspecs;
            public boolean prune;
            public boolean shallow;
            public Integer timeout;

            @Override
            public FetchCommand from(URIish remote, List<RefSpec> refspecs) {
                this.url = remote;
                this.refspecs = refspecs;
                return this;
            }

            @Override
            public FetchCommand prune() {
                this.prune = true;
                return this;
            }

            @Override
            public FetchCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            public FetchCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                StandardCredentials cred;
                CliGitAPIImpl.this.listener.getLogger().println("Fetching upstream changes from " + this.url);
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"fetch", "--tags"});
                if (CliGitAPIImpl.this.isAtLeastVersion(1, 7, 1, 0)) {
                    args.add("--progress");
                }
                if ((cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(this.url.toPrivateString())) == null) {
                    cred = CliGitAPIImpl.this.defaultCredentials;
                }
                args.add((Object)this.url);
                if (this.refspecs != null) {
                    for (RefSpec rs : this.refspecs) {
                        if (rs == null) continue;
                        args.add(rs.toString());
                    }
                }
                if (this.prune) {
                    args.add("--prune");
                }
                if (this.shallow) {
                    args.add("--depth=1");
                }
                CliGitAPIImpl.this.warnIfWindowsTemporaryDirNameHasSpaces();
                CliGitAPIImpl.this.launchCommandWithCredentials(args, CliGitAPIImpl.this.workspace, cred, this.url, this.timeout);
            }
        };
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.fetch_().from(url, refspecs).execute();
    }

    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException, InterruptedException {
        StandardCredentials cred;
        String url;
        this.listener.getLogger().println("Fetching upstream changes" + (remoteName != null ? " from " + remoteName : ""));
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"fetch", "-t"});
        if (remoteName == null) {
            remoteName = this.getDefaultRemote();
        }
        if ((url = this.getRemoteUrl(remoteName)) == null) {
            throw new GitException("remote." + remoteName + ".url not defined");
        }
        args.add(url);
        if (refspec != null && refspec.length > 0) {
            for (RefSpec rs : refspec) {
                if (rs == null) continue;
                args.add(rs.toString());
            }
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, url);
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException, InterruptedException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    @Override
    public void reset(boolean hard) throws GitException, InterruptedException {
        try {
            this.validateRevision("HEAD");
        }
        catch (GitException e) {
            this.listener.getLogger().println("No valid HEAD. Skipping the resetting");
            return;
        }
        this.listener.getLogger().println("Resetting working tree");
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add("reset");
        if (hard) {
            args.add("--hard");
        }
        this.launchCommand(args);
    }

    @Override
    public CloneCommand clone_() {
        return new CloneCommand(){
            String url;
            String origin = "origin";
            String reference;
            boolean shallow;
            boolean shared;
            Integer timeout;

            public CloneCommand url(String url) {
                this.url = url;
                return this;
            }

            public CloneCommand repositoryName(String name) {
                this.origin = name;
                return this;
            }

            public CloneCommand shared() {
                this.shared = true;
                return this;
            }

            public CloneCommand shallow() {
                this.shallow = true;
                return this;
            }

            public CloneCommand noCheckout() {
                return this;
            }

            public CloneCommand reference(String reference) {
                this.reference = reference;
                return this;
            }

            public CloneCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                URIish urIish = null;
                try {
                    urIish = new URIish(this.url);
                }
                catch (URISyntaxException e) {
                    CliGitAPIImpl.this.listener.getLogger().println("Invalid repository " + this.url);
                    throw new IllegalArgumentException("Invalid repository " + this.url, e);
                }
                CliGitAPIImpl.this.listener.getLogger().println("Cloning repository " + this.url);
                try {
                    Util.deleteContentsRecursive((File)CliGitAPIImpl.this.workspace);
                }
                catch (Exception e) {
                    e.printStackTrace(CliGitAPIImpl.this.listener.error("Failed to clean the workspace"));
                    throw new GitException("Failed to delete workspace", e);
                }
                CliGitAPIImpl.this.init_().workspace(CliGitAPIImpl.this.workspace.getAbsolutePath()).execute();
                if (this.reference != null && !this.reference.isEmpty()) {
                    File referencePath = new File(this.reference);
                    if (!referencePath.exists()) {
                        CliGitAPIImpl.this.listener.error("Reference path does not exist: " + this.reference);
                    } else if (!referencePath.isDirectory()) {
                        CliGitAPIImpl.this.listener.error("Reference path is not a directory: " + this.reference);
                    } else {
                        File objectsPath = new File(referencePath, ".git/objects");
                        if (!objectsPath.isDirectory()) {
                            objectsPath = new File(referencePath, "objects");
                        }
                        if (!objectsPath.isDirectory()) {
                            CliGitAPIImpl.this.listener.error("Reference path does not contain an objects directory (no git repo?): " + objectsPath);
                        } else {
                            try {
                                File alternates = new File(CliGitAPIImpl.this.workspace, ".git/objects/info/alternates");
                                PrintWriter w = new PrintWriter(alternates);
                                w.print(objectsPath.getAbsolutePath().replace('\\', '/'));
                                w.close();
                            }
                            catch (FileNotFoundException e) {
                                CliGitAPIImpl.this.listener.error("Failed to setup reference");
                            }
                        }
                    }
                }
                if (this.shared) {
                    throw new UnsupportedOperationException("shared is unsupported, and considered dangerous");
                }
                RefSpec refSpec = new RefSpec("+refs/heads/*:refs/remotes/" + this.origin + "/*");
                CliGitAPIImpl.this.fetch_().from(urIish, Collections.singletonList(refSpec)).shallow(this.shallow).timeout(this.timeout).execute();
                CliGitAPIImpl.this.setRemoteUrl(this.origin, this.url);
                CliGitAPIImpl.this.launchCommand("config", "remote." + this.origin + ".fetch", refSpec.toString());
            }
        };
    }

    @Override
    public MergeCommand merge() {
        return new MergeCommand(){
            public ObjectId rev;
            public String strategy;

            public MergeCommand setRevisionToMerge(ObjectId rev) {
                this.rev = rev;
                return this;
            }

            public MergeCommand setStrategy(MergeCommand.Strategy strategy) {
                this.strategy = strategy.toString();
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                try {
                    if (this.strategy != null && !this.strategy.isEmpty() && !this.strategy.equals(MergeCommand.Strategy.DEFAULT.toString())) {
                        CliGitAPIImpl.this.launchCommand("merge", "-s", this.strategy, this.rev.name());
                    } else {
                        CliGitAPIImpl.this.launchCommand("merge", this.rev.name());
                    }
                }
                catch (GitException e) {
                    throw new GitException("Could not merge " + this.rev, e);
                }
            }
        };
    }

    @Override
    public InitCommand init_() {
        return new InitCommand(){
            public String workspace;
            public boolean bare;

            public InitCommand workspace(String workspace) {
                this.workspace = workspace;
                return this;
            }

            public InitCommand bare(boolean bare) {
                this.bare = bare;
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"init", this.workspace});
                if (this.bare) {
                    args.add("--bare");
                }
                CliGitAPIImpl.this.warnIfWindowsTemporaryDirNameHasSpaces();
                try {
                    CliGitAPIImpl.this.launchCommand(args);
                }
                catch (GitException e) {
                    throw new GitException("Could not init " + this.workspace, e);
                }
            }
        };
    }

    @Override
    public void clean() throws GitException, InterruptedException {
        this.reset(true);
        this.launchCommand("clean", "-fdx");
    }

    @Override
    public ObjectId revParse(String revName) throws GitException, InterruptedException {
        String arg = this.sanitize(revName + "^{commit}");
        String result = this.launchCommand("rev-parse", arg);
        String line = this.firstLine(result);
        if (line == null) {
            throw new GitException("rev-parse no content returned for " + revName);
        }
        return ObjectId.fromString((String)line.trim());
    }

    private String sanitize(String arg) {
        if (Functions.isWindows()) {
            arg = '\"' + arg + '\"';
        }
        return arg;
    }

    public ObjectId validateRevision(String revName) throws GitException, InterruptedException {
        String result = this.launchCommand("rev-parse", "--verify", revName);
        String line = this.firstLine(result);
        if (line == null) {
            throw new GitException("null first line from rev-parse(" + revName + ")");
        }
        return ObjectId.fromString((String)line.trim());
    }

    @Override
    public String describe(String commitIsh) throws GitException, InterruptedException {
        String result = this.launchCommand("describe", "--tags", commitIsh);
        String line = this.firstLine(result);
        if (line == null) {
            throw new GitException("null first line from describe(" + commitIsh + ")");
        }
        return line.trim();
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException, InterruptedException {
        String repoName = repository.getName();
        String repoUrl = this.getRemoteUrl(repoName);
        if (repoUrl != null && !repoUrl.isEmpty()) {
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"remote", "prune", repoName});
            this.launchCommand(args);
        }
    }

    @CheckForNull
    private String firstLine(String result) {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(result));
        try {
            line = reader.readLine();
            if (line == null) {
                return null;
            }
            if (reader.readLine() != null) {
                throw new GitException("Result has multiple lines");
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing result", e);
        }
        return line;
    }

    @Override
    public ChangelogCommand changelog() {
        return new ChangelogCommand(){
            final List<String> revs = new ArrayList<String>();
            Integer n = null;
            Writer out = null;

            public ChangelogCommand excludes(String rev) {
                this.revs.add(CliGitAPIImpl.this.sanitize('^' + rev));
                return this;
            }

            public ChangelogCommand excludes(ObjectId rev) {
                return this.excludes(rev.name());
            }

            public ChangelogCommand includes(String rev) {
                this.revs.add(rev);
                return this;
            }

            public ChangelogCommand includes(ObjectId rev) {
                return this.includes(rev.name());
            }

            public ChangelogCommand to(Writer w) {
                this.out = w;
                return this;
            }

            public ChangelogCommand max(int n) {
                this.n = n;
                return this;
            }

            public void abort() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder(new String[]{CliGitAPIImpl.this.gitExe, "whatchanged", "--no-abbrev", "-M", "--pretty=raw"});
                if (this.n != null) {
                    args.add("-n").add((Object)this.n);
                }
                for (String rev : this.revs) {
                    args.add(rev);
                }
                if (this.out == null) {
                    throw new IllegalStateException();
                }
                try {
                    WriterOutputStream w = new WriterOutputStream(this.out);
                    try {
                        if (CliGitAPIImpl.this.launcher.launch().cmds(args).envs((Map)CliGitAPIImpl.this.environment).stdout((OutputStream)w).stderr((OutputStream)CliGitAPIImpl.this.listener.getLogger()).pwd(CliGitAPIImpl.this.workspace).join() != 0) {
                            throw new GitException("Error launching git whatchanged");
                        }
                    }
                    finally {
                        w.flush();
                    }
                }
                catch (IOException e) {
                    throw new GitException("Error launching git whatchanged", e);
                }
            }
        };
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"log", "--full-history", "--no-abbrev", "--format=raw", "-M", "-m", "--raw"});
        if (from != null) {
            args.add(from.name() + ".." + to.name());
        } else {
            args.add(new String[]{"-1", to.name()});
        }
        StringWriter writer = new StringWriter();
        writer.write(this.launchCommand(args));
        return new ArrayList<String>(Arrays.asList(writer.toString().split("\\n")));
    }

    @Override
    public void submoduleInit() throws GitException, InterruptedException {
        this.launchCommand("submodule", "init");
    }

    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException, InterruptedException {
        this.launchCommand("submodule", "add", remoteURL, subdir);
    }

    @Override
    public void submoduleSync() throws GitException, InterruptedException {
        this.launchCommand("submodule", "sync");
    }

    @Override
    public SubmoduleUpdateCommand submoduleUpdate() {
        return new SubmoduleUpdateCommand(){
            boolean recursive = false;
            boolean remoteTracking = false;
            String ref = null;
            HashMap<String, String> submodBranch = new HashMap();
            public Integer timeout;

            public SubmoduleUpdateCommand recursive(boolean recursive) {
                this.recursive = recursive;
                return this;
            }

            public SubmoduleUpdateCommand remoteTracking(boolean remoteTracking) {
                this.remoteTracking = remoteTracking;
                return this;
            }

            public SubmoduleUpdateCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            public SubmoduleUpdateCommand useBranch(String submodule, String branchname) {
                this.submodBranch.put(submodule, branchname);
                return this;
            }

            public SubmoduleUpdateCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"submodule", "update"});
                if (this.recursive) {
                    args.add(new String[]{"--init", "--recursive"});
                }
                if (this.remoteTracking && CliGitAPIImpl.this.isAtLeastVersion(1, 8, 2, 0)) {
                    args.add("--remote");
                    for (String key : this.submodBranch.keySet()) {
                        CliGitAPIImpl.this.launchCommand("config", "-f", ".gitmodules", "submodule." + key + ".branch", this.submodBranch.get(key));
                    }
                }
                if (this.ref != null && !this.ref.isEmpty()) {
                    File referencePath = new File(this.ref);
                    if (!referencePath.exists()) {
                        CliGitAPIImpl.this.listener.error("Reference path does not exist: " + this.ref);
                    } else if (!referencePath.isDirectory()) {
                        CliGitAPIImpl.this.listener.error("Reference path is not a directory: " + this.ref);
                    } else {
                        args.add(new String[]{"--reference", this.ref});
                    }
                }
                CliGitAPIImpl.this.launchCommandIn(args, CliGitAPIImpl.this.workspace, CliGitAPIImpl.this.environment, this.timeout);
            }
        };
    }

    public void submoduleReset(boolean recursive, boolean hard) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git reset" + (hard ? " --hard" : ""));
        this.launchCommand(args);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException, InterruptedException {
        this.submoduleReset(true, true);
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(new String[]{"submodule", "foreach"});
        if (recursive) {
            args.add("--recursive");
        }
        args.add("git clean -fdx");
        this.launchCommand(args);
    }

    @Override
    @CheckForNull
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "--get", "submodule." + name + ".url");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    public void setSubmoduleUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "submodule." + name + ".url", url);
    }

    @Override
    @CheckForNull
    public String getRemoteUrl(String name) throws GitException, InterruptedException {
        String result = this.launchCommand("config", "--get", "remote." + name + ".url");
        return StringUtils.trim((String)this.firstLine(result));
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "remote." + name + ".url", url);
    }

    @Override
    public void addRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.launchCommand("config", "--add", "remote." + name + ".url", url);
    }

    @Override
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        String result;
        String remoteNameUrl = "remote." + name + ".url";
        if (StringUtils.isBlank((String)GIT_DIR)) {
            result = this.launchCommand("config", "--get", remoteNameUrl);
        } else {
            String dirArg = "--git-dir=" + GIT_DIR;
            result = this.launchCommand(dirArg, "config", "--get", remoteNameUrl);
        }
        String line = this.firstLine(result);
        if (line == null) {
            throw new GitException("No output from bare repository check for " + GIT_DIR);
        }
        return line.trim();
    }

    @Override
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        this.launchCommand("--git-dir=" + GIT_DIR, "config", "remote." + name + ".url", url);
    }

    @Override
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        BufferedReader rdr = new BufferedReader(new StringReader(this.launchCommand("remote")));
        ArrayList<String> remotes = new ArrayList<String>();
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                remotes.add(line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing remotes", e);
        }
        if (remotes.contains(_default_)) {
            return _default_;
        }
        if (remotes.size() >= 1) {
            return (String)remotes.get(0);
        }
        throw new GitException("No remotes found!");
    }

    public String getDefaultRemote() throws GitException, InterruptedException {
        return this.getDefaultRemote("origin");
    }

    @Override
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        String ret;
        if ("".equals(GIT_DIR)) {
            ret = this.launchCommand("rev-parse", "--is-bare-repository");
        } else {
            String gitDir = "--git-dir=" + GIT_DIR;
            ret = this.launchCommand(gitDir, "rev-parse", "--is-bare-repository");
        }
        String line = this.firstLine(ret);
        if (line == null) {
            throw new GitException("No output from bare repository check for " + GIT_DIR);
        }
        return !"false".equals(line.trim());
    }

    private String pathJoin(String a, String b) {
        return new File(a, b).toString();
    }

    @Override
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        URI origin;
        boolean is_bare = true;
        try {
            String url = this.getRemoteUrl(remote);
            if (url == null) {
                throw new GitException("remote." + remote + ".url not defined in workspace");
            }
            String gitEnd = this.pathJoin("", ".git");
            if (url.endsWith(gitEnd)) {
                url = url.substring(0, url.length() - gitEnd.length());
                is_bare = false;
            }
            origin = new URI(url);
        }
        catch (URISyntaxException e) {
            return;
        }
        catch (Exception e) {
            throw new GitException("Could not determine remote." + remote + ".url", e);
        }
        if (origin.getScheme() == null || "file".equalsIgnoreCase(origin.getScheme()) && (origin.getHost() == null || "".equals(origin.getHost()))) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(origin.getPath());
            paths.add(this.pathJoin(origin.getPath(), ".git"));
            for (String path : paths) {
                try {
                    is_bare = this.isBareRepository(path);
                    break;
                }
                catch (GitException e) {
                }
            }
        }
        if (!is_bare) {
            try {
                List<IndexEntry> submodules = this.getSubmodules("HEAD");
                for (IndexEntry submodule : submodules) {
                    String sUrl = this.pathJoin(origin.getPath(), submodule.getFile());
                    this.setSubmoduleUrl(submodule.getFile(), sUrl);
                    String subGitDir = this.pathJoin(submodule.getFile(), ".git");
                    if (!this.hasGitRepo(subGitDir) || "".equals(this.getRemoteUrl("origin", subGitDir))) continue;
                    this.setRemoteUrl("origin", sUrl, subGitDir);
                }
            }
            catch (GitException e) {
                // empty catch block
            }
        }
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException, InterruptedException {
        String remote = null;
        for (Branch br : rev.getBranches()) {
            int slash;
            String b = br.getName();
            if (b != null && (slash = b.indexOf(47)) != -1) {
                remote = this.getDefaultRemote(b.substring(0, slash));
            }
            if (remote == null) continue;
            break;
        }
        if (remote == null) {
            remote = this.getDefaultRemote();
        }
        if (remote != null) {
            this.setupSubmoduleUrls(remote, listener);
        }
    }

    @Override
    public void tag(String tagName, String comment) throws GitException, InterruptedException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-a", "-f", "-m", comment, tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not apply tag " + tagName, e);
        }
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException, InterruptedException {
        this.createNote(note, namespace, "append");
    }

    @Override
    public void addNote(String note, String namespace) throws GitException, InterruptedException {
        this.createNote(note, namespace, "add");
    }

    private void deleteTempFile(File tempFile) {
        if (tempFile != null && !tempFile.delete() && tempFile.exists()) {
            this.listener.getLogger().println("[WARNING] temp file " + tempFile + " not deleted");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createNote(String note, String namespace, String command) throws GitException, InterruptedException {
        File msg = null;
        try {
            msg = File.createTempFile("git-note", "txt", this.workspace);
            FileUtils.writeStringToFile((File)msg, (String)note);
            this.launchCommand("notes", "--ref=" + namespace, command, "-F", msg.getAbsolutePath());
        }
        catch (IOException e) {
            try {
                throw new GitException("Could not apply note " + note, e);
                catch (GitException e2) {
                    throw new GitException("Could not apply note " + note, e2);
                }
            }
            catch (Throwable throwable) {
                this.deleteTempFile(msg);
                throw throwable;
            }
        }
        this.deleteTempFile(msg);
    }

    public String launchCommand(ArgumentListBuilder args) throws GitException, InterruptedException {
        return this.launchCommandIn(args, this.workspace);
    }

    public String launchCommand(String ... args) throws GitException, InterruptedException {
        return this.launchCommand(new ArgumentListBuilder(args));
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull String url) throws GitException, InterruptedException {
        try {
            return this.launchCommandWithCredentials(args, workDir, credentials, new URIish(url));
        }
        catch (URISyntaxException e) {
            throw new GitException("Invalid URL " + url);
        }
    }

    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull URIish url) throws GitException, InterruptedException {
        return this.launchCommandWithCredentials(args, workDir, credentials, url, TIMEOUT);
    }

    /*
     * Loose catch block
     */
    private String launchCommandWithCredentials(ArgumentListBuilder args, File workDir, StandardCredentials credentials, @NonNull URIish url, Integer timeout) throws GitException, InterruptedException {
        String shouldProxy22;
        boolean deleteWorkDir;
        File store;
        File pass;
        File ssh;
        File key;
        block26: {
            key = null;
            ssh = null;
            pass = null;
            store = null;
            EnvVars env = this.environment;
            deleteWorkDir = false;
            if (credentials != null && credentials instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey sshUser = (SSHUserPrivateKey)credentials;
                this.listener.getLogger().println("using GIT_SSH to set credentials " + sshUser.getDescription());
                key = this.createSshKeyFile(key, sshUser);
                if (this.launcher.isUnix()) {
                    ssh = this.createUnixGitSSH(key);
                    pass = this.createUnixSshAskpass(sshUser);
                } else {
                    ssh = this.createWindowsGitSSH(key);
                    pass = this.createWindowsSshAskpass(sshUser);
                }
                env = new EnvVars(env);
                env.put("GIT_SSH", ssh.getAbsolutePath());
                env.put("SSH_ASKPASS", pass.getAbsolutePath());
            }
            if ("http".equalsIgnoreCase(url.getScheme()) || "https".equalsIgnoreCase(url.getScheme())) {
                this.checkCredentials(url, credentials);
                if (credentials != null) {
                    this.listener.getLogger().println("using .gitcredentials to set credentials");
                    if (!this.isAtLeastVersion(1, 7, 9, 0)) {
                        this.listener.getLogger().println("[WARNING] Installed git version too old for credentials support");
                    }
                    String urlWithCredentials = this.getGitCredentialsURL(url, credentials);
                    store = this.createGitCredentialsStore(urlWithCredentials);
                    if (workDir == null) {
                        workDir = Util.createTempDir();
                        deleteWorkDir = true;
                        this.init_().workspace(workDir.getAbsolutePath()).execute();
                    }
                    String fileStore = this.launcher.isUnix() ? store.getAbsolutePath() : "\\\"" + store.getAbsolutePath() + "\\\"";
                    this.launchCommandIn(workDir, "config", "--local", "credential.helper", "store --file=" + fileStore);
                }
                if (this.proxy != null) {
                    boolean shouldProxy22 = true;
                    for (Pattern p : this.proxy.getNoProxyHostPatterns()) {
                        if (!p.matcher(url.getHost()).matches()) continue;
                        shouldProxy22 = false;
                        break;
                    }
                    if (shouldProxy22) {
                        env = new EnvVars(env);
                        this.listener.getLogger().println("Setting http proxy: " + this.proxy.name + ":" + this.proxy.port);
                        String userInfo = null;
                        if (this.proxy.getUserName() != null) {
                            userInfo = this.proxy.getUserName();
                            if (this.proxy.getPassword() != null) {
                                userInfo = userInfo + ":" + this.proxy.getPassword();
                            }
                        }
                        try {
                            URI http_proxy = new URI("http", userInfo, this.proxy.name, this.proxy.port, null, null, null);
                            env.put("http_proxy", http_proxy.toString());
                            env.put("https_proxy", http_proxy.toString());
                        }
                        catch (URISyntaxException ex) {
                            throw new GitException("Failed to create http proxy uri", ex);
                        }
                    }
                }
            }
            shouldProxy22 = this.launchCommandIn(args, workDir, env, timeout);
            Object var16_19 = null;
            this.deleteTempFile(pass);
            this.deleteTempFile(key);
            this.deleteTempFile(ssh);
            this.deleteTempFile(store);
            if (store == null) break block26;
            try {
                this.launchCommandIn(workDir, "config", "--local", "--remove-section", "credential");
            }
            catch (GitException e2) {
                this.listener.getLogger().println("Could not remove the credential section from the git configuration");
            }
            if (deleteWorkDir) {
                try {
                    Util.deleteContentsRecursive((File)workDir);
                    FileUtils.deleteDirectory((File)workDir);
                }
                catch (IOException ioe) {
                    this.listener.getLogger().println("Couldn't delete dir " + workDir.getAbsolutePath() + " : " + ioe);
                }
            }
        }
        return shouldProxy22;
        catch (IOException e) {
            try {
                throw new GitException("Failed to setup credentials", e);
            }
            catch (Throwable throwable) {
                block28: {
                    Object var16_20 = null;
                    this.deleteTempFile(pass);
                    this.deleteTempFile(key);
                    this.deleteTempFile(ssh);
                    this.deleteTempFile(store);
                    if (store == null) break block28;
                    try {
                        this.launchCommandIn(workDir, "config", "--local", "--remove-section", "credential");
                    }
                    catch (GitException e2) {
                        this.listener.getLogger().println("Could not remove the credential section from the git configuration");
                    }
                    if (deleteWorkDir) {
                        try {
                            Util.deleteContentsRecursive((File)workDir);
                            FileUtils.deleteDirectory((File)workDir);
                        }
                        catch (IOException ioe) {
                            this.listener.getLogger().println("Couldn't delete dir " + workDir.getAbsolutePath() + " : " + ioe);
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    private File createGitCredentialsStore(String urlWithCredentials) throws IOException {
        File store = File.createTempFile("git", ".credentials");
        PrintWriter w = new PrintWriter(store);
        w.print(urlWithCredentials);
        w.flush();
        w.close();
        return store;
    }

    private File createSshKeyFile(File key, SSHUserPrivateKey sshUser) throws IOException, InterruptedException {
        key = File.createTempFile("ssh", "key");
        PrintWriter w = new PrintWriter(key);
        List privateKeys = sshUser.getPrivateKeys();
        for (String s : privateKeys) {
            w.println(s);
        }
        w.close();
        new FilePath(key).chmod(256);
        return key;
    }

    private File createWindowsSshAskpass(SSHUserPrivateKey sshUser) throws IOException {
        File ssh = File.createTempFile("pass", ".bat");
        PrintWriter w = new PrintWriter(ssh);
        w.println("echo \"" + Secret.toString((Secret)sshUser.getPassphrase()) + "\"");
        w.flush();
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private File createUnixSshAskpass(SSHUserPrivateKey sshUser) throws IOException {
        File ssh = File.createTempFile("pass", ".sh");
        PrintWriter w = new PrintWriter(ssh);
        w.println("#!/bin/sh");
        w.println("/bin/echo \"" + Secret.toString((Secret)sshUser.getPassphrase()) + "\"");
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private String getPathToExe(String userGitExe) {
        String[] pathDirs;
        String exe;
        String cmd;
        if ((userGitExe = userGitExe.toLowerCase()).endsWith(".exe")) {
            cmd = userGitExe.replace(".exe", ".cmd");
            exe = userGitExe;
        } else if (userGitExe.endsWith(".cmd")) {
            cmd = userGitExe;
            exe = userGitExe.replace(".cmd", ".exe");
        } else {
            cmd = userGitExe + ".cmd";
            exe = userGitExe + ".exe";
        }
        for (String pathDir : pathDirs = System.getenv("PATH").split(File.pathSeparator)) {
            File exeFile = new File(pathDir, exe);
            if (exeFile.exists()) {
                return exeFile.getAbsolutePath();
            }
            File cmdFile = new File(pathDir, cmd);
            if (!cmdFile.exists()) continue;
            return cmdFile.getAbsolutePath();
        }
        return null;
    }

    private File getFileFromEnv(String envVar, String suffix) {
        String envValue = System.getenv(envVar);
        if (envValue == null) {
            return null;
        }
        return new File(envValue + suffix);
    }

    private File getSSHExeFromGitExeParentDir(String userGitExe) {
        String parentPath = new File(userGitExe).getParent();
        if (parentPath == null) {
            return null;
        }
        return new File(parentPath + "\\ssh.exe");
    }

    File getSSHExecutable() {
        File sshexe = this.getFileFromEnv("GIT_SSH", "");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getFileFromEnv("ProgramFiles", "\\Git\\bin\\ssh.exe");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getFileFromEnv("ProgramFiles(x86)", "\\Git\\bin\\ssh.exe");
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        sshexe = this.getSSHExeFromGitExeParentDir(this.gitExe);
        if (sshexe != null && sshexe.exists()) {
            return sshexe;
        }
        String gitPath = this.getPathToExe(this.gitExe);
        if (gitPath != null && (sshexe = this.getSSHExeFromGitExeParentDir(gitPath.replace("/cmd/", "/bin/").replace("\\cmd\\", "\\bin\\"))) != null && sshexe.exists()) {
            return sshexe;
        }
        throw new RuntimeException("ssh executable not found. The git plugin only supports official git client http://git-scm.com/download/win");
    }

    private File createWindowsGitSSH(File key) throws IOException {
        File ssh = File.createTempFile("ssh", ".bat");
        File sshexe = this.getSSHExecutable();
        PrintWriter w = new PrintWriter(ssh);
        w.println("@echo off");
        w.println("\"" + sshexe.getAbsolutePath() + "\" -i \"" + key.getAbsolutePath() + "\" -o StrictHostKeyChecking=no %* ");
        w.flush();
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private File createUnixGitSSH(File key) throws IOException {
        File ssh = File.createTempFile("ssh", ".sh");
        PrintWriter w = new PrintWriter(ssh);
        w.println("#!/bin/sh");
        w.println("ssh -i \"" + key.getAbsolutePath() + "\" -o StrictHostKeyChecking=no \"$@\"");
        w.close();
        ssh.setExecutable(true);
        return ssh;
    }

    private String launchCommandIn(File workDir, String ... args) throws GitException, InterruptedException {
        return this.launchCommandIn(new ArgumentListBuilder(args), workDir);
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir) throws GitException, InterruptedException {
        return this.launchCommandIn(args, workDir, this.environment);
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir, EnvVars env) throws GitException, InterruptedException {
        return this.launchCommandIn(args, workDir, this.environment, TIMEOUT);
    }

    private String launchCommandIn(ArgumentListBuilder args, File workDir, EnvVars env, Integer timeout) throws GitException, InterruptedException {
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        EnvVars environment = new EnvVars(env);
        if (!env.containsKey((Object)"SSH_ASKPASS")) {
            environment.put("GIT_ASKPASS", this.launcher.isUnix() ? "/bin/echo" : "echo ");
        }
        String command = this.gitExe + " " + StringUtils.join((Object[])args.toCommandArray(), (String)" ");
        try {
            args.prepend(new String[]{this.gitExe});
            this.listener.getLogger().println(" > " + command + (timeout != null ? TIMEOUT_LOG_PREFIX + timeout : ""));
            Launcher.ProcStarter p = this.launcher.launch().cmds(args.toCommandArray()).envs((Map)environment).stdout((OutputStream)fos).stderr((OutputStream)err);
            if (workDir != null) {
                p.pwd(workDir);
            }
            int status = p.start().joinWithTimeout(timeout != null ? (long)timeout.intValue() : (long)TIMEOUT, TimeUnit.MINUTES, this.listener);
            String result = fos.toString();
            if (status != 0) {
                throw new GitException("Command \"" + command + "\" returned status code " + status + ":\nstdout: " + result + "\nstderr: " + err.toString());
            }
            return result;
        }
        catch (GitException e) {
            throw e;
        }
        catch (IOException e) {
            throw new GitException("Error performing command: " + command, e);
        }
        catch (Throwable t) {
            throw new GitException("Error performing git command", t);
        }
    }

    @Override
    public PushCommand push() {
        return new PushCommand(){
            public URIish remote;
            public String refspec;
            public boolean force;
            public Integer timeout;

            public PushCommand to(URIish remote) {
                this.remote = remote;
                return this;
            }

            public PushCommand ref(String refspec) {
                this.refspec = refspec;
                return this;
            }

            public PushCommand force() {
                this.force = true;
                return this;
            }

            public PushCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            public void execute() throws GitException, InterruptedException {
                StandardCredentials cred;
                ArgumentListBuilder args = new ArgumentListBuilder();
                args.add(new String[]{"push", this.remote.toPrivateASCIIString()});
                if (this.refspec != null) {
                    args.add(this.refspec);
                }
                if (this.force) {
                    args.add("-f");
                }
                if ((cred = (StandardCredentials)CliGitAPIImpl.this.credentials.get(this.remote.toPrivateString())) == null) {
                    cred = CliGitAPIImpl.this.defaultCredentials;
                }
                CliGitAPIImpl.this.launchCommandWithCredentials(args, CliGitAPIImpl.this.workspace, cred, this.remote, this.timeout);
            }
        };
    }

    protected Set<Branch> parseBranches(String fos) throws GitException, InterruptedException {
        HashSet<Branch> branches = new HashSet<Branch>();
        BufferedReader rdr = new BufferedReader(new StringReader(fos));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                if ((line = line.substring(2)).startsWith("(") || line.indexOf(" -> ") != -1) continue;
                branches.add(new Branch(line, this.revParse(line)));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing branches", e);
        }
        return branches;
    }

    @Override
    public Set<Branch> getBranches() throws GitException, InterruptedException {
        return this.parseBranches(this.launchCommand("branch", "-a"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Branch> getRemoteBranches() throws GitException, InterruptedException {
        HashSet<Branch> hashSet;
        Repository db = this.getRepository();
        try {
            Map refs = db.getAllRefs();
            HashSet<Branch> branches = new HashSet<Branch>();
            for (Ref candidate : refs.values()) {
                if (!candidate.getName().startsWith("refs/remotes/")) continue;
                Branch buildBranch = new Branch(candidate);
                if (!GitClient.quietRemoteBranches) {
                    this.listener.getLogger().println("Seen branch in repository " + buildBranch.getName());
                }
                branches.add(buildBranch);
            }
            if (branches.size() == 1) {
                this.listener.getLogger().println("Seen 1 remote branch");
            } else {
                this.listener.getLogger().println(MessageFormat.format("Seen {0} remote branches", branches.size()));
            }
            hashSet = branches;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            db.close();
            throw throwable;
        }
        db.close();
        return hashSet;
    }

    @Override
    public CheckoutCommand checkout() {
        return new CheckoutCommand(){
            public String ref;
            public String branch;
            public boolean deleteBranch;
            public List<String> sparseCheckoutPaths = Collections.emptyList();
            public Integer timeout;

            @Override
            public CheckoutCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public CheckoutCommand branch(String branch) {
                this.branch = branch;
                return this;
            }

            @Override
            public CheckoutCommand deleteBranchIfExist(boolean deleteBranch) {
                this.deleteBranch = deleteBranch;
                return this;
            }

            @Override
            public CheckoutCommand sparseCheckoutPaths(List<String> sparseCheckoutPaths) {
                this.sparseCheckoutPaths = sparseCheckoutPaths == null ? Collections.emptyList() : sparseCheckoutPaths;
                return this;
            }

            @Override
            public CheckoutCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                try {
                    this.sparseCheckout(this.sparseCheckoutPaths);
                    if (this.branch != null && this.deleteBranch) {
                        CliGitAPIImpl.this.launchCommand("checkout", "-f", this.ref);
                        for (Branch b : CliGitAPIImpl.this.getBranches()) {
                            if (!b.getName().equals(this.branch)) continue;
                            CliGitAPIImpl.this.deleteBranch(this.branch);
                        }
                    }
                    ArgumentListBuilder args = new ArgumentListBuilder();
                    args.add("checkout");
                    if (this.branch != null) {
                        args.add("-b");
                        args.add(this.branch);
                    } else {
                        args.add("-f");
                    }
                    args.add(this.ref);
                    CliGitAPIImpl.this.launchCommandIn(args, CliGitAPIImpl.this.workspace, CliGitAPIImpl.this.environment, this.timeout);
                }
                catch (GitException e) {
                    if (Pattern.compile("index\\.lock").matcher(e.getMessage()).find()) {
                        throw new GitLockFailedException("Could not lock repository. Please try again", e);
                    }
                    throw new GitException("Could not checkout " + this.branch + " with start point " + this.ref, e);
                }
            }

            private void sparseCheckout(@NonNull List<String> paths) throws GitException, InterruptedException {
                PrintWriter writer;
                boolean coreSparseCheckoutConfigEnable;
                try {
                    coreSparseCheckoutConfigEnable = CliGitAPIImpl.this.launchCommand("config", "core.sparsecheckout").contains("true");
                }
                catch (GitException ge) {
                    coreSparseCheckoutConfigEnable = false;
                }
                boolean deactivatingSparseCheckout = false;
                if (paths.isEmpty() && !coreSparseCheckoutConfigEnable) {
                    return;
                }
                if (paths.isEmpty() && coreSparseCheckoutConfigEnable) {
                    deactivatingSparseCheckout = true;
                    paths = Lists.newArrayList((Object[])new String[]{"/*"});
                } else if (!coreSparseCheckoutConfigEnable) {
                    CliGitAPIImpl.this.launchCommand("config", "core.sparsecheckout", "true");
                }
                File sparseCheckoutDir = new File(CliGitAPIImpl.this.workspace, CliGitAPIImpl.SPARSE_CHECKOUT_FILE_DIR);
                if (!sparseCheckoutDir.exists() && !sparseCheckoutDir.mkdir()) {
                    throw new GitException("Impossible to create sparse checkout dir " + sparseCheckoutDir.getAbsolutePath());
                }
                File sparseCheckoutFile = new File(CliGitAPIImpl.this.workspace, CliGitAPIImpl.SPARSE_CHECKOUT_FILE_PATH);
                try {
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(sparseCheckoutFile, false), "UTF-8"));
                }
                catch (IOException ex) {
                    throw new GitException("Impossible to open sparse checkout file " + sparseCheckoutFile.getAbsolutePath());
                }
                for (String path : paths) {
                    writer.println(path);
                }
                try {
                    writer.close();
                }
                catch (Exception ex) {
                    throw new GitException("Impossible to close sparse checkout file " + sparseCheckoutFile.getAbsolutePath());
                }
                try {
                    CliGitAPIImpl.this.launchCommand("read-tree", "-mu", "HEAD");
                }
                catch (GitException ge) {
                    String normalReturnCode = "128";
                    if (ge.getMessage().contains(normalReturnCode)) {
                        CliGitAPIImpl.this.listener.getLogger().println(ge.getMessage());
                    }
                    throw ge;
                }
                if (deactivatingSparseCheckout) {
                    CliGitAPIImpl.this.launchCommand("config", "core.sparsecheckout", "false");
                }
            }
        };
    }

    @Override
    public boolean tagExists(String tagName) throws GitException, InterruptedException {
        return this.launchCommand("tag", "-l", tagName).trim().equals(tagName);
    }

    @Override
    public void deleteBranch(String name) throws GitException, InterruptedException {
        try {
            this.launchCommand("branch", "-D", name);
        }
        catch (GitException e) {
            throw new GitException("Could not delete branch " + name, e);
        }
    }

    @Override
    public void deleteTag(String tagName) throws GitException, InterruptedException {
        tagName = tagName.replace(' ', '_');
        try {
            this.launchCommand("tag", "-d", tagName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete tag " + tagName, e);
        }
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
        String result = this.launchCommand("ls-tree", recursive ? "-r" : null, treeIsh);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String[] entry = line.split("\\s+");
                entries.add(new IndexEntry(entry[0], entry[1], entry[2], entry[3]));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing ls tree", e);
        }
        return entries;
    }

    @Override
    public RevListCommand revList_() {
        return new RevListCommand(){
            public boolean all;
            public boolean firstParent;
            public String refspec;
            public List<ObjectId> out;

            @Override
            public RevListCommand all() {
                this.all = true;
                return this;
            }

            @Override
            public RevListCommand firstParent() {
                this.firstParent = true;
                return this;
            }

            @Override
            public RevListCommand to(List<ObjectId> revs) {
                this.out = revs;
                return this;
            }

            @Override
            public RevListCommand reference(String reference) {
                this.refspec = reference;
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
                if (this.firstParent) {
                    args.add("--first-parent");
                }
                if (this.all) {
                    args.add("--all");
                }
                if (this.refspec != null) {
                    args.add(this.refspec);
                }
                String result = CliGitAPIImpl.this.launchCommand(args);
                BufferedReader rdr = new BufferedReader(new StringReader(result));
                try {
                    String line;
                    while ((line = rdr.readLine()) != null) {
                        this.out.add(ObjectId.fromString((String)line));
                    }
                }
                catch (IOException e) {
                    throw new GitException("Error parsing rev list", e);
                }
            }
        };
    }

    @Override
    public List<ObjectId> revListAll() throws GitException, InterruptedException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.all();
        revListCommand.to(oidList);
        revListCommand.execute();
        return oidList;
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException, InterruptedException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.reference(ref);
        revListCommand.to(oidList);
        revListCommand.execute();
        return oidList;
    }

    private List<ObjectId> doRevList(String ... extraArgs) throws GitException, InterruptedException {
        ArrayList<ObjectId> entries = new ArrayList<ObjectId>();
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"rev-list"});
        args.add(extraArgs);
        String result = this.launchCommand(args);
        BufferedReader rdr = new BufferedReader(new StringReader(result));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                entries.add(ObjectId.fromString((String)line));
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing rev list", e);
        }
        return entries;
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws InterruptedException {
        try {
            List<ObjectId> revs = this.revList(commit.name());
            return revs.size() != 0;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void add(String filePattern) throws GitException, InterruptedException {
        try {
            this.launchCommand("add", filePattern);
        }
        catch (GitException e) {
            throw new GitException("Cannot add " + filePattern, e);
        }
    }

    @Override
    public void branch(String name) throws GitException, InterruptedException {
        try {
            this.launchCommand("branch", name);
        }
        catch (GitException e) {
            throw new GitException("Cannot create branch " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit(String message) throws GitException, InterruptedException {
        File f = null;
        try {
            try {
                block8: {
                    f = File.createTempFile("gitcommit", ".txt");
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(f);
                        fos.write(message.getBytes());
                        Object var5_7 = null;
                        if (fos == null) break block8;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                }
                this.launchCommand("commit", "-F", f.getAbsolutePath());
            }
            catch (GitException e) {
                throw new GitException("Cannot commit " + message, e);
            }
            catch (FileNotFoundException e) {
                throw new GitException("Cannot commit " + message, e);
            }
            catch (IOException e) {
                throw new GitException("Cannot commit " + message, e);
            }
            Object var7_10 = null;
            this.deleteTempFile(f);
            return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.deleteTempFile(f);
            throw throwable;
        }
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.credentials.put(url, credentials);
    }

    @Override
    public void clearCredentials() {
        this.credentials.clear();
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.defaultCredentials = credentials;
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.env("GIT_AUTHOR_NAME", name);
        this.env("GIT_AUTHOR_EMAIL", email);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.env("GIT_COMMITTER_NAME", name);
        this.env("GIT_COMMITTER_EMAIL", email);
    }

    private void env(String name, String value) {
        if (value == null) {
            this.environment.remove((Object)name);
        } else {
            this.environment.put(name, value);
        }
    }

    @Override
    @NonNull
    public Repository getRepository() throws GitException {
        try {
            return FileRepositoryBuilder.create((File)new File(this.workspace, ".git"));
        }
        catch (IOException e) {
            throw new GitException("Failed to open Git repository " + this.workspace, e);
        }
    }

    @Override
    public FilePath getWorkTree() {
        return new FilePath(this.workspace);
    }

    @Override
    public Set<String> getRemoteTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"ls-remote", "--tags"});
            args.add(this.getRemoteUrl("origin"));
            if (tagPattern != null) {
                args.add(tagPattern);
            }
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag.replaceFirst(".*refs/tags/", ""));
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving remote tag names", e);
        }
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        try {
            String tag;
            ArgumentListBuilder args = new ArgumentListBuilder();
            args.add(new String[]{"tag", "-l", tagPattern});
            String result = this.launchCommandIn(args, this.workspace);
            HashSet<String> tags = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((tag = rdr.readLine()) != null) {
                tags.add(tag);
            }
            return tags;
        }
        catch (Exception e) {
            throw new GitException("Error retrieving tag names", e);
        }
    }

    @Override
    public String getTagMessage(String tagName) throws GitException, InterruptedException {
        String out = this.launchCommand("tag", "-l", tagName, "-n10000");
        return out.substring(tagName.length()).replaceAll("(?m)(^    )", "").trim();
    }

    @Override
    public void ref(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try {
            this.launchCommand("update-ref", refName, "HEAD");
        }
        catch (GitException e) {
            throw new GitException("Could not apply ref " + refName, e);
        }
    }

    @Override
    public boolean refExists(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try {
            this.launchCommand("show-ref", refName);
            return true;
        }
        catch (GitException e) {
            return false;
        }
    }

    @Override
    public void deleteRef(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try {
            this.launchCommand("update-ref", "-d", refName);
        }
        catch (GitException e) {
            throw new GitException("Could not delete ref " + refName, e);
        }
    }

    @Override
    public Set<String> getRefNames(String refPrefix) throws GitException, InterruptedException {
        refPrefix = refPrefix.isEmpty() ? "refs/" : refPrefix.replace(' ', '_');
        try {
            String ref;
            String result = this.launchCommand("for-each-ref", "--format=%(refname)", refPrefix);
            HashSet<String> refs = new HashSet<String>();
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            while ((ref = rdr.readLine()) != null) {
                refs.add(ref);
            }
            return refs;
        }
        catch (GitException e) {
            throw new GitException("Error retrieving refs with prefix " + refPrefix, e);
        }
        catch (IOException e) {
            throw new GitException("Error retrieving refs with prefix " + refPrefix, e);
        }
    }

    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        String[] lines;
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        args.add("-h");
        args.add(url);
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        HashMap<String, ObjectId> heads = new HashMap<String, ObjectId>();
        for (String line : lines = result.split("\n")) {
            if (line.length() < 41) {
                throw new GitException("unexpected ls-remote output " + line);
            }
            heads.put(line.substring(41), ObjectId.fromString((String)line.substring(0, 40)));
        }
        return heads;
    }

    @Override
    public ObjectId getHeadRev(String url, String branchSpec) throws GitException, InterruptedException {
        StandardCredentials cred;
        String branchName = this.extractBranchNameFromBranchSpec(branchSpec);
        ArgumentListBuilder args = new ArgumentListBuilder(new String[]{"ls-remote"});
        if (!branchName.startsWith("refs/tags/")) {
            args.add("-h");
        }
        if ((cred = this.credentials.get(url)) == null) {
            cred = this.defaultCredentials;
        }
        args.add(url);
        if (branchName.startsWith("refs/tags/")) {
            args.add(branchName + "^{}");
        } else {
            args.add(branchName);
        }
        String result = this.launchCommandWithCredentials(args, null, cred, url);
        return result.length() >= 40 ? ObjectId.fromString((String)result.substring(0, 40)) : null;
    }

    @Override
    @Deprecated
    public void merge(String refSpec) throws GitException, InterruptedException {
        try {
            this.launchCommand("merge", refSpec);
        }
        catch (GitException e) {
            throw new GitException("Could not merge " + refSpec, e);
        }
    }

    @Override
    @Deprecated
    public void push(RemoteConfig repository, String refspec) throws GitException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        URIish uri = (URIish)repository.getURIs().get(0);
        String url = uri.toPrivateString();
        StandardCredentials cred = this.credentials.get(url);
        if (cred == null) {
            cred = this.defaultCredentials;
        }
        args.add(new String[]{"push", url});
        if (refspec != null) {
            args.add(refspec);
        }
        this.launchCommandWithCredentials(args, this.workspace, cred, uri);
    }

    @Override
    @Deprecated
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        return new ArrayList<Branch>(this.parseBranches(this.launchCommand("branch", "-a", "--contains", revspec)));
    }

    @Override
    @Deprecated
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) throws InterruptedException {
        try {
            String result;
            try {
                result = this.launchCommand("merge-base", id1.name(), id2.name());
            }
            catch (GitException ge) {
                return null;
            }
            BufferedReader rdr = new BufferedReader(new StringReader(result));
            String line = rdr.readLine();
            if (line != null) {
                return ObjectId.fromString((String)line);
            }
        }
        catch (IOException e) {
            throw new GitException("Error parsing merge base", e);
        }
        catch (GitException e) {
            throw new GitException("Error parsing merge base", e);
        }
        return null;
    }

    @Override
    @Deprecated
    public String getAllLogEntries(String branch) throws InterruptedException {
        return this.launchCommand("log", "--all", "--pretty=format:'%H#%ct'", branch);
    }

    private String getGitCredentialsURL(URIish u, StandardCredentials cred) {
        String scheme = u.getScheme();
        URIish uri = new URIish().setScheme(scheme).setUser(u.getUser()).setPass(u.getPass()).setHost(u.getHost()).setPort(u.getPort());
        if (cred != null && cred instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials up = (StandardUsernamePasswordCredentials)cred;
            uri = uri.setUser(up.getUsername()).setPass(Secret.toString((Secret)up.getPassword()));
        }
        return uri.toPrivateString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkCredentials(URIish u, StandardCredentials cred) {
        Object defaultcreds;
        String url = u.toPrivateString();
        HttpClientBuilder clientBuilder = HttpClients.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (cred != null && cred instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials up = (StandardUsernamePasswordCredentials)cred;
            defaultcreds = new UsernamePasswordCredentials(up.getUsername(), Secret.toString((Secret)up.getPassword()));
        } else {
            defaultcreds = u.getUser() != null && u.getPass() != null ? new UsernamePasswordCredentials(u.getUser(), u.getPass()) : Netrc.getInstance().getCredentials(u.getHost());
        }
        if (defaultcreds != null) {
            AuthScope ntlmSchemeScope = new AuthScope(u.getHost(), u.getPort(), AuthScope.ANY_REALM, "NTLM");
            UsernamePasswordCredentials up = (UsernamePasswordCredentials)defaultcreds;
            NTCredentials ntCredentials = new NTCredentials(up.getUserName(), up.getPassword(), u.getHost(), "");
            credentialsProvider.setCredentials(ntlmSchemeScope, (Credentials)ntCredentials);
            credentialsProvider.setCredentials(AuthScope.ANY, defaultcreds);
        }
        if (this.proxy != null) {
            boolean shouldProxy = true;
            for (Pattern p : this.proxy.getNoProxyHostPatterns()) {
                if (!p.matcher(u.getHost()).matches()) continue;
                shouldProxy = false;
                break;
            }
            if (shouldProxy) {
                HttpHost proxyHost = new HttpHost(this.proxy.name, this.proxy.port);
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
                clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                if (this.proxy.getUserName() != null && this.proxy.getPassword() != null) {
                    credentialsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(this.proxy.getUserName(), this.proxy.getPassword()));
                }
            }
        }
        ArrayList<String> candidates = new ArrayList<String>();
        candidates.add(url + "/info/refs");
        candidates.add(url + "/info/refs?service=git-upload-pack");
        if (!url.endsWith(".git")) {
            candidates.add(url + ".git/info/refs");
            candidates.add(url + ".git/info/refs?service=git-upload-pack");
        }
        clientBuilder.setUserAgent("git/1.7.0");
        if (acceptSelfSignedCertificates && "https".equalsIgnoreCase(u.getScheme())) {
            SSLContextBuilder contextBuilder = SSLContexts.custom();
            try {
                contextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            }
            catch (NoSuchAlgorithmException e) {
                throw new GitException(e.getLocalizedMessage(), e);
            }
            catch (KeyStoreException e) {
                throw new GitException(e.getLocalizedMessage(), e);
            }
            SSLContext sslContext = null;
            try {
                sslContext = contextBuilder.build();
            }
            catch (KeyManagementException e) {
                throw new GitException(e.getLocalizedMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new GitException(e.getLocalizedMessage(), e);
            }
            clientBuilder.setSslcontext(sslContext);
        }
        CloseableHttpClient client = clientBuilder.build();
        int status = 0;
        try {
            try {
                for (String candidate : candidates) {
                    Object var15_24;
                    CloseableHttpResponse response;
                    block30: {
                        HttpGet get = new HttpGet(candidate);
                        response = client.execute((HttpUriRequest)get);
                        try {
                            status = response.getStatusLine().getStatusCode();
                            if (status != 200) break block30;
                            var15_24 = null;
                        }
                        catch (Throwable throwable) {
                            var15_24 = null;
                            response.close();
                            throw throwable;
                        }
                        response.close();
                        break;
                    }
                    var15_24 = null;
                    response.close();
                }
                if (status != 200) {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder().append("Failed to connect to ").append(u.toString());
                    if (cred != null) {
                        string = " using credentials " + cred.getDescription();
                        throw new GitException(stringBuilder.append(string).append(" (status = ").append(status).append(")").toString());
                    }
                    string = "";
                    throw new GitException(stringBuilder.append(string).append(" (status = ").append(status).append(")").toString());
                }
                Object var17_26 = null;
            }
            catch (SSLException e) {
                throw new GitException(e.getLocalizedMessage());
            }
            catch (IOException e) {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append("Failed to connect to ").append(u.toString());
                if (cred != null) {
                    string = " using credentials " + cred.getDescription();
                    throw new GitException(stringBuilder.append(string).append(" (exception: ").append(e).append(")").toString());
                }
                string = "";
                throw new GitException(stringBuilder.append(string).append(" (exception: ").append(e).append(")").toString());
            }
            catch (IllegalArgumentException e) {
                throw new GitException("Invalid URL " + u.toString());
            }
        }
        catch (Throwable throwable) {
            Object var17_27 = null;
            try {
                client.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new GitException(e.getLocalizedMessage());
            }
        }
        try {}
        catch (IOException e) {
            throw new GitException(e.getLocalizedMessage());
        }
        client.close();
    }
}

