/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.resolvers;

import com.google.common.collect.Maps;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jenkinsci.plugins.gwt.GenericVariable;
import org.jenkinsci.plugins.gwt.resolvers.FlattenerUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlFlattener {
    public Map<String, String> flatternXmlNode(GenericVariable gv, NodeList nodeList) throws Exception {
        HashMap resolvedVariables = Maps.newHashMap();
        if (nodeList.getLength() > 0) {
            boolean singleElementInNodeList = nodeList.getLength() == 1;
            resolvedVariables.put(gv.getVariableName(), this.toXmlString(nodeList.item(0)));
            for (int i = 0; i < nodeList.getLength(); ++i) {
                resolvedVariables.putAll(this.flattenXmlNode(gv.getVariableName(), gv.getRegexpFilter(), nodeList.item(i), i, singleElementInNodeList));
            }
        } else {
            resolvedVariables.put(gv.getVariableName(), "");
        }
        return resolvedVariables;
    }

    private String toXmlString(Node elem) throws Exception {
        StringWriter buf = new StringWriter();
        Transformer xform = TransformerFactory.newInstance().newTransformer();
        xform.setOutputProperty("omit-xml-declaration", "yes");
        xform.setOutputProperty("indent", "yes");
        xform.transform(new DOMSource(elem), new StreamResult(buf));
        return buf.toString();
    }

    private Map<String, String> flattenXmlNode(String parentKey, String regexFilter, Node node, int level, boolean fromRootLevel) {
        HashMap resolvedVariables = Maps.newHashMap();
        if (this.isXmlLeafNode(node)) {
            String noWhitespaces = FlattenerUtils.toVariableName(parentKey);
            resolvedVariables.put(noWhitespaces, FlattenerUtils.filter(node.getTextContent(), regexFilter));
        } else {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node childNode = node.getChildNodes().item(i);
                String childKey = this.expandKey(parentKey, level, fromRootLevel) + "_" + childNode.getNodeName();
                if (this.isXmlLeafNode(childNode)) {
                    String variableName = FlattenerUtils.toVariableName(childKey);
                    resolvedVariables.put(variableName, FlattenerUtils.filter(childNode.getTextContent(), regexFilter));
                    continue;
                }
                int leafNodeLevel = i / 2;
                resolvedVariables.putAll(this.flattenXmlNode(childKey, regexFilter, childNode, leafNodeLevel, false));
            }
        }
        return resolvedVariables;
    }

    private boolean isXmlLeafNode(Node node) {
        return node != null && (node.getNodeType() == 1 || node.getNodeType() == 2) && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3;
    }

    private String expandKey(String key, int level, boolean fromRootLevel) {
        if (fromRootLevel) {
            return key;
        }
        return key + "_" + level;
    }
}

