/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.jobfinder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import hudson.model.BuildAuthorizationToken;
import hudson.model.Item;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.plugins.gwt.FoundJob;
import org.jenkinsci.plugins.gwt.GenericTrigger;
import org.jenkinsci.plugins.gwt.global.CredentialsHelper;
import org.jenkinsci.plugins.gwt.jobfinder.JobFinderImpersonater;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class JobFinder {
    private static Logger LOG = Logger.getLogger(JobFinder.class.getSimpleName());
    private static JobFinderImpersonater jobFinderImpersonater = new JobFinderImpersonater();

    private JobFinder() {
    }

    @VisibleForTesting
    static void setJobFinderImpersonater(JobFinderImpersonater jobFinderImpersonater) {
        JobFinder.jobFinderImpersonater = jobFinderImpersonater;
    }

    public static List<FoundJob> findAllJobsWithTrigger(String givenToken) {
        ArrayList<FoundJob> found = new ArrayList<FoundJob>();
        boolean impersonate = !Strings.isNullOrEmpty((String)givenToken);
        List<ParameterizedJobMixIn.ParameterizedJob> candidateProjects = jobFinderImpersonater.getAllParameterizedJobs(impersonate);
        for (ParameterizedJobMixIn.ParameterizedJob candidateJob : candidateProjects) {
            GenericTrigger genericTriggerOpt = JobFinder.findGenericTrigger(candidateJob.getTriggers());
            if (genericTriggerOpt == null) continue;
            String configuredToken = JobFinder.determineTokenValue((Item)candidateJob, genericTriggerOpt.getToken(), genericTriggerOpt.getTokenCredentialId());
            boolean authenticationTokenMatches = JobFinder.authenticationTokenMatches(givenToken, candidateJob.getAuthToken(), configuredToken);
            if (!authenticationTokenMatches) continue;
            FoundJob foundJob = new FoundJob(candidateJob.getFullName(), genericTriggerOpt);
            found.add(foundJob);
        }
        return found;
    }

    private static String determineTokenValue(Item item, String token, String tokenCredentialsId) {
        Optional<StringCredentials> credentialsOpt;
        if (Strings.isNullOrEmpty((String)tokenCredentialsId)) {
            LOG.log(Level.FINE, "Found no credential configured in " + item.getFullDisplayName());
            return token;
        }
        if (!Strings.isNullOrEmpty((String)tokenCredentialsId) && !Strings.isNullOrEmpty((String)token)) {
            LOG.log(Level.WARNING, "The job " + item.getFullDisplayName() + " is configured with both static token and token from credential " + tokenCredentialsId + ".");
        }
        if ((credentialsOpt = CredentialsHelper.findCredentials(tokenCredentialsId)).isPresent()) {
            LOG.log(Level.FINE, "Found credential from " + tokenCredentialsId + " configured in " + item.getFullDisplayName());
            return ((StringCredentials)credentialsOpt.get()).getSecret().getPlainText();
        }
        LOG.log(Level.SEVERE, "Cannot find credential (" + tokenCredentialsId + ") configured in " + item.getFullDisplayName());
        return token;
    }

    private static boolean authenticationTokenMatches(String givenToken, BuildAuthorizationToken authToken, String genericToken) {
        boolean noTokenGiven = Strings.isNullOrEmpty((String)givenToken);
        boolean noKindOfTokenConfigured = Strings.isNullOrEmpty((String)genericToken) && !JobFinder.jobHasAuthToken(authToken);
        boolean genericTokenNotConfigured = Strings.isNullOrEmpty((String)genericToken);
        boolean authTokenNotConfigured = !JobFinder.jobHasAuthToken(authToken);
        return genericTokenNotConfigured && JobFinder.authenticationTokenMatches(authToken, givenToken) || authTokenNotConfigured && JobFinder.authenticationTokenMatchesGeneric(genericToken, givenToken) || noTokenGiven && noKindOfTokenConfigured;
    }

    private static boolean authenticationTokenMatchesGeneric(String token, String givenToken) {
        boolean authTokenWasGiven;
        boolean jobHasAuthToken = !Strings.isNullOrEmpty((String)token);
        boolean bl = authTokenWasGiven = !Strings.isNullOrEmpty((String)givenToken);
        if (jobHasAuthToken && authTokenWasGiven) {
            return token.equals(givenToken);
        }
        return !jobHasAuthToken && !authTokenWasGiven;
    }

    private static boolean authenticationTokenMatches(BuildAuthorizationToken authToken, String givenToken) {
        boolean authTokenWasGiven;
        boolean jobHasAuthToken = JobFinder.jobHasAuthToken(authToken);
        boolean bl = authTokenWasGiven = !Strings.isNullOrEmpty((String)givenToken);
        if (jobHasAuthToken && authTokenWasGiven) {
            return authToken.getToken().equals(givenToken);
        }
        return !jobHasAuthToken && !authTokenWasGiven;
    }

    private static boolean jobHasAuthToken(BuildAuthorizationToken authToken) {
        return authToken != null && !Strings.isNullOrEmpty((String)authToken.getToken());
    }

    private static GenericTrigger findGenericTrigger(Map<TriggerDescriptor, Trigger<?>> triggers) {
        if (triggers == null) {
            return null;
        }
        for (Trigger<?> candidate : triggers.values()) {
            if (!(candidate instanceof GenericTrigger)) continue;
            return (GenericTrigger)candidate;
        }
        return null;
    }
}

