/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt;

import com.cloudbees.plugins.credentials.CredentialsParameterValue;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import hudson.model.BooleanParameterValue;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ParameterActionUtil {
    public static ParametersAction createParameterAction(ParametersDefinitionProperty parametersDefinitionProperty, Map<String, String> resolvedVariables) {
        List<ParameterValue> parameterList = ParameterActionUtil.getParametersWithRespectToDefaultValues(parametersDefinitionProperty, resolvedVariables);
        return new ParametersAction(parameterList);
    }

    static List<ParameterValue> getParametersWithRespectToDefaultValues(ParametersDefinitionProperty parametersDefinitionProperty, Map<String, String> resolvedVariables) {
        ArrayList parameterList = Lists.newArrayList();
        if (parametersDefinitionProperty != null) {
            for (ParameterDefinition parameterDefinition : parametersDefinitionProperty.getParameterDefinitions()) {
                String paramName = parameterDefinition.getName();
                ParameterValue defaultParameterValue = parameterDefinition.getDefaultParameterValue();
                if (defaultParameterValue == null) continue;
                ParameterValue parameterValue = ParameterActionUtil.getParameterValue(resolvedVariables, parameterDefinition, paramName, defaultParameterValue);
                parameterList.add(parameterValue);
            }
        }
        return parameterList;
    }

    private static ParameterValue getParameterValue(Map<String, String> resolvedVariables, ParameterDefinition parameterDefinition, String paramName, ParameterValue defaultParameterValue) {
        String stringValue = ParameterActionUtil.getStringValue(resolvedVariables, paramName, defaultParameterValue);
        if (defaultParameterValue.getValue() instanceof Boolean) {
            return new BooleanParameterValue(paramName, Boolean.parseBoolean(stringValue), parameterDefinition.getDescription());
        }
        if (defaultParameterValue instanceof CredentialsParameterValue) {
            return new CredentialsParameterValue(paramName, stringValue, parameterDefinition.getDescription());
        }
        return new StringParameterValue(paramName, stringValue, parameterDefinition.getDescription());
    }

    private static String getStringValue(Map<String, String> resolvedVariables, String param, ParameterValue defaultParameterValue) {
        if (!Strings.isNullOrEmpty((String)resolvedVariables.get(param))) {
            return resolvedVariables.get(param);
        }
        if (defaultParameterValue.getValue() == null) {
            return "";
        }
        return defaultParameterValue.getValue().toString();
    }
}

